/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.AntMain;

public class Main
implements AntMain {
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private Vector targets = new Vector();
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(1);
    private Vector propertyFiles = new Vector(1);
    private boolean allowInput = true;
    private boolean keepGoingMode = false;
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed = false;
    private Integer threadPriority = null;
    private static String antVersion = null;
    static /* synthetic */ Class class$0;

    private static void printMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null) {
            System.err.println(message);
        }
    }

    public static void start(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        Main m = new Main();
        m.startAnt(args, additionalUserProperties, coreLoader);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startAnt(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        Object var6_11;
        try {
            Diagnostics.validateVersion();
            this.processArgs(args);
        }
        catch (Throwable exc) {
            Main.handleLogfile();
            Main.printMessage(exc);
            System.exit(1);
        }
        if (additionalUserProperties != null) {
            Enumeration<Object> e = additionalUserProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String property = additionalUserProperties.getProperty(key);
                this.definedProps.put(key, property);
            }
        }
        int exitCode = 1;
        try {
            try {
                try {
                    this.runBuild(coreLoader);
                    exitCode = 0;
                }
                catch (ExitStatusException ese) {
                    exitCode = ese.getStatus();
                    if (exitCode != 0) {
                        throw ese;
                    }
                }
            }
            catch (BuildException be) {
                if (err != System.err) {
                    Main.printMessage(be);
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace();
                Main.printMessage(exc);
            }
        }
        catch (Throwable throwable) {
            var6_11 = null;
            Main.handleLogfile();
            throw throwable;
        }
        {
            var6_11 = null;
        }
        Main.handleLogfile();
    }

    private static void handleLogfile() {
        if (isLogFileUsed) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        Main.start(args, null, null);
    }

    public Main() {
    }

    protected Main(String[] args) throws BuildException {
        this.processArgs(args);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processArgs(String[] args) {
        String searchForThis = null;
        PrintStream logTo = null;
        int i = 0;
        while (true) {
            if (i >= args.length) {
                if (this.buildFile != null) break;
                this.buildFile = searchForThis != null ? this.findBuildFile(System.getProperty("user.dir"), searchForThis) : new File(DEFAULT_BUILD_FILENAME);
            }
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("-h")) {
                Main.printUsage();
                return;
            }
            if (arg.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("-diagnostics")) {
                Diagnostics.doReport((PrintStream)System.out);
                return;
            }
            if (arg.equals("-quiet") || arg.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (arg.equals("-verbose") || arg.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
            } else if (arg.equals("-debug") || arg.equals("-d")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
            } else if (arg.equals("-noinput")) {
                this.allowInput = false;
            } else {
                String msg;
                if (arg.equals("-logfile") || arg.equals("-l")) {
                    try {
                        File logFile = new File(args[i + 1]);
                        ++i;
                        logTo = new PrintStream(new FileOutputStream(logFile));
                        isLogFileUsed = true;
                    }
                    catch (IOException iOException) {
                        msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                        throw new BuildException(msg);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        msg = "You must specify a log file when using the -log argument";
                        throw new BuildException(msg);
                    }
                }
                if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f")) {
                    try {
                        this.buildFile = new File(args[i + 1].replace('/', File.separatorChar));
                        ++i;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        msg = "You must specify a buildfile when using the -buildfile argument";
                        throw new BuildException(msg);
                    }
                }
                if (arg.equals("-listener")) {
                    try {
                        this.listeners.addElement(args[i + 1]);
                        ++i;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        msg = "You must specify a classname when using the -listener argument";
                        throw new BuildException(msg);
                    }
                }
                if (arg.startsWith("-D")) {
                    String name = arg.substring(2, arg.length());
                    String value = null;
                    int posEq = name.indexOf("=");
                    if (posEq > 0) {
                        value = name.substring(posEq + 1);
                        name = name.substring(0, posEq);
                    } else {
                        if (i >= args.length - 1) throw new BuildException("Missing value for property " + name);
                        value = args[++i];
                    }
                    this.definedProps.put(name, value);
                } else {
                    if (arg.equals("-logger")) {
                        if (this.loggerClassname != null) {
                            throw new BuildException("Only one logger class may  be specified.");
                        }
                        try {
                            this.loggerClassname = args[++i];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new BuildException("You must specify a classname when using the -logger argument");
                        }
                    }
                    if (arg.equals("-inputhandler")) {
                        if (this.inputHandlerClassname != null) {
                            throw new BuildException("Only one input handler class may be specified.");
                        }
                        try {
                            this.inputHandlerClassname = args[++i];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new BuildException("You must specify a classname when using the -inputhandler argument");
                        }
                    }
                    if (arg.equals("-emacs") || arg.equals("-e")) {
                        this.emacsMode = true;
                    } else if (arg.equals("-projecthelp") || arg.equals("-p")) {
                        this.projectHelp = true;
                    } else if (arg.equals("-find") || arg.equals("-s")) {
                        searchForThis = i < args.length - 1 ? args[++i] : DEFAULT_BUILD_FILENAME;
                    } else {
                        if (arg.startsWith("-propertyfile")) {
                            try {
                                this.propertyFiles.addElement(args[i + 1]);
                                ++i;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                msg = "You must specify a property filename when using the -propertyfile argument";
                                throw new BuildException(msg);
                            }
                        }
                        if (arg.equals("-k") || arg.equals("-keep-going")) {
                            this.keepGoingMode = true;
                        } else if (arg.equals("-nice")) {
                            try {
                                this.threadPriority = Integer.decode(args[i + 1]);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw new BuildException("You must supply a niceness value (1-10) after the -nice option");
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new BuildException("Unrecognized niceness value: " + args[i + 1]);
                            }
                            ++i;
                            if (this.threadPriority < 1) throw new BuildException("Niceness value is out of the range 1-10");
                            if (this.threadPriority > 10) {
                                throw new BuildException("Niceness value is out of the range 1-10");
                            }
                        } else {
                            if (arg.startsWith("-")) {
                                msg = "Unknown argument: " + arg;
                                System.out.println(msg);
                                Main.printUsage();
                                throw new BuildException("");
                            }
                            this.targets.addElement(arg);
                        }
                    }
                }
            }
            ++i;
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        int propertyFileIndex = 0;
        block25: while (true) {
            Properties props;
            block69: {
                Object var9_11;
                if (propertyFileIndex >= this.propertyFiles.size()) {
                    if (this.msgOutputLevel >= 2) {
                        System.out.println("Buildfile: " + this.buildFile);
                    }
                    if (logTo != null) {
                        out = logTo;
                        err = logTo;
                        System.setOut(out);
                        System.setErr(err);
                    }
                    this.readyToRun = true;
                    return;
                }
                String filename = (String)this.propertyFiles.elementAt(propertyFileIndex);
                props = new Properties();
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(filename);
                        props.load(fis);
                    }
                    catch (IOException e) {
                        System.out.println("Could not load property file " + filename + ": " + e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var9_11 = null;
                    if (fis == null) break block69;
                }
                try {}
                catch (IOException iOException) {}
                fis.close();
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (true) {
                if (!propertyNames.hasMoreElements()) {
                    ++propertyFileIndex;
                    continue block25;
                }
                String name = (String)propertyNames.nextElement();
                if (this.definedProps.getProperty(name) != null) continue;
                this.definedProps.put(name, props.getProperty(name));
            }
            break;
        }
    }

    private File getParentFile(File file) {
        File parent = file.getParentFile();
        if (parent != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + parent.getAbsolutePath());
        }
        return parent;
    }

    private File findBuildFile(String start, String suffix) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + suffix + " ...");
        }
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runBuild(ClassLoader coreLoader) throws BuildException {
        Throwable error;
        Project project;
        block26: {
            if (!this.readyToRun) {
                return;
            }
            project = new Project();
            project.setCoreLoader(coreLoader);
            error = null;
            try {
                try {
                    InputStream in;
                    block25: {
                        SecurityManager oldsm;
                        block23: {
                            block24: {
                                this.addBuildListeners(project);
                                this.addInputHandler(project);
                                in = System.in;
                                oldsm = null;
                                oldsm = System.getSecurityManager();
                                try {
                                    if (this.allowInput) {
                                        project.setDefaultInputStream(System.in);
                                    }
                                    System.setIn((InputStream)new DemuxInputStream(project));
                                    System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(project, false)));
                                    System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
                                    if (!this.projectHelp) {
                                        project.fireBuildStarted();
                                    }
                                    if (this.threadPriority != null) {
                                        try {
                                            project.log("Setting Ant's thread priority to " + this.threadPriority, 3);
                                            Thread.currentThread().setPriority(this.threadPriority);
                                        }
                                        catch (SecurityException securityException) {
                                            project.log("A security manager refused to set the -nice value");
                                        }
                                    }
                                    project.init();
                                    project.setUserProperty("ant.version", Main.getAntVersion());
                                    Enumeration<Object> e = this.definedProps.keys();
                                    while (true) {
                                        if (!e.hasMoreElements()) {
                                            project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                                            project.setKeepGoingMode(this.keepGoingMode);
                                            ProjectHelper helper = ProjectHelper.getProjectHelper();
                                            project.addReference("ant.projectHelper", (Object)helper);
                                            helper.parse(project, (Object)this.buildFile);
                                            if (this.projectHelp) {
                                                Main.printDescription(project);
                                            }
                                            break block23;
                                        }
                                        String arg = (String)e.nextElement();
                                        String value = (String)this.definedProps.get(arg);
                                        project.setUserProperty(arg, value);
                                    }
                                    Main.printTargets(project, this.msgOutputLevel > 2);
                                    Object var9_11 = null;
                                    if (oldsm == null) break block24;
                                }
                                catch (Throwable throwable) {
                                    Object var9_12 = null;
                                    if (oldsm != null) {
                                        System.setSecurityManager(oldsm);
                                    }
                                    System.setOut(out);
                                    System.setErr(err);
                                    System.setIn(in);
                                    throw throwable;
                                }
                                System.setSecurityManager(oldsm);
                            }
                            System.setOut(out);
                            System.setErr(err);
                            System.setIn(in);
                            Object var11_14 = null;
                            if (!this.projectHelp) {
                                project.fireBuildFinished(error);
                                return;
                            }
                            if (error == null) return;
                            project.log(error.toString(), 0);
                            return;
                        }
                        if (this.targets.size() == 0 && project.getDefaultTarget() != null) {
                            this.targets.addElement(project.getDefaultTarget());
                        }
                        project.executeTargets(this.targets);
                        Object var9_13 = null;
                        if (oldsm == null) break block25;
                        System.setSecurityManager(oldsm);
                    }
                    System.setOut(out);
                    System.setErr(err);
                    System.setIn(in);
                }
                catch (RuntimeException exc) {
                    error = exc;
                    throw exc;
                }
                catch (Error anErr) {
                    error = anErr;
                    throw anErr;
                }
                Object var11_16 = null;
                if (this.projectHelp) break block26;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (!this.projectHelp) {
                    project.fireBuildFinished(error);
                    throw throwable;
                }
                if (error == null) throw throwable;
                project.log(error.toString(), 0);
                throw throwable;
            }
            project.fireBuildFinished(error);
            return;
        }
        if (error == null) return;
        project.log(error.toString(), 0);
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener((BuildListener)this.createLogger());
        int i = 0;
        while (i < this.listeners.size()) {
            String className = (String)this.listeners.elementAt(i);
            try {
                BuildListener listener = (BuildListener)Class.forName(className).newInstance();
                if (project != null) {
                    project.setProjectReference((Object)listener);
                }
                project.addBuildListener(listener);
            }
            catch (Throwable exc) {
                throw new BuildException("Unable to instantiate listener " + className, exc);
            }
            ++i;
        }
    }

    private void addInputHandler(Project project) throws BuildException {
        DefaultInputHandler handler = null;
        if (this.inputHandlerClassname == null) {
            handler = new DefaultInputHandler();
        } else {
            try {
                handler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
                if (project != null) {
                    project.setProjectReference((Object)handler);
                }
            }
            catch (ClassCastException classCastException) {
                String msg = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(msg);
            }
            catch (Exception e) {
                String msg = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + e.getClass().getName();
                throw new BuildException(msg);
            }
        }
        project.setInputHandler((InputHandler)handler);
    }

    private BuildLogger createLogger() {
        DefaultLogger logger = null;
        if (this.loggerClassname != null) {
            try {
                Class<?> loggerClass = Class.forName(this.loggerClassname);
                logger = (BuildLogger)loggerClass.newInstance();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception e) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + e.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            logger = new DefaultLogger();
        }
        logger.setMessageOutputLevel(this.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.emacsMode);
        return logger;
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [options] [target [target2 [target3] ...]]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help, -h              print this message" + lSep);
        msg.append("  -projecthelp, -p       print project help information" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -diagnostics           print information that might be helpful to" + lSep);
        msg.append("                         diagnose or report problems." + lSep);
        msg.append("  -quiet, -q             be extra quiet" + lSep);
        msg.append("  -verbose, -v           be extra verbose" + lSep);
        msg.append("  -debug, -d             print debugging information" + lSep);
        msg.append("  -emacs, -e             produce logging information without adornments" + lSep);
        msg.append("  -lib <path>            specifies a path to search for jars and classes" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("    -l     <file>                ''" + lSep);
        msg.append("  -logger <classname>    the class which is to perform logging" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -noinput               do not allow interactive input" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("    -file    <file>              ''" + lSep);
        msg.append("    -f       <file>              ''" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        msg.append("  -keep-going, -k        execute all targets that do not depend" + lSep);
        msg.append("                         on failed target(s)" + lSep);
        msg.append("  -propertyfile <name>   load all properties from file with -D" + lSep);
        msg.append("                         properties taking precedence" + lSep);
        msg.append("  -inputhandler <class>  the class which will handle input requests" + lSep);
        msg.append("  -find <file>           (s)earch for buildfile towards the root of" + lSep);
        msg.append("    -s  <file>           the filesystem and use it" + lSep);
        msg.append("  -nice  number          A niceness value for the main thread:" + lSep + "                         1 (lowest) to 10 (highest); 5 is the default" + lSep);
        msg.append("  -nouserlib             Run ant without using the jar files from" + lSep + "                         ${user.home}/.ant/lib" + lSep);
        msg.append("  -noclasspath           Run ant without using CLASSPATH");
        System.out.println(msg.toString());
    }

    private static void printVersion() throws BuildException {
        System.out.println(Main.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties props = new Properties();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wtp.releng.wtpbuilder.Main");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream in = clazz.getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                StringBuffer msg = new StringBuffer();
                msg.append("Apache Ant version ");
                msg.append(props.getProperty("VERSION"));
                msg.append(" compiled on ");
                msg.append(props.getProperty("DATE"));
                antVersion = msg.toString();
            }
            catch (IOException ioe) {
                throw new BuildException("Could not load the version information:" + ioe.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static void printTargets(Project project, boolean printSubTargets) {
        String defaultTarget;
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        while (ptargets.hasMoreElements()) {
            int pos;
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            if (targetName.equals("")) continue;
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = Main.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = Main.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Main.printTargets(project, topNames, topDescriptions, "Main targets:", maxLength);
        if (topNames.size() == 0) {
            printSubTargets = true;
        }
        if (printSubTargets) {
            Main.printTargets(project, subNames, null, "Other targets:", 0);
        }
        if ((defaultTarget = project.getDefaultTarget()) != null && !"".equals(defaultTarget)) {
            project.log("Default target: " + defaultTarget);
        }
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        int i = 0;
        while (i < names.size() && res == names.size()) {
            if (name.compareTo((String)names.elementAt(i)) < 0) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    private static void printTargets(Project project, Vector names, Vector descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() <= maxlen) {
            spaces = String.valueOf(spaces) + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(String.valueOf(heading) + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
            ++i;
        }
        project.log(msg.toString());
    }
}

