/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentRef;
import org.eclipse.wtp.releng.tools.component.internal.Description;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentXML {
    public static final String CONST_COMPONENT_XML = "component.xml";
    private static final String NS = "http://eclipse.org/wtp/releng/tools/component-model";
    private static final String ELEMENT_COMPONENT = "component";
    private static final String ELEMENT_PLUGIN = "plugin";
    private static final String ELEMENT_PACKAGE = "package";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_COMPONENT_DEPENDS = "component-depends";
    private static final String ELEMENT_COMPONENT_REF = "component-ref";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FRAGMENT = "fragment";
    private static final String ATTR_ID = "id";
    private static final String ATTR_API = "api";
    private static final String ATTR_EXCLUSIVE = "exclusive";
    private static final String ATTR_UNRESTRICTED = "unrestricted";
    private static final String ATTR_REFERENCE = "reference";
    private static final String ATTR_IMPLEMENT = "implement";
    private static final String ATTR_SUBCLASS = "subclass";
    private static final String ATTR_INSTANTIATE = "instantiate";
    private static final String ATTR_URL = "url";
    private ILocation location;
    private boolean loaded = false;
    private String name;
    private Description description;
    private Map plugins;
    private Map packages;
    private ComponentDepends componentDepends;

    public ILocation getLocation() {
        return this.location;
    }

    public void setLocation(ILocation location) {
        this.location = location;
        this.loaded = false;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public ComponentDepends getComponentDepends() {
        return this.componentDepends;
    }

    public void setComponentDepends(ComponentDepends componentDepends) {
        this.componentDepends = componentDepends;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection getPackages() {
        if (this.packages == null) {
            this.packages = new HashMap(1);
        }
        return this.packages.values();
    }

    public Package getPackage(String name) {
        if (this.packages == null) {
            return null;
        }
        return (Package)this.packages.get(name);
    }

    public void addPackage(Package pkg) {
        if (this.packages == null) {
            this.packages = new HashMap(1);
        }
        this.packages.put(pkg.getName(), pkg);
    }

    public Collection getPlugins() {
        if (this.plugins == null) {
            this.plugins = new HashMap(1);
        }
        return this.plugins.values();
    }

    public Plugin getPlugin(String id) {
        if (this.plugins == null) {
            return null;
        }
        return (Plugin)this.plugins.get(id);
    }

    public void addPlugin(Plugin plugin) {
        if (this.plugins == null) {
            this.plugins = new HashMap(1);
        }
        this.plugins.put(plugin.getId(), plugin);
    }

    public void load() throws IOException, FileNotFoundException {
        if (!this.loaded) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(new BufferedInputStream(this.location.getInputStream())), (DefaultHandler)new ComponentXMLHandler(this));
                this.loaded = true;
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<component ");
        this.saveAttribute(sb, ATTR_XMLNS, NS);
        this.saveAttribute(sb, ATTR_NAME, this.getName());
        sb.append(">");
        if (this.description != null) {
            sb.append(this.description.toString());
        }
        this.saveComponentDepends(sb, this.getComponentDepends());
        Iterator it = this.getPlugins().iterator();
        while (it.hasNext()) {
            this.savePlugin(sb, (Plugin)it.next());
        }
        it = this.getPackages().iterator();
        while (it.hasNext()) {
            this.savePackage(sb, (Package)it.next());
        }
        sb.append("</component>");
        return sb.toString();
    }

    public void save() throws IOException {
        if (this.location != null) {
            File file = new File(this.location.getAbsolutePath());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.toString().getBytes("UTF-8"));
            fos.close();
        }
    }

    private void saveComponentDepends(StringBuffer sb, ComponentDepends dep) {
        sb.append("<component-depends");
        if (dep.getUnrestricted() != null) {
            this.saveAttribute(sb, ATTR_UNRESTRICTED, String.valueOf(dep.isUnrestricted()));
        }
        sb.append(">");
        Iterator it = dep.getComponentRefs().iterator();
        while (it.hasNext()) {
            this.saveComponentRef(sb, (ComponentRef)it.next());
        }
        sb.append("</component-depends>");
    }

    private void saveComponentRef(StringBuffer sb, ComponentRef ref) {
        sb.append("<component-ref");
        this.saveAttribute(sb, ATTR_NAME, ref.getName());
        sb.append("/>");
    }

    private void savePlugin(StringBuffer sb, Plugin plugin) {
        sb.append("<plugin");
        this.saveAttribute(sb, ATTR_ID, plugin.getId());
        if (plugin.getFragment() != null) {
            this.saveAttribute(sb, ATTR_FRAGMENT, String.valueOf(plugin.isFragment()));
        }
        sb.append("/>");
    }

    private void savePackage(StringBuffer sb, Package pkg) {
        sb.append("<package");
        this.saveAttribute(sb, ATTR_NAME, pkg.getName());
        if (pkg.getApi() != null) {
            this.saveAttribute(sb, ATTR_API, String.valueOf(pkg.isApi()));
        }
        if (pkg.getExclusive() != null) {
            this.saveAttribute(sb, ATTR_EXCLUSIVE, String.valueOf(pkg.isExclusive()));
        }
        sb.append(">");
        Iterator it = pkg.getTypes().iterator();
        while (it.hasNext()) {
            this.saveType(sb, (Type)it.next());
        }
        sb.append("</package>");
    }

    private void saveType(StringBuffer sb, Type type) {
        sb.append("<type");
        this.saveAttribute(sb, ATTR_NAME, type.getName());
        if (type.getReference() != null) {
            this.saveAttribute(sb, ATTR_REFERENCE, String.valueOf(type.isReference()));
        }
        if (type.getImplement() != null) {
            this.saveAttribute(sb, ATTR_IMPLEMENT, String.valueOf(type.isImplement()));
        }
        if (type.getSubclass() != null) {
            this.saveAttribute(sb, ATTR_SUBCLASS, String.valueOf(type.isSubclass()));
        }
        if (type.getInstantiate() != null) {
            this.saveAttribute(sb, ATTR_INSTANTIATE, String.valueOf(type.isInstantiate()));
        }
        sb.append("/>");
    }

    private void saveAttribute(StringBuffer sb, String key, String value) {
        if (key != null && value != null) {
            sb.append(" ");
            sb.append(key);
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
    }

    public Object clone() {
        Iterator it;
        ComponentXML clone = new ComponentXML();
        clone.setName(this.getName());
        clone.setLocation(this.getLocation());
        clone.setDescription(this.getDescription());
        ComponentDepends depends = this.getComponentDepends();
        if (depends != null) {
            clone.setComponentDepends((ComponentDepends)depends.clone());
        }
        if (this.plugins != null) {
            it = this.getPlugins().iterator();
            while (it.hasNext()) {
                clone.addPlugin((Plugin)((Plugin)it.next()).clone());
            }
        }
        if (this.packages != null) {
            it = this.getPackages().iterator();
            while (it.hasNext()) {
                clone.addPackage((Package)((Package)it.next()).clone());
            }
        }
        return clone;
    }

    private static class ComponentXMLHandler
    extends DefaultHandler {
        private ComponentXML compXML;
        private Package pkg;

        public ComponentXMLHandler(ComponentXML compXML) {
            this.compXML = compXML;
            this.compXML.setComponentDepends(new ComponentDepends());
            this.compXML.setName(null);
            this.compXML.getPlugins().clear();
            this.compXML.getPackages().clear();
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_PLUGIN) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_PLUGIN)) {
                Plugin plugin = new Plugin();
                plugin.setId(attributes.getValue(ComponentXML.ATTR_ID));
                String attrFragment = attributes.getValue(ComponentXML.ATTR_FRAGMENT);
                if (attrFragment != null) {
                    plugin.setFragment(Boolean.valueOf(attrFragment));
                }
                this.compXML.addPlugin(plugin);
            } else if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_PACKAGE) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_PACKAGE)) {
                String attrExclusive;
                this.pkg = new Package();
                this.pkg.setName(attributes.getValue(ComponentXML.ATTR_NAME));
                String attrApi = attributes.getValue(ComponentXML.ATTR_API);
                if (attrApi != null) {
                    this.pkg.setApi(Boolean.valueOf(attrApi));
                }
                if ((attrExclusive = attributes.getValue(ComponentXML.ATTR_EXCLUSIVE)) != null) {
                    this.pkg.setExclusive(Boolean.valueOf(attrExclusive));
                }
                this.compXML.addPackage(this.pkg);
            } else if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_TYPE) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_TYPE)) {
                if (this.pkg != null) {
                    String attrInstantiate;
                    String attrSubclass;
                    String attrImpl;
                    Type type = new Type();
                    type.setName(attributes.getValue(ComponentXML.ATTR_NAME));
                    String attrRef = attributes.getValue(ComponentXML.ATTR_REFERENCE);
                    if (attrRef != null) {
                        type.setReference(Boolean.valueOf(attrRef));
                    }
                    if ((attrImpl = attributes.getValue(ComponentXML.ATTR_IMPLEMENT)) != null) {
                        type.setImplement(Boolean.valueOf(attrImpl));
                    }
                    if ((attrSubclass = attributes.getValue(ComponentXML.ATTR_SUBCLASS)) != null) {
                        type.setSubclass(Boolean.valueOf(attrSubclass));
                    }
                    if ((attrInstantiate = attributes.getValue(ComponentXML.ATTR_INSTANTIATE)) != null) {
                        type.setInstantiate(Boolean.valueOf(attrInstantiate));
                    }
                    this.pkg.addType(type);
                }
            } else if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_COMPONENT) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_COMPONENT)) {
                this.compXML.setName(attributes.getValue(ComponentXML.ATTR_NAME));
            } else if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_COMPONENT_DEPENDS) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_COMPONENT_DEPENDS)) {
                String attrUnrestricted = attributes.getValue(ComponentXML.ATTR_UNRESTRICTED);
                if (attrUnrestricted != null) {
                    this.compXML.getComponentDepends().setUnrestricted(Boolean.valueOf(attrUnrestricted));
                }
            } else if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_COMPONENT_REF) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_COMPONENT_REF)) {
                ComponentRef compRef = new ComponentRef();
                compRef.setName(attributes.getValue(ComponentXML.ATTR_NAME));
                this.compXML.getComponentDepends().addComponentRef(compRef);
            } else if (this.equalsLocalpart(qName, ComponentXML.ELEMENT_DESCRIPTION) || this.equalsLocalpart(elementName, ComponentXML.ELEMENT_DESCRIPTION)) {
                Description desc = new Description();
                desc.setUrl(attributes.getValue(ComponentXML.ATTR_URL));
                this.compXML.setDescription(desc);
            }
        }

        private boolean equalsLocalpart(String fullname, String localpart) {
            int index = fullname.indexOf(58);
            if (index != -1) {
                return fullname.substring(index + 1).equals(localpart);
            }
            return fullname.equals(localpart);
        }
    }
}

