/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;

public class PIAgentFiltersEmitter
extends AbstractEmitter {
    List eclipseDirs;
    List compXMLDirs;
    String outputFile;
    Map id2Plugin;
    Map id2Fragment;
    List includes;
    List packages;

    public PIAgentFiltersEmitter(List eclipseDirs, List compXMLDirs, String outputFile) {
        this.eclipseDirs = eclipseDirs;
        this.compXMLDirs = compXMLDirs;
        this.outputFile = outputFile;
        this.packages = new ArrayList();
        this.id2Plugin = new HashMap();
        this.id2Fragment = new HashMap();
        Iterator it = eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.id2Plugin, this.id2Fragment);
        }
        this.linkPluginsAndFragments(this.id2Plugin, this.id2Fragment);
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void genFilters() {
        File file;
        Iterator it = this.compXMLDirs.iterator();
        while (it.hasNext()) {
            file = new File(this.addTrailingSeperator((String)it.next()));
            if (!file.exists()) continue;
            this.getPackages(file);
        }
        BufferedWriter bw = null;
        try {
            try {
                file = new File(this.outputFile);
                file.getParentFile().mkdirs();
                bw = new BufferedWriter(new FileWriter(file));
                Iterator it2 = this.packages.iterator();
                while (true) {
                    if (!it2.hasNext()) {
                        bw.write("* * EXCLUDE");
                        bw.newLine();
                    }
                    bw.write((String)it2.next());
                    bw.write(".* * INCLUDE");
                    bw.newLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (bw == null) throw throwable;
                bw.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (bw == null) return;
        bw.close();
    }

    private void getPackages(File file) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.getPackages(files[i]);
                    ++i;
                }
                break block6;
            }
            if (!"component.xml".equalsIgnoreCase(file.getName())) break block6;
            try {
                ComponentXML compXML = new ComponentXML();
                compXML.setLocation(new FileLocation(file));
                compXML.load();
                Iterator it = compXML.getPackages().iterator();
                while (it.hasNext()) {
                    Package pkg = (Package)it.next();
                    String pkgName = pkg.getName();
                    if (!this.includePackage(pkgName)) continue;
                    this.packages.add(pkgName);
                }
                it = compXML.getPlugins().iterator();
                while (it.hasNext()) {
                    String pluginId = ((Plugin)it.next()).getId();
                    IPluginXML plugin = (IPluginXML)this.id2Plugin.get(pluginId);
                    if (plugin == null) continue;
                    plugin.accept(new IClazzVisitor(){

                        public boolean visit(IClazz clazz) {
                            String classPkg;
                            String className = clazz.getName();
                            int dot = className.lastIndexOf(".");
                            if (dot != -1 && !PIAgentFiltersEmitter.this.packages.contains(classPkg = className.substring(0, dot))) {
                                String[] interfaces = clazz.getInterfaces();
                                int i = 0;
                                while (i < interfaces.length) {
                                    String interfacePkg;
                                    dot = interfaces[i].lastIndexOf(".");
                                    if (dot != -1 && PIAgentFiltersEmitter.this.packages.contains(interfacePkg = interfaces[i].substring(0, dot))) {
                                        PIAgentFiltersEmitter.this.packages.add(classPkg);
                                        return true;
                                    }
                                    ++i;
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean includePackage(String pkg) {
        if (this.includes != null) {
            Iterator it = this.includes.iterator();
            while (it.hasNext()) {
                if (!pkg.startsWith((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List eclipseDirs = (List)options.get("eclipseDirs");
        List compXMLDirs = (List)options.get("compXMLDirs");
        List outputDir = (List)options.get("outputFile");
        List includes = (List)options.get("includes");
        if (eclipseDirs == null || compXMLDirs == null || outputDir == null || eclipseDirs.size() < 1 || compXMLDirs.size() < 1 || outputDir.size() < 1) {
            PIAgentFiltersEmitter.printUsage();
            System.exit(-1);
        }
        PIAgentFiltersEmitter emitter = new PIAgentFiltersEmitter(eclipseDirs, compXMLDirs, (String)outputDir.get(0));
        emitter.setIncludes(includes);
        emitter.genFilters();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.piagent.PIAgentFilterEmitter -compXMLDirs <compXMLDirs> -outputFile <outputFile>");
        System.out.println("");
        System.out.println("\t-eclipseDirs\t<eclipseDirs>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-compXMLDirs\t<compXMLDirs>\tspace seperated list of directories containing component.xml");
        System.out.println("\t-outputFile\t<outputFile>\toutput PIAgent filters file");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tpackages to include");
    }
}

