/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.compatibility;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.compatibility.APICompatibility;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;

public class APICompatibilitySummary
extends ComponentSummary {
    private static final String ROOT_TAG_NAME = "api-compatibility-summary";

    public void add(APICompatibility apiCompatibility) {
        APICompatibilityEntry entry = new APICompatibilityEntry();
        entry.setCompName(apiCompatibility.getName());
        entry.setNewAPICount(apiCompatibility.getNewAPIs().size());
        entry.setRemovedAPICount(apiCompatibility.getRemovedAPIs().size());
        String ref = apiCompatibility.getLocation().getAbsolutePath();
        entry.setRef(ref);
        this.add(entry);
    }

    public void saveAsHTML(ILocation html) throws TransformerConfigurationException, TransformerException, IOException {
        String user_dir = "user.dir";
        String currUserDir = System.getProperty(user_dir);
        System.setProperty(user_dir, ((IFileLocation)html).getFile().getParentFile().getAbsolutePath());
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-compatibility-summary.xsl")));
        transformer.transform(new StreamSource(new ByteArrayInputStream(this.getBytes(html, ROOT_TAG_NAME))), new StreamResult(new FileOutputStream(new File(html.getAbsolutePath()))));
        System.setProperty(user_dir, currUserDir);
    }

    public void save(ILocation location) throws IOException {
        this.save(location, ROOT_TAG_NAME);
    }

    private class APICompatibilityEntry
    extends ComponentEntry {
        private int newAPICount = 0;
        private int removedAPICount = 0;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<api-compatibility ");
            sb.append(this.toAttribute("name", this.getCompName()));
            sb.append(this.toAttribute("new-api-count", String.valueOf(this.newAPICount)));
            sb.append(this.toAttribute("removed-api-count", String.valueOf(this.removedAPICount)));
            sb.append(this.toAttribute("ref", this.getRef()));
            sb.append("/>");
            return sb.toString();
        }

        public int getNewAPICount() {
            return this.newAPICount;
        }

        public void setNewAPICount(int newAPICount) {
            this.newAPICount = newAPICount;
        }

        public int getRemovedAPICount() {
            return this.removedAPICount;
        }

        public void setRemovedAPICount(int removedAPICount) {
            this.removedAPICount = removedAPICount;
        }
    }
}

