/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IJavaVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.adopters.Java2APIVisitor;
import org.eclipse.wtp.releng.tools.component.adopters.PDESourceVisitor;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;

public class Java2API
implements IJavaVisitor,
IPlatformRunnable {
    private String src;
    private String outputDir;
    private Collection includes;
    private Collection excludes;
    private Collection excludePlugins;
    private boolean defaultExclusive;
    private List visitedPlugins = new ArrayList();
    private ASTParser astParser;
    private ComponentXML cachedCompXML;

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public Collection getExcludePlugins() {
        return this.excludePlugins;
    }

    public void setExcludePlugins(Collection excludePlugins) {
        this.excludePlugins = excludePlugins;
    }

    public boolean isDefaultExclusive() {
        return this.defaultExclusive;
    }

    public void setDefaultExclusive(boolean defaultExclusive) {
        this.defaultExclusive = defaultExclusive;
    }

    public List getVisitedPlugins() {
        return new ArrayList(this.visitedPlugins);
    }

    public void execute() {
        ILocation srcLocation = Location.createLocation(new File(this.src));
        PDESourceVisitor pdeSrcVisitor = new PDESourceVisitor();
        pdeSrcVisitor.setExcludes(this.excludePlugins);
        srcLocation.accept(pdeSrcVisitor);
        pdeSrcVisitor.setJavaVisitor(this);
        srcLocation.accept(pdeSrcVisitor);
        try {
            if (this.cachedCompXML != null) {
                this.cachedCompXML.save();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(String pluginId, ILocation java) {
        CharArrayWriter caw;
        block13: {
            if (!this.visitedPlugins.contains(pluginId)) {
                this.visitedPlugins.add(pluginId);
            }
            if (!this.include(java.getName())) return true;
            InputStreamReader isr = null;
            caw = null;
            try {
                try {
                    ComponentXML compXML = this.getComponentXML(pluginId);
                    isr = new InputStreamReader(java.getInputStream());
                    caw = new CharArrayWriter();
                    char[] c = new char[2048];
                    int read = isr.read(c);
                    while (true) {
                        block14: {
                            if (read != -1) break block14;
                            isr.close();
                            caw.close();
                            if (this.astParser == null) {
                                this.astParser = ASTParser.newParser((int)3);
                            }
                            this.astParser.setSource(caw.toCharArray());
                            ASTNode node = this.astParser.createAST(null);
                            node.accept((ASTVisitor)new Java2APIVisitor(compXML, this.defaultExclusive));
                            break;
                        }
                        caw.write(c, 0, read);
                        read = isr.read(c);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (caw == null) throw throwable;
                caw.close();
                throw throwable;
            }
            {
                Object var8_12 = null;
                if (isr == null) break block13;
            }
            try {}
            catch (IOException iOException) {}
            isr.close();
        }
        if (caw == null) return true;
        caw.close();
        return true;
    }

    private boolean include(String name) {
        Iterator it;
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        if (this.excludes != null && !this.excludes.isEmpty()) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ComponentXML getComponentXML(String id) throws IOException {
        if (this.cachedCompXML != null) {
            if (this.cachedCompXML.getName().equals(id)) {
                return this.cachedCompXML;
            }
            this.cachedCompXML.save();
        }
        StringBuffer sb = new StringBuffer(this.outputDir);
        sb.append(id);
        sb.append("/component.xml");
        File file = new File(sb.toString());
        this.cachedCompXML = new ComponentXML();
        this.cachedCompXML.setName(id);
        this.cachedCompXML.setLocation(new FileLocation(file));
        Plugin plugin = new Plugin();
        plugin.setId(id);
        this.cachedCompXML.addPlugin(plugin);
        ComponentDepends compDepends = new ComponentDepends();
        compDepends.setUnrestricted(Boolean.TRUE);
        this.cachedCompXML.setComponentDepends(compDepends);
        if (file.exists()) {
            this.cachedCompXML.load();
        }
        return this.cachedCompXML;
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public Object run(Object arguments) {
        String src = System.getProperty("src");
        String outputDir = System.getProperty("outputDir");
        String includes = System.getProperty("includes");
        String excludes = System.getProperty("excludes");
        try {
            Java2API.main(new String[]{"-src", src, "-outputDir", outputDir, "-includes", includes, "-excludes", excludes});
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return IPlatformRunnable.EXIT_OK;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get("src");
        Collection outputDir = (Collection)options.get("outputDir");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        Collection excludePlugins = (Collection)options.get("excludePlugins");
        Collection defaultExclusive = (Collection)options.get("defaultExclusive");
        if (src == null || outputDir == null || src.isEmpty() || outputDir.isEmpty()) {
            Java2API.printUsage();
            System.exit(-1);
        }
        Java2API java2API = new Java2API();
        java2API.setSrc((String)src.iterator().next());
        java2API.setOutputDir((String)outputDir.iterator().next());
        java2API.setIncludes(includes);
        java2API.setExcludes(excludes);
        java2API.setExcludePlugins(excludePlugins);
        java2API.setDefaultExclusive(defaultExclusive != null);
        java2API.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.java.Java2API -src <src> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of a Eclipse-based product (requires SDK build)");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated packages to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated packages to exclude");
        System.out.println("\t-excludePlugins\t<excludePlugins>\tspace seperated plugins to exclude");
    }
}

