/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.wtp.releng.tools.component.adopters.IComponentConstants;

public abstract class ComponentTeamScanner
implements IComponentConstants {
    private HashMap plugin2compTeam;
    private List componentTeams;

    private HashMap getPluginComponentMap() {
        if (this.plugin2compTeam == null) {
            this.plugin2compTeam = new HashMap();
            this.initializeComponentTeams();
        }
        return this.plugin2compTeam;
    }

    private void initializeComponentTeams() {
        this.componentTeams = new ArrayList();
        ComponentTeam javaEE = new ComponentTeam("Java EE");
        this.getPluginComponentMap().put("org.eclipse..st.j2ee.*", javaEE);
        this.getPluginComponentMap().put("org.eclipse..st.ejb.*", javaEE);
        this.getPluginComponentMap().put("org.eclipse..st.servlet.*", javaEE);
        this.getPluginComponentMap().put("org.eclipse..st.web.*", javaEE);
        this.componentTeams.add(javaEE);
        ComponentTeam common = new ComponentTeam("Common");
        this.getPluginComponentMap().put("org.eclipse..st.command.*", common);
        this.getPluginComponentMap().put("org.eclipse..st.common.*", common);
        this.getPluginComponentMap().put("org.eclipse..st.validation.*", common);
        this.componentTeams.add(common);
        ComponentTeam editors = new ComponentTeam("XML/JSP");
        this.getPluginComponentMap().put("org.eclipse..st.jsp.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.css.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.dtd.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.html.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.javascript.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.sse.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.xml.*", editors);
        this.getPluginComponentMap().put("org.eclipse..st.xsd.*", editors);
        this.componentTeams.add(editors);
        ComponentTeam rdb = new ComponentTeam("RDB");
        this.getPluginComponentMap().put("org.eclipse..st.rdb.*", rdb);
        this.componentTeams.add(rdb);
        ComponentTeam webServices = new ComponentTeam("Web Services");
        this.getPluginComponentMap().put("org.eclipse..st.ws.*", webServices);
        this.getPluginComponentMap().put("org.eclipse..st.wsdl.*", webServices);
        this.componentTeams.add(webServices);
        ComponentTeam server = new ComponentTeam("Server");
        this.getPluginComponentMap().put("org.eclipse..st.server.*", server);
        this.getPluginComponentMap().put("org.eclipse..st.internet.*", server);
        this.componentTeams.add(server);
        ComponentTeam jem = new ComponentTeam("Jem");
        this.getPluginComponentMap().put("org.eclipse.jem.*", jem);
        this.componentTeams.add(jem);
        ComponentTeam jsf = new ComponentTeam("JSF");
        this.getPluginComponentMap().put("org.eclipse.jst.jsf.*", jsf);
        this.componentTeams.add(jsf);
        ComponentTeam jpt = new ComponentTeam("JPT");
        this.getPluginComponentMap().put("org.eclipse.jpt.*", jpt);
        this.componentTeams.add(jpt);
        ComponentTeam unknown = new ComponentTeam("Unknown");
        this.componentTeams.add(unknown);
    }

    protected ComponentTeam getComponentTeam(String pluginId) {
        Iterator it3 = this.getPluginComponentMap().keySet().iterator();
        while (it3.hasNext()) {
            String regex = (String)it3.next();
            if (!pluginId.matches(regex)) continue;
            return (ComponentTeam)this.getPluginComponentMap().get(regex);
        }
        return this.getUnknownComponent();
    }

    private ComponentTeam getUnknownComponent() {
        int i = 0;
        while (i < this.getComponentTeams().size()) {
            ComponentTeam compTeam = (ComponentTeam)this.getComponentTeams().get(i);
            if (compTeam.getTeamName().equals("Unknown")) {
                return compTeam;
            }
            ++i;
        }
        return null;
    }

    protected List getComponentTeams() {
        if (this.componentTeams == null) {
            this.initializeComponentTeams();
        }
        return this.componentTeams;
    }

    public class ComponentTeam {
        private String teamName;
        private TreeMap extpt2RefCounts;
        private TreeMap class2refCounts;
        private TreeMap pkg2refCounts;
        private TreeMap plugin2refCounts;

        public ComponentTeam(String teamName) {
            this.teamName = teamName;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public TreeMap getExtensionPointReferenceCounts() {
            if (this.extpt2RefCounts == null) {
                this.extpt2RefCounts = new TreeMap();
            }
            return this.extpt2RefCounts;
        }

        public TreeMap getClassReferenceCounts() {
            if (this.class2refCounts == null) {
                this.class2refCounts = new TreeMap();
            }
            return this.class2refCounts;
        }

        public TreeMap getPackageReferenceCounts() {
            if (this.pkg2refCounts == null) {
                this.pkg2refCounts = new TreeMap();
            }
            return this.pkg2refCounts;
        }

        public TreeMap getPluginReferenceCounts() {
            if (this.plugin2refCounts == null) {
                this.plugin2refCounts = new TreeMap();
            }
            return this.plugin2refCounts;
        }
    }
}

