/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.ui.internal.BundleClazz;
import org.osgi.framework.Bundle;

public class BundleLibrary
implements ILibrary {
    private Bundle bundle;
    private ManifestElement manifestElement;
    private Map types;

    public BundleLibrary(Bundle bundle, ManifestElement manifestElement) {
        this.bundle = bundle;
        this.manifestElement = manifestElement;
    }

    public Map getTypes() {
        if (this.types == null) {
            this.types = new HashMap(1);
            URL libURL = Platform.find((Bundle)this.bundle, (IPath)new Path(this.manifestElement.getValue()));
            if (libURL != null) {
                try {
                    JarInputStream jis = new JarInputStream(libURL.openStream());
                    ZipEntry entry = jis.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory() && entry.getName().endsWith("class")) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] b = new byte[2048];
                            int read = jis.read(b);
                            while (read != -1) {
                                baos.write(b, 0, read);
                                read = jis.read(b);
                            }
                            BundleClazz clazz = new BundleClazz(baos.toByteArray());
                            this.types.put(clazz.getName(), clazz);
                            clazz.resetClazz();
                        }
                        entry = jis.getNextEntry();
                    }
                    jis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.types;
    }

    public void resetTypes() {
        this.types = null;
    }

    public void accept(IClazzVisitor visitor) {
        Iterator it = this.getTypes().values().iterator();
        while (it.hasNext()) {
            IClazz clazz = (IClazz)it.next();
            visitor.visit(clazz);
            clazz.resetClazz();
        }
    }
}

