/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.job;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.FieldUse;
import org.eclipse.wtp.releng.tools.component.api.MethodUse;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;

public abstract class AbstractModifyMarkersJob
extends Job {
    public AbstractModifyMarkersJob(String name) {
        super(name);
    }

    public void createClassViolationMarker(IResource javaSource, ClassUse classUse) throws CoreException {
        String className = classUse.getName();
        ComponentManager manager = ComponentManager.getManager();
        if (classUse.getReference() != null && classUse.isReference()) {
            int methodRefCount = classUse.sizeMethodUses();
            int fieldRefCount = classUse.sizeFieldUses();
            if (methodRefCount > 0 || fieldRefCount > 0) {
                Iterator it;
                if (methodRefCount > 0) {
                    Collection methodUses = classUse.getMethodUses();
                    it = methodUses.iterator();
                    while (it.hasNext()) {
                        this.createMethodViolationMarker(javaSource, classUse, (MethodUse)it.next());
                    }
                }
                if (fieldRefCount > 0) {
                    Collection fieldUses = classUse.getFieldUses();
                    it = fieldUses.iterator();
                    while (it.hasNext()) {
                        this.createFieldViolationMarker(javaSource, classUse, (FieldUse)it.next());
                    }
                }
            } else {
                this.createMarker(javaSource, manager.getMessage("VIOLATION_CLASS_REF", new String[]{className}), -1);
            }
        }
        if (classUse.getSubclass() != null && classUse.isSubclass()) {
            this.createMarker(javaSource, manager.getMessage("VIOLATION_CLASS_SUBCLASS", new String[]{className}), -1);
        }
        if (classUse.getImplement() != null && classUse.isImplement()) {
            this.createMarker(javaSource, manager.getMessage("VIOLATION_CLASS_IMPLEMENT", new String[]{className}), -1);
        }
        if (classUse.getInstantiate() != null && classUse.isInstantiate()) {
            if (classUse.sizeLines() > 0) {
                this.createMarker(javaSource, manager.getMessage("VIOLATION_CLASS_INSTANTIATE", new String[]{className}), classUse.getLines());
            } else {
                this.createMarker(javaSource, manager.getMessage("VIOLATION_CLASS_INSTANTIATE", new String[]{className}), -1);
            }
        }
    }

    private void createMethodViolationMarker(IResource javaSource, ClassUse classUse, MethodUse methodUse) throws CoreException {
        String className = classUse.getName();
        String methodName = methodUse.getName();
        ComponentManager manager = ComponentManager.getManager();
        if (methodUse.sizeLines() > 0) {
            this.createMarker(javaSource, manager.getMessage("VIOLATION_METHOD_REF", new String[]{methodName, className}), methodUse.getLines());
        } else {
            this.createMarker(javaSource, manager.getMessage("VIOLATION_METHOD_REF", new String[]{methodName, className}), -1);
        }
    }

    private void createFieldViolationMarker(IResource javaSource, ClassUse classUse, FieldUse fieldUse) throws CoreException {
        String className = classUse.getName();
        String fieldName = fieldUse.getName();
        ComponentManager manager = ComponentManager.getManager();
        if (fieldUse.sizeLines() > 0) {
            this.createMarker(javaSource, manager.getMessage("VIOLATION_FIELD_REF", new String[]{fieldName, className}), fieldUse.getLines());
        } else {
            this.createMarker(javaSource, manager.getMessage("VIOLATION_FIELD_REF", new String[]{fieldName, className}), -1);
        }
    }

    private void createMarker(IResource resource, String message, Collection lines) throws CoreException {
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            try {
                this.createMarker(resource, message, Integer.parseInt((String)it.next()));
            }
            catch (NumberFormatException numberFormatException) {
                this.createMarker(resource, message, -1);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createMarker(IResource resource, String message, int line) throws CoreException {
        IJobManager jobManager = Platform.getJobManager();
        try {
            jobManager.beginRule((ISchedulingRule)resource, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            jobManager.endRule((ISchedulingRule)resource);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        jobManager.endRule((ISchedulingRule)resource);
        {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("marker-comp-vio", true);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)message);
            if (line == -1) return;
            marker.setAttribute("lineNumber", line);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteViolationMarksers(IResource res) throws CoreException {
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        int i = 0;
        while (i < markers.length) {
            if (markers[i].getAttribute("marker-comp-vio") != null) {
                Object var5_5;
                IJobManager jobManager = Platform.getJobManager();
                try {
                    jobManager.beginRule((ISchedulingRule)res, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    jobManager.endRule((ISchedulingRule)res);
                    throw throwable;
                }
                {
                    var5_5 = null;
                }
                jobManager.endRule((ISchedulingRule)res);
                {
                    markers[i].delete();
                }
            }
            ++i;
        }
        return;
    }
}

