/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder.perf;

import org.eclipse.wtp.releng.wtpbuilder.AbstractBuilder;
import org.eclipse.wtp.releng.wtpbuilder.Build;
import org.eclipse.wtp.releng.wtpbuilder.CommandOptionParser;
import org.eclipse.wtp.releng.wtpbuilder.Main;

public class PerfBuilder
extends AbstractBuilder {
    private static final String PERF_COMPLETED_BUILDS_FILE = "perf_completed_builds.properties";
    private static final String USAGE = "Usage: java org.eclipse.wtp.releng.wtpbuilder.perf.PerfBuilder -baseos <baseos> -basews <basews> -basearch <basearch> -build.home <buildHome>";
    private static final String BUILD_SCRIPT = "/releng.wtpbuilder/distribution/wtp.perf/build.xml";

    public PerfBuilder(String completedBuildsFile) {
        super(completedBuildsFile);
    }

    protected boolean acceptCommitterBuilds() {
        return false;
    }

    public boolean build(Build build) {
        System.setProperty("buildType", build.getType());
        System.setProperty("buildId", build.getId());
        System.setProperty("date", build.getDate());
        System.setProperty("time", build.getTime());
        System.setProperty("build.stream", build.getStream());
        System.setProperty("buildBranch", build.getStream());
        if (!build.isPublicBuild()) {
            System.setProperty("build.committers", Boolean.TRUE.toString());
        }
        String buildScript = System.getProperty("build.home") + BUILD_SCRIPT;
        Main.main(new String[]{"-f", buildScript});
        Main.main(new String[]{"-f", buildScript, "graph"});
        Main.main(new String[]{"-f", buildScript, "upload"});
        Main.main(new String[]{"-f", buildScript, "clean"});
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser parser = new CommandOptionParser(args);
        String baseos = parser.getOptionAsString("baseos");
        String basews = parser.getOptionAsString("basews");
        String basearch = parser.getOptionAsString("basearch");
        String login = parser.getOptionAsString("login");
        String minTS = parser.getOptionAsString("minTS");
        String buildHome = parser.getOptionAsString("build.home");
        if (baseos == null || basews == null || basearch == null || buildHome == null) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        PerfBuilder perfBuilder = new PerfBuilder(PERF_COMPLETED_BUILDS_FILE);
        perfBuilder.setBaseos(baseos);
        perfBuilder.setBasews(basews);
        perfBuilder.setBasearch(basearch);
        perfBuilder.setLogin(login);
        System.setProperty("build.home", buildHome);
        if (minTS != null) {
            perfBuilder.setMinTS(Long.parseLong(minTS));
        }
        perfBuilder.main();
    }
}

