/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.wizards.autobindings;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesSupportListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ICheckboxViewerWrapper;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.AutomaticDatabindingFirstPage;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.IAutomaticDatabindingProvider;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class AutomaticDatabindingSecondPage
extends WizardPage
implements ICompleteListener {
    private final AutomaticDatabindingFirstPage m_firstPage;
    private final IAutomaticDatabindingProvider m_databindingProvider;
    private final String m_initialBeanClassName;
    private ChooseClassAndPropertiesUiContentProvider m_chooseClassAndPropertiesProvider;
    private ToolItem m_propertiesFilterButton;

    public AutomaticDatabindingSecondPage(AutomaticDatabindingFirstPage firstPage, IAutomaticDatabindingProvider databindingProvider, String initialBeanClassName) {
        super("");
        this.m_firstPage = firstPage;
        this.m_databindingProvider = databindingProvider;
        this.m_initialBeanClassName = initialBeanClassName;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        int columns = 4;
        Composite pageComposite = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)pageComposite).columns(columns);
        this.setControl((Control)pageComposite);
        this.m_chooseClassAndPropertiesProvider = new ChooseClassAndPropertiesUiContentProvider(this.createConfiguration()){

            @Override
            protected void super_createContent(Composite parent, int columns) {
                super.super_createContent(parent, columns - 1);
                ToolBar toolBar = new ToolBar(parent, 0);
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton = new ToolItem(toolBar, 32);
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.setImage(Activator.getImage("filter_action.gif"));
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.setToolTipText(Messages.AutomaticDatabindingSecondPage_filterToolTip);
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.setSelection(AutomaticDatabindingSecondPage.this.m_databindingProvider.getPropertiesViewerFilterInitState());
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.setEnabled(false);
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AutomaticDatabindingSecondPage.this.handlePropertiesFilter((this).AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.getSelection());
                    }
                });
            }

            @Override
            protected List<PropertyAdapter> getProperties(Class<?> choosenClass) throws Exception {
                return AutomaticDatabindingSecondPage.this.m_databindingProvider.getProperties(choosenClass);
            }

            @Override
            public void updateFromObject() throws Exception {
                if (AutomaticDatabindingSecondPage.this.m_initialBeanClassName != null && AutomaticDatabindingSecondPage.this.m_firstPage.getJavaProject() != null) {
                    AutomaticDatabindingSecondPage.this.m_databindingProvider.setCurrentWizardData(AutomaticDatabindingSecondPage.this.m_firstPage, AutomaticDatabindingSecondPage.this);
                    this.setClassNameAndProperty(AutomaticDatabindingSecondPage.this.m_initialBeanClassName, null, true);
                }
            }

            @Override
            protected void saveToObject(Class<?> choosenClass, List<PropertyAdapter> choosenProperties) throws Exception {
            }

            @Override
            protected Class<?> loadClass(String className) throws ClassNotFoundException {
                return AutomaticDatabindingSecondPage.this.m_databindingProvider.loadClass(className);
            }

            @Override
            protected IJavaProject getJavaProject() {
                return AutomaticDatabindingSecondPage.this.m_firstPage.getJavaProject();
            }
        };
        this.m_chooseClassAndPropertiesProvider.createContent(pageComposite, columns);
        this.m_chooseClassAndPropertiesProvider.setCompleteListener(this);
        this.getPropertiesViewer().getCheckable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AutomaticDatabindingSecondPage.this.m_databindingProvider.handlePropertyChecked((PropertyAdapter)event.getElement(), event.getChecked());
                AutomaticDatabindingSecondPage.this.calculateFinish();
            }
        });
        this.m_chooseClassAndPropertiesProvider.setSupportListener(new ChooseClassAndPropertiesSupportListener(){

            @Override
            public void loadProperties(boolean successful) {
                AutomaticDatabindingSecondPage.this.m_propertiesFilterButton.setEnabled(successful);
                if (successful) {
                    Object[] objectArray = AutomaticDatabindingSecondPage.this.getPropertiesViewer().getCheckedElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        AutomaticDatabindingSecondPage.this.m_databindingProvider.handlePropertyChecked((PropertyAdapter)element, true);
                        ++n2;
                    }
                }
            }
        });
        this.m_databindingProvider.configurePropertiesViewer((CheckboxTableViewer)this.getPropertiesViewer().getViewer());
        Composite widgetComposite = new Composite(pageComposite, 0);
        GridDataFactory.create((Control)widgetComposite).fill().grab().spanH(columns);
        this.m_databindingProvider.fillWidgetComposite(widgetComposite);
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                AutomaticDatabindingSecondPage.this.m_chooseClassAndPropertiesProvider.updateFromObject();
            }
        });
        this.handlePropertiesFilter(this.m_databindingProvider.getPropertiesViewerFilterInitState());
    }

    private ChooseClassAndPropertiesConfiguration createConfiguration() {
        ChooseClassAndPropertiesConfiguration configuration = new ChooseClassAndPropertiesConfiguration();
        configuration.setDialogFieldLabel(Messages.AutomaticDatabindingSecondPage_beanClassLabel);
        configuration.setChooseInterfaces(true);
        configuration.setEmptyClassErrorMessage(Messages.AutomaticDatabindingSecondPage_beanClassMessage);
        configuration.setErrorMessagePrefix(Messages.AutomaticDatabindingSecondPage_beanClassErrorPrefix);
        configuration.setPropertiesLabel(Messages.AutomaticDatabindingSecondPage_propertiesLabel);
        configuration.setPropertiesMultiChecked(true);
        configuration.setReorderMode(true);
        configuration.setLoadedPropertiesCheckedStrategy(ChooseClassAndPropertiesConfiguration.LoadedPropertiesCheckedStrategy.All);
        configuration.setPropertiesErrorMessage(Messages.AutomaticDatabindingSecondPage_propertiesErrorMessage);
        this.m_databindingProvider.configure(configuration);
        return configuration;
    }

    private ICheckboxViewerWrapper getPropertiesViewer() {
        return this.m_chooseClassAndPropertiesProvider.getPropertiesViewer();
    }

    public final void setVisible(boolean visible) {
        if (visible) {
            this.m_databindingProvider.setCurrentWizardData(this.m_firstPage, this);
            this.calculateFinish();
        }
        super.setVisible(visible);
    }

    private void handlePropertiesFilter(boolean enabled) {
        if (enabled) {
            this.getPropertiesViewer().getViewer().addFilter(this.m_databindingProvider.getPropertiesViewerFilter());
        } else {
            this.getPropertiesViewer().getViewer().resetFilters();
        }
        this.calculateFinish();
    }

    @Override
    public void calculateFinish() {
        String errorMessage = this.m_chooseClassAndPropertiesProvider.getErrorMessage();
        if (errorMessage == null) {
            errorMessage = this.m_databindingProvider.calculateFinish();
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

