/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.ColumnsDialog;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.RowsDialog;

public final class DimensionsProperty
extends Property {
    private final boolean m_horizontal;

    public DimensionsProperty(FormLayoutInfo layout, boolean horizontal) {
        super((PropertyEditor)new Editor(layout, horizontal));
        this.m_horizontal = horizontal;
    }

    public String getTitle() {
        return this.m_horizontal ? "columnSpecs" : "rowSpecs";
    }

    public Object getValue() throws Exception {
        return UNKNOWN_VALUE;
    }

    public boolean isModified() throws Exception {
        return true;
    }

    public void setValue(Object value) throws Exception {
    }

    private static class Editor
    extends TextDialogPropertyEditor {
        private final FormLayoutInfo m_layout;
        private final boolean m_horizontal;

        public Editor(FormLayoutInfo layout, boolean horizontal) {
            this.m_layout = layout;
            this.m_horizontal = horizontal;
        }

        protected String getText(Property property) throws Exception {
            ArrayList titles = Lists.newArrayList();
            List<FormDimensionInfo> dimensions = this.m_horizontal ? this.m_layout.getColumns() : this.m_layout.getRows();
            for (FormDimensionInfo dimension : dimensions) {
                titles.add(dimension.getToolTip());
            }
            return StringUtils.join(titles.iterator(), (String)", ");
        }

        protected void openDialog(Property property) throws Exception {
            if (this.m_horizontal) {
                new ColumnsDialog(DesignerPlugin.getShell(), this.m_layout).open();
            } else {
                new RowsDialog(DesignerPlugin.getShell(), this.m_layout).open();
            }
        }
    }
}

