/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.property;

import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.ui.BindDialog;
import org.eclipse.wb.internal.core.databinding.ui.BindingElementsComposite;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.BindingPropertyEditor;
import org.eclipse.wb.internal.core.databinding.ui.property.Context;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class AbstractBindingProperty
extends AbstractProperty {
    protected IBindingInfo m_binding;
    protected boolean m_isTarget;

    public AbstractBindingProperty(Context context) {
        super((PropertyEditor)BindingPropertyEditor.EDITOR, context);
    }

    public final IBindingInfo getBinding() {
        return this.m_binding;
    }

    public final void setBinding(IBindingInfo binding, boolean isTarget) {
        this.m_binding = binding;
        this.m_isTarget = isTarget;
    }

    public abstract String getText() throws Exception;

    public final void editBinding() throws Exception {
        AbstractBindingProperty.editBinding(this.m_context, this.m_binding);
    }

    public static void editBinding(Context context, IBindingInfo binding) throws Exception {
        BindDialog dialog = new BindDialog(DesignerPlugin.getShell(), context.plugin, context.provider, binding, false, false);
        if (dialog.open() == 0) {
            context.provider.editBinding(binding);
        }
    }

    @Override
    public final void setValue(Object value) throws Exception {
        Assert.isTrue((value == UNKNOWN_VALUE ? 1 : 0) != 0);
        AbstractBindingProperty.deleteBinding(this.m_context, this.m_binding);
    }

    public static void deleteBinding(Context context, IBindingInfo binding) throws Exception {
        if (BindingElementsComposite.canDeleteBinding(context.provider, binding, DesignerPlugin.getShell())) {
            context.provider.deleteBinding(binding);
        }
    }

    public final String getTitle() {
        return "";
    }

    public final boolean isModified() throws Exception {
        return true;
    }
}

