/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.FigureVisitor;

public class TargetFigureFindVisitor
extends FigureVisitor {
    private final Point m_location;
    private Figure m_result;

    public TargetFigureFindVisitor(FigureCanvas canvas, int x, int y) {
        this.m_location = new Point(x, y);
        this.m_location.x += canvas.getViewport().getHorizontalRangeModel().getValue();
        this.m_location.y += canvas.getViewport().getVerticalRangeModel().getValue();
    }

    @Override
    public boolean visit(Figure figure) {
        boolean canAccept;
        boolean bl = canAccept = this.m_result == null && figure.isVisible() && figure.containsPoint(this.m_location) && this.acceptVisit(figure);
        if (canAccept) {
            this.m_location.performTranslate(figure.getLocation().getNegated());
            this.m_location.performTranslate(figure.getInsets().getNegated());
            return true;
        }
        return false;
    }

    @Override
    public void endVisit(Figure figure) {
        if (this.m_result == null) {
            if (this.acceptResult(figure)) {
                this.m_result = figure;
            } else {
                this.m_location.performTranslate(figure.getLocation());
                this.m_location.performTranslate(figure.getInsets());
            }
        }
    }

    protected boolean acceptVisit(Figure figure) {
        return true;
    }

    protected boolean acceptResult(Figure figure) {
        return true;
    }

    public Figure getTargetFigure() {
        return this.m_result;
    }
}

