/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.AbstractHeaderLayoutEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.gef.GefMessages;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderSelectionEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutPreferences;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

final class FormHeaderLayoutEditPolicy<C extends IControlInfo>
extends AbstractHeaderLayoutEditPolicy {
    private final boolean isHorizontal;
    private final IFormLayoutInfo<C> layout;
    private final LayoutEditPolicy mainPolicy;
    private final Transposer t;
    private TextFeedback hintFeedback;
    private Figure feedback;

    FormHeaderLayoutEditPolicy(IFormLayoutInfo<C> layout, LayoutEditPolicy mainPolicy, boolean isHorizontal) {
        super(mainPolicy);
        this.layout = layout;
        this.mainPolicy = mainPolicy;
        this.isHorizontal = isHorizontal;
        this.t = new Transposer(!isHorizontal);
    }

    protected void decorateChild(org.eclipse.wb.gef.core.EditPart child) {
        child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new FormHeaderSelectionEditPolicy(this.mainPolicy));
    }

    private void handleDoubleClick(SelectionRequest request) {
        Point location = request.getLocation().getCopy();
        int percent = this.calcPercent(location);
        if (percent > 0) {
            this.layout.getPreferences().addPercent(percent, this.isHorizontal);
            this.getHost().refresh();
        }
    }

    public void performRequest(Request request) {
        if ("open".equals(request.getType())) {
            this.handleDoubleClick((SelectionRequest)request);
            return;
        }
        super.performRequest(request);
    }

    protected void showLayoutTargetFeedback(Request request) {
        super.showLayoutTargetFeedback(request);
        int percent = this.calcPercent((ChangeBoundsRequest)request);
        if (percent > 0 && percent < 100) {
            Layer layer;
            if (this.hintFeedback == null) {
                layer = this.mainPolicy.getHost().getViewer().getLayer("Feedback Layer Abv 1");
                this.hintFeedback = new TextFeedback(layer, true);
                this.hintFeedback.add();
            }
            this.hintFeedback.setText(percent + "%");
            this.hintFeedback.setLocation(new Point(0, 0));
            if (this.feedback == null) {
                layer = this.getHost().getViewer().getLayer("Feedback Layer Abv 1");
                this.feedback = new FormHeaderEditPart.PercentFigure(this.isHorizontal);
                layer.add((IFigure)this.feedback);
            }
            int figureSize = this.t.t((Dimension)this.getHostFigure().getSize()).height;
            Point location = this.t.t(((ChangeBoundsRequest)request).getLocation().getCopy());
            Point position = this.t.t(new Point(location.x - figureSize / 2, 0));
            this.feedback.setLocation(position);
            this.feedback.setSize(figureSize, figureSize);
        } else {
            this.removeFeedbacks();
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.removeFeedbacks();
        super.eraseLayoutTargetFeedback(request);
    }

    private void removeFeedbacks() {
        if (this.hintFeedback != null) {
            this.hintFeedback.remove();
            this.hintFeedback = null;
            FigureUtils.removeFigure((Figure)this.feedback);
            this.feedback = null;
        }
    }

    public boolean understandsRequest(Request request) {
        return "move".equals(request.getType());
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        final int percent = this.calcPercent(request);
        if (percent > 0 && percent < 100) {
            EditPart editPart = (EditPart)request.getEditParts().get(0);
            final int oldPercent = ((FormLayoutPreferences.PercentsInfo)editPart.getModel()).value;
            return new Command(){

                public void execute() {
                    FormHeaderLayoutEditPolicy.this.layout.getPreferences().removePercent(oldPercent, FormHeaderLayoutEditPolicy.this.isHorizontal);
                    FormHeaderLayoutEditPolicy.this.layout.getPreferences().addPercent(percent, FormHeaderLayoutEditPolicy.this.isHorizontal);
                    FormHeaderLayoutEditPolicy.this.getHost().refresh();
                }
            };
        }
        return null;
    }

    private int calcPercent(ChangeBoundsRequest request) {
        Point location = request.getLocation().getCopy();
        return this.calcPercent(location);
    }

    private int calcPercent(Point location) {
        this.translateToModel((Translatable)location);
        int marginOffset = this.isHorizontal ? FormUtils.getLayoutMarginLeft(this.layout) : FormUtils.getLayoutMarginTop(this.layout);
        int place = this.t.t((Point)location).x - marginOffset;
        int size = this.t.t((Dimension)this.layout.getContainerSize()).width;
        return place * 100 / size;
    }

    private void translateToModel(Translatable t) {
        t.performTranslate(FormHeaderLayoutEditPolicy.getOffset(this.mainPolicy.getHost().getFigure(), this.layout.getComposite()).getNegated());
    }

    public static Point getOffset(Figure containerFigure, ICompositeInfo composite) {
        Point offset = new Point(0, 0);
        FigureUtils.translateFigureToAbsolute2((IFigure)containerFigure, (Translatable)offset);
        offset.performTranslate(composite.getClientAreaInsets());
        return offset;
    }

    public void buildContextMenu(IMenuManager manager) {
        IEditPartViewer viewer = this.getHost().getViewer();
        Tool tool = viewer.getEditDomain().getActiveTool();
        Point location = tool.getLocation().getCopy();
        final int percent = this.calcPercent(location);
        if (percent > 0) {
            Action action = new Action(MessageFormat.format(GefMessages.FormHeaderLayoutEditPolicy_addSnapPoint, percent)){

                public void run() {
                    FormHeaderLayoutEditPolicy.this.layout.getPreferences().addPercent(percent, FormHeaderLayoutEditPolicy.this.isHorizontal);
                    FormHeaderLayoutEditPolicy.this.getHost().refresh();
                }
            };
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
        }
        List<Integer> percents = this.isHorizontal ? this.layout.getPreferences().getHorizontalPercents() : this.layout.getPreferences().getVerticalPercents();
        for (final Integer integer : percents) {
            Action action = new Action(MessageFormat.format(GefMessages.FormHeaderLayoutEditPolicy_removePercent, integer)){

                public void run() {
                    FormHeaderLayoutEditPolicy.this.layout.getPreferences().removePercent(integer, FormHeaderLayoutEditPolicy.this.isHorizontal);
                    FormHeaderLayoutEditPolicy.this.getHost().refresh();
                }
            };
            manager.add((IAction)action);
        }
        manager.add((IContributionItem)new Separator());
        Action action = new Action(GefMessages.FormHeaderLayoutEditPolicy_restoreDefaults){

            public void run() {
                FormHeaderLayoutEditPolicy.this.layout.getPreferences().defaultPercents(FormHeaderLayoutEditPolicy.this.isHorizontal);
                FormHeaderLayoutEditPolicy.this.getHost().refresh();
            }
        };
        manager.add((IAction)action);
        action = new Action(GefMessages.FormHeaderLayoutEditPolicy_useAsDefaults){

            public void run() {
                if (MessageDialog.openQuestion((Shell)DesignerPlugin.getShell(), (String)GefMessages.FormHeaderLayoutEditPolicy_confirmDefaultsTitle, (String)GefMessages.FormHeaderLayoutEditPolicy_confirmDefaultsMessage)) {
                    FormHeaderLayoutEditPolicy.this.layout.getPreferences().setAsDefaultPercents(FormHeaderLayoutEditPolicy.this.isHorizontal);
                }
            }
        };
        manager.add((IAction)action);
        action = new Action(GefMessages.FormHeaderLayoutEditPolicy_configureDefaults){

            public void run() {
                ToolkitDescription toolkit = GlobalState.getToolkit();
                String id = toolkit.getId() + ".preferences.layout.FormLayoutPreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)DesignerPlugin.getShell(), (String)id, (String[])ArrayUtils.EMPTY_STRING_ARRAY, null).open();
                FormHeaderLayoutEditPolicy.this.getHost().refresh();
            }
        };
        manager.add((IAction)action);
    }
}

