/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;

public abstract class AbstractEngineTest
extends AbstractJavaTest {
    protected final Object evaluateSingleMethod(TypeDeclaration typeDeclaration, String methodSignature) throws Exception {
        return this.evaluateSingleMethod(typeDeclaration, methodSignature, methodSignature);
    }

    protected final Object evaluateSingleMethod(TypeDeclaration typeDeclaration, String entryMethodSignature, String returnMethodSignature) throws Exception {
        MethodDeclaration entryMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)entryMethodSignature);
        MethodDeclaration returnMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)returnMethodSignature);
        List statements = DomGenerics.statements((Block)returnMethod.getBody());
        ReturnStatement returnStatement = (ReturnStatement)statements.get(statements.size() - 1);
        Expression expressionToEvaluate = returnStatement.getExpression();
        return this.evaluateExpression(entryMethod, expressionToEvaluate);
    }

    protected final Object evaluateExpression(MethodDeclaration entryPoint, final Expression expressionToEvaluate) throws Exception {
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)this.m_lastEditor.getModelUnit().getJavaProject());
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        final boolean[] expressionEvaluated = new boolean[1];
        EvaluationContext context = new EvaluationContext((ClassLoader)projectClassLoader, flowDescription){

            public void evaluationSuccessful(Expression expression, Object value) throws Exception {
                if (expression == expressionToEvaluate) {
                    expressionEvaluated[0] = true;
                }
            }
        };
        Object evaluationResult = AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)expressionToEvaluate);
        AbstractEngineTest.assertTrue((String)MessageFormat.format("Expression ''{0}'' was not notified in evaluationSuccessful()", expressionToEvaluate), (boolean)expressionEvaluated[0]);
        return evaluationResult;
    }

    protected final TypeDeclaration createResourceType(String name) throws Exception {
        return this.createResourceType(name, "Test.java");
    }

    protected final TypeDeclaration createResourceType(String resourceName, String unitName) throws Exception {
        String path = "core/eval/" + resourceName + ".java";
        String code = AbstractEngineTest.readResourceFileContent(path);
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", unitName, code);
        AbstractEngineTest.assertEquals((long)1L, (long)compilationUnit.types().size());
        return (TypeDeclaration)compilationUnit.types().get(0);
    }

    protected final Object evaluateExpression(String expression, String returnType) throws Exception {
        return this.evaluateExpression(expression, returnType, false);
    }

    protected final Object evaluateExpression(String expression, String returnType, boolean waitBuild) throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AbstractEngineTest.getSource("// filler filler filler", "package test;", "class Test {", "  " + returnType + " foo() {", "      return " + expression + ";", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        if (waitBuild) {
            AbstractEngineTest.waitForAutoBuild();
        }
        return this.evaluateSingleMethod(typeDeclaration, "foo()");
    }
}

