/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.association.ConstructorChildAssociation;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class ConstructorChildAssociationTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    MyPanel myPanel = new MyPanel(button, true);", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        ConstructorChildAssociation association = (ConstructorChildAssociation)button.getAssociation();
        ConstructorChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        ConstructorChildAssociationTest.assertEquals((Object)"new MyPanel(button, true)", (Object)association.getSource());
        ConstructorChildAssociationTest.assertEquals((Object)"new MyPanel(button, true)", (Object)this.m_lastEditor.getSource((ASTNode)association.getCreation()));
        ConstructorChildAssociationTest.assertEquals((Object)"MyPanel myPanel = new MyPanel(button, true);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        Property constructorProperty = myPanel.getPropertyByTitle("Constructor");
        GenericProperty valueProperty = (GenericProperty)ConstructorChildAssociationTest.getPropertyByTitle(ConstructorChildAssociationTest.getSubProperties(constructorProperty), "value");
        List<ExpressionAccessor> accessors = ConstructorChildAssociationTest.getGenericPropertyAccessors(valueProperty);
        ConstructorChildAssociationTest.assertEquals((long)1L, (long)accessors.size());
        ConstructorChildAssociationTest.assertInstanceOf(ConstructorAccessor.class, (Object)accessors.get(0));
        ConstructorChildAssociationTest.assertSame((Object)Boolean.TRUE, (Object)valueProperty.getValue());
        valueProperty.setValue((Object)Boolean.FALSE);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    MyPanel myPanel = new MyPanel(button, false);", "    add(myPanel);", "  }", "}");
    }

    @Test
    public void test_delete() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    MyPanel myPanel = new MyPanel(button, true);", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        ConstructorChildAssociationTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel(true);", "    add(myPanel);", "  }", "}");
        Property constructorProperty = myPanel.getPropertyByTitle("Constructor");
        GenericProperty valueProperty = (GenericProperty)ConstructorChildAssociationTest.getPropertyByTitle(ConstructorChildAssociationTest.getSubProperties(constructorProperty), "value");
        List<ExpressionAccessor> accessors = ConstructorChildAssociationTest.getGenericPropertyAccessors(valueProperty);
        ConstructorChildAssociationTest.assertEquals((long)1L, (long)accessors.size());
        ConstructorChildAssociationTest.assertInstanceOf(ConstructorAccessor.class, (Object)accessors.get(0));
        ConstructorChildAssociationTest.assertSame((Object)Boolean.TRUE, (Object)valueProperty.getValue());
        valueProperty.setValue((Object)Boolean.FALSE);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel(false);", "    add(myPanel);", "  }", "}");
    }

    @Test
    public void test_delete_noDelete() throws Exception {
        ConstructorChildAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(Component component, boolean value) {", "  }", "}"));
        ConstructorChildAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ConstructorChildAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Component' child='true'/>", "      <parameter type='boolean'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorChildAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    MyPanel myPanel = new MyPanel(button, true);", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        ConstructorChildAssociationTest.assertFalse((boolean)button.getAssociation().canDelete());
        ConstructorChildAssociationTest.assertFalse((boolean)button.canDelete());
        ConstructorChildAssociationTest.assertTrue((boolean)myPanel.canDelete());
        myPanel.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Ignore
    @Test
    public void test_delete_noDelete_withGenerics() throws Exception {
        ConstructorChildAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel<T extends Component> extends JPanel {", "  public MyPanel(T component, boolean value) {", "  }", "}"));
        ConstructorChildAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ConstructorChildAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Component' child='true'/>", "      <parameter type='boolean'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorChildAssociationTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    MyPanel myPanel = new MyPanel(button, true);", "    add(myPanel);", "  }", "}");
        this.refresh();
        ContainerInfo myPanel = (ContainerInfo)ConstructorChildAssociationTest.getJavaInfoByName("myPanel");
        ComponentInfo button = (ComponentInfo)ConstructorChildAssociationTest.getJavaInfoByName("button");
        ConstructorChildAssociationTest.assertFalse((boolean)button.getAssociation().canDelete());
        ConstructorChildAssociationTest.assertFalse((boolean)button.canDelete());
        ConstructorChildAssociationTest.assertTrue((boolean)myPanel.canDelete());
        myPanel.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    private void configureProject() throws Exception {
        ConstructorChildAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(boolean value) {", "  }", "  public MyPanel(Component component, boolean value) {", "  }", "}"));
        ConstructorChildAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ConstructorChildAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='boolean'/>", "    </constructor>", "    <constructor>", "      <parameter type='java.awt.Component' child='true'/>", "      <parameter type='boolean'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorChildAssociationTest.waitForAutoBuild();
    }
}

