/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import java.beans.PropertyEditorManager;
import java.util.Map;
import javax.swing.UIManager;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.reflect.CompositeClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class EditorStateTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getEditor() throws Exception {
        this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  public Test() {", "  }", "}");
        EditorStateTest.assertSame((Object)this.m_lastEditor, (Object)this.m_lastState.getEditor());
    }

    @Test
    public void test_isDisposed() throws Exception {
        this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  public Test() {", "  }", "}");
        EditorState editorState = this.m_lastState;
        EditorStateTest.assertFalse((boolean)editorState.isDisposed());
        this.disposeLastModel();
        EditorStateTest.assertTrue((boolean)editorState.isDisposed());
    }

    @Test
    public void test_clearRegisteredEditors() throws Exception {
        EditorStateTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        EditorStateTest.setFileContentSrc("test/MyObject.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyObject {", "  // filler", "}"));
        EditorStateTest.setFileContentSrc("test/MyPropertyEditor.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPropertyEditor extends java.beans.PropertyEditorSupport {", "}"));
        EditorStateTest.setFileContentSrc("test/MyPanelBeanInfo.java", this.getTestSource("public class MyPanelBeanInfo extends java.beans.SimpleBeanInfo {", "  public MyPanelBeanInfo() {", "    java.beans.PropertyEditorManager.registerEditor(MyObject.class, MyPropertyEditor.class);", "  }", "}"));
        EditorStateTest.waitForAutoBuild();
        if ((double)EnvironmentUtils.getJavaVersion() >= 1.7) {
            return;
        }
        Map registry = (Map)ReflectionUtils.invokeMethod(PropertyEditorManager.class, (String)"getRegistry()", (Object[])new Object[0]);
        int initialEditors = registry.size();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends MyPanel {", "  public Test() {", "  }", "}");
        EditorStateTest.assertInstanceOf(CompositeClassLoader.class, (Object)this.m_lastLoader);
        EditorStateTest.assertNull((Object)this.m_lastLoader.getResource("test/NoSuchClass.class"));
        EditorStateTest.assertNotNull((Object)this.m_lastLoader.getResource("test/MyObject.class"));
        EditorStateTest.assertEquals((long)(initialEditors + 1), (long)registry.size());
        boolean found = false;
        for (Map.Entry entry : registry.entrySet()) {
            Class valueClass = (Class)entry.getKey();
            Class editorClass = (Class)entry.getValue();
            if (!valueClass.getName().equals("test.MyObject") || !editorClass.getName().equals("test.MyPropertyEditor")) continue;
            found = true;
            break;
        }
        EditorStateTest.assertTrue((boolean)found);
        panel.getBroadcastObject().dispose();
        EditorStateTest.assertEquals((long)initialEditors, (long)registry.size());
    }

    @Test
    public void test_clearUIManager() throws Exception {
        String key = "wbp.EditorStateTest";
        EditorStateTest.setFileContentSrc("test/MyObject.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyObject {", "  // filler filler filler", "}"));
        EditorStateTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        Class<?> myObjectClass = this.m_lastLoader.loadClass("test.MyObject");
        UIManager.put(key, myObjectClass);
        EditorStateTest.assertNotNull((Object)UIManager.get(key));
        panel.getBroadcastObject().dispose();
        EditorStateTest.assertNull((Object)UIManager.get(key));
    }
}

