/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.ExposedFieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.Test;

public class ExposedFieldTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        m_javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "m_");
        ExposedFieldTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "}"));
        ExposedFieldTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        ExposedFieldTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {field: javax.swing.JButton} {m_button} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExposedFieldVariableSupport variableSupport = (ExposedFieldVariableSupport)button.getVariableSupport();
        ExposedFieldTest.assertEquals((Object)"m_button", (Object)variableSupport.toString());
        ExposedFieldTest.assertEquals((Object)"m_button", (Object)variableSupport.getTitle());
        ExposedFieldTest.assertTrue((boolean)variableSupport.hasExpression(null));
        NodeTarget target22 = ExposedFieldTest.getNodeBlockTarget((JavaInfo)panel, true, new int[0]);
        ExposedFieldTest.assertEquals((Object)"m_button", (Object)variableSupport.getReferenceExpression(target22));
        ExposedFieldTest.assertEquals((Object)"m_button.", (Object)variableSupport.getAccessExpression(target22));
        ExposedFieldTest.assertEquals((Object)"thisButton", (Object)variableSupport.getComponentName());
        ExposedFieldTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            ExposedFieldTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        try {
            variableSupport.setName("foo");
            ExposedFieldTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        ExposedFieldTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            ExposedFieldTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        ExposedFieldTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            ExposedFieldTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        target22 = variableSupport.getStatementTarget();
        StatementTarget frameTarget = panel.getVariableSupport().getStatementTarget();
        ExposedFieldTest.assertSame((Object)frameTarget.getBlock(), (Object)target22.getBlock());
        ExposedFieldTest.assertSame((Object)frameTarget.getStatement(), (Object)target22.getStatement());
        ExposedFieldTest.assertEquals((Object)frameTarget.isBefore(), (Object)target22.isBefore());
    }

    @Test
    public void test_getChildTarget() throws Exception {
        ExposedFieldTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "}"));
        ExposedFieldTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        StatementTarget target = variableSupport.getChildTarget();
        ExposedFieldTest.assertEquals((Object)JavaInfoUtils.getTarget((JavaInfo)panel, null).toString(), (Object)target.toString());
    }

    @Test
    public void test_addButton() throws Exception {
        ExposedFieldTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container = new JPanel();", "  public MyPanel() {", "    add(m_container);", "  }", "}"));
        ExposedFieldTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "    m_container.setEnabled(true);", "  }", "}"};
        ContainerInfo frame = this.parseContainer(lines);
        ContainerInfo container = (ContainerInfo)frame.getChildrenComponents().get(0);
        FlowLayoutInfo layout = (FlowLayoutInfo)container.getLayout();
        ComponentInfo button = ExposedFieldTest.createJButton();
        layout.add(button, null);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    m_container.setEnabled(true);", "    {", "      JButton button = new JButton();", "      m_container.add(button);", "    }", "  }", "}");
    }
}

