/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.IPaletteSite;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.ImageUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ComponentEntryInfoTest
extends AbstractPaletteTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_access() throws Exception {
        ComponentEntryInfo componentEntry = new ComponentEntryInfo();
        componentEntry.setComponentClassName("javax.swing.JPanel");
        ComponentEntryInfoTest.assertEquals((Object)"Component(class='javax.swing.JPanel')", (Object)componentEntry.toString());
        ComponentEntryInfoTest.assertEquals((Object)"javax.swing.JPanel", (Object)componentEntry.getClassName());
        componentEntry.setComponentClassName("javax.swing.JButton");
        ComponentEntryInfoTest.assertEquals((Object)"javax.swing.JButton", (Object)componentEntry.getClassName());
        ComponentEntryInfoTest.assertNull((Object)componentEntry.getCreationId());
        componentEntry.setCreationId("my creation id");
        ComponentEntryInfoTest.assertEquals((Object)"my creation id", (Object)componentEntry.getCreationId());
    }

    @Test
    public void test_parse_onlyClass() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='javax.swing.JPanel'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo entry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        ComponentEntryInfoTest.assertEquals((Object)"category_1 javax.swing.JPanel", (Object)entry.getId());
        ComponentEntryInfoTest.assertEquals((Object)"javax.swing.JPanel", (Object)entry.getClassName());
        ComponentEntryInfoTest.assertNull((Object)entry.getCreationId());
        ComponentEntryInfoTest.assertNull((Object)entry.getDescription());
        ComponentEntryInfoTest.assertEquals((Object)"javax.swing.JPanel", (Object)entry.getName());
        ComponentEntryInfoTest.assertSame((Object)ComponentEntryInfo.DEFAULT_ICON, (Object)entry.getIcon());
        ComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        ComponentEntryInfoTest.assertEquals((Object)"JPanel", (Object)entry.getName());
        ComponentEntryInfoTest.assertNotNull((Object)entry.getIcon());
        ComponentEntryInfoTest.assertEquals((Object)"Component(class='javax.swing.JPanel')", (Object)entry.toString());
    }

    @Test
    public void test_parse_valuesFromExtension() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='javax.swing.JPanel' creationId='creation id' id='my id' name='my name' description='my description' icon='icons/true.gif' visible='false'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo entry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        ComponentEntryInfoTest.assertEquals((Object)"my id", (Object)entry.getId());
        ComponentEntryInfoTest.assertEquals((Object)"javax.swing.JPanel", (Object)entry.getClassName());
        ComponentEntryInfoTest.assertEquals((Object)"creation id", (Object)entry.getCreationId());
        ComponentEntryInfoTest.assertEquals((Object)"my description", (Object)entry.getDescription());
        ComponentEntryInfoTest.assertEquals((Object)"my name", (Object)entry.getName());
        ImageDescriptor icon = entry.getIcon();
        ComponentEntryInfoTest.assertNotNull((Object)icon);
        ComponentEntryInfoTest.assertEquals((long)16L, (long)icon.getImageData((int)100).width);
        ComponentEntryInfoTest.assertEquals((long)16L, (long)icon.getImageData((int)100).height);
        ComponentEntryInfoTest.assertFalse((boolean)entry.isVisible());
    }

    @Test
    public void test_parse_descriptionText_emptyString() throws Exception {
        this.assertDescriptionText_fromComponentDescription("");
    }

    @Test
    public void test_parse_descriptionText_spacesString() throws Exception {
        this.assertDescriptionText_fromComponentDescription(" \t");
    }

    @Test
    public void test_parse_descriptionText_className() throws Exception {
        this.assertDescriptionText_fromComponentDescription("javax.swing.JPanel");
    }

    private void assertDescriptionText_fromComponentDescription(String descriptionAttribute) throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='javax.swing.JPanel' description='" + descriptionAttribute + "'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo entry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        ComponentEntryInfoTest.assertEquals((Object)"A generic lightweight container.", (Object)entry.getDescription());
    }

    @Test
    public void test_initialize_1_allDefaults() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='javax.swing.JPanel'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo entry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertNull((Object)entry.getDescription());
        ComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, JPanel.class);
        CreationDescription creation = componentDescription.getCreation(null);
        ComponentEntryInfoTest.assertEquals((Object)creation.getDescription(), (Object)entry.getDescription());
        ComponentEntryInfoTest.assertTrue((String)"Same icons.", (boolean)UiUtils.equals((ImageDescriptor)creation.getIcon(), (ImageDescriptor)entry.getIcon()));
    }

    @Test
    public void test_initialize_2_badComponentClass() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        ComponentEntryInfoTest.assertEquals((long)0L, (long)this.m_lastState.getWarnings().size());
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='no.such.Component'/>", "</category>"});
        PaletteInfo palette = this.loadPalette(panel);
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertEquals((Object)"no.such.Component", (Object)componentEntry.getName());
        ComponentEntryInfoTest.assertSame((Object)ComponentEntryInfo.DEFAULT_ICON, (Object)componentEntry.getIcon());
        ComponentEntryInfoTest.assertFalse((boolean)componentEntry.initialize(null, panel));
        Assertions.assertThat((List)this.m_lastState.getWarnings()).isEmpty();
    }

    @Test
    public void test_initialize_2_badComponentDescription() throws Exception {
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(boolean value) {", "  }", "}"));
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentEntryInfoTest.getSourceDQ("something bad"));
        ComponentEntryInfoTest.waitForAutoBuild();
        ComponentEntryInfoTest.waitEventLoop(10);
        ComponentEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseSource("test", "Test.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}"));
        ComponentEntryInfoTest.assertEquals((long)0L, (long)this.m_lastState.getWarnings().size());
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='test.MyPanel'/>", "</category>"});
        PaletteInfo palette = this.loadPalette(panel);
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertFalse((boolean)componentEntry.initialize(null, panel));
        Assertions.assertThat((List)this.m_lastState.getWarnings()).hasSize(1);
    }

    @Test
    public void test_initialize_noDescription() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='java.lang.String'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteInfo palette = this.loadPalette(panel);
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertNull((Object)componentEntry.getDescription());
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, panel));
        ComponentEntryInfoTest.assertEquals((Object)"java.lang.String", (Object)componentEntry.getDescription());
    }

    @Test
    public void test_initialize_severalCreations() throws Exception {
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(boolean value) {", "  }", "}"));
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentEntryInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation id='true'>", "    <source><![CDATA[new test.MyPanel(true)]]></source>", "  </creation>", "  <creation id='false'>", "    <source><![CDATA[new test.MyPanel(false)]]></source>", "  </creation>", "</component>"));
        ComponentEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseSource("test", "Test2.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test2 extends JPanel {", "  public Test2() {", "  }", "}"));
        PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='test.MyPanel' creationId='false'/>", "</category>"});
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, panel));
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.isEnabled());
        ComponentEntryInfoTest.assertEquals((Object)"test.MyPanel", (Object)componentEntry.getClassName());
        ComponentEntryInfoTest.assertEquals((Object)"category_1 test.MyPanel false", (Object)componentEntry.getId());
        CreationTool creationTool = (CreationTool)componentEntry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        JavaInfo javaInfo = (JavaInfo)creationFactory.getNewObject();
        ComponentEntryInfoTest.assertEquals((Object)"new test.MyPanel(false)", (Object)javaInfo.getCreationSupport().add_getSource(null));
    }

    @Test
    public void test_initialize_noSuchCreation() throws Exception {
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "}"));
        ComponentEntryInfoTest.waitForAutoBuild();
        JavaInfo panel = this.parseEmptyPanel();
        PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='test.MyPanel' creationId='noSuchCreation'/>", "</category>"});
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        Assertions.assertThat((List)this.m_lastState.getWarnings()).hasSize(0);
        ComponentEntryInfoTest.assertFalse((boolean)componentEntry.initialize(null, panel));
        Assertions.assertThat((List)this.m_lastState.getWarnings()).hasSize(1);
    }

    @Test
    public void test_isEnabled_enabledScript() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='javax.swing.JPanel' name='my name' enabled='1 == 2'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo entry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        ComponentEntryInfoTest.assertEquals((Object)"javax.swing.JPanel", (Object)entry.getClassName());
        ComponentEntryInfoTest.assertEquals((Object)"my name", (Object)entry.getName());
        ComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        ComponentEntryInfoTest.assertFalse((boolean)entry.isEnabled());
    }

    @Test
    public void test_createTool() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='javax.swing.JPanel'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, this.m_lastParseInfo));
        CreationTool creationTool = (CreationTool)componentEntry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        JavaInfo javaInfo = (JavaInfo)creationFactory.getNewObject();
        ComponentEntryInfoTest.assertInstanceOf(JPanelInfo.class, (Object)javaInfo);
        ComponentEntryInfoTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)javaInfo.getCreationSupport());
        ComponentEntryInfoTest.assertSame((Object)Boolean.TRUE, (Object)javaInfo.getArbitraryValue((Object)"manuallyCreatedComponent"));
        creationFactory.activate();
        ComponentEntryInfoTest.assertNotSame((Object)javaInfo, (Object)creationFactory.getNewObject());
    }

    @Test
    public void test_createTool_abstractClass() throws Exception {
        ComponentEntryInfoTest.setFileContentSrc("test/MyAbstractButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyAbstractButton extends JButton {", "}"));
        ComponentEntryInfoTest.waitForAutoBuild();
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='test.MyAbstractButton'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        final ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        IPaletteSite.Helper.setSite((ObjectInfo)this.m_lastParseInfo, (IPaletteSite)new IPaletteSite.Empty(){

            public Shell getShell() {
                return DesignerPlugin.getShell();
            }
        });
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, this.m_lastParseInfo));
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                CreationTool creationTool = (CreationTool)componentEntry.createTool();
                ComponentEntryInfoTest.assertNull((Object)creationTool);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Error").bot();
                shell.button("OK").click();
            }
        });
    }

    @Test
    public void test_createTool_abstractClass_ignored() throws Exception {
        ComponentEntryInfoTest.setFileContentSrc("test/MyAbstractButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyAbstractButton extends JButton {", "}"));
        ComponentEntryInfoTest.setFileContentSrc("test/MyAbstractButton.wbp-component.xml", ComponentEntryInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyAbstractButton(){}]]></source>", "    <tag name='createAnonymous' value='true'/>", "  </creation>", "</component>"));
        ComponentEntryInfoTest.waitForAutoBuild();
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='test.MyAbstractButton'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        IPaletteSite.Helper.setSite((ObjectInfo)this.m_lastParseInfo, (IPaletteSite)new IPaletteSite.Empty(){

            public Shell getShell() {
                return DesignerPlugin.getShell();
            }
        });
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, this.m_lastParseInfo));
        CreationTool creationTool = (CreationTool)componentEntry.createTool();
        ComponentEntryInfoTest.assertNotNull((Object)creationTool);
    }

    @Test
    public void test_createTool_badClass() throws Exception {
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='no.such.Class'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
        this.m_lastParseInfo.putArbitraryValue((Object)"ComponentEntryInfo.simulatePresentation", (Object)true);
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, this.m_lastParseInfo));
        Assertions.assertThat((List)this.m_lastState.getWarnings()).hasSize(0);
        CreationTool creationTool = (CreationTool)componentEntry.createTool();
        ComponentEntryInfoTest.assertNull((Object)creationTool);
        Assertions.assertThat((List)this.m_lastState.getWarnings()).hasSize(1);
    }

    @DisposeProjectAfter
    @Test
    public void test_createTool_withLibrary() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("myClasses.zip").add(className.replace('.', '/') + ".java", "src").close();
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "</toolkit>");
            testBundle.install();
            try {
                ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='" + className + "'>", "    <library type='" + className + "' bundle='" + testBundle.getId() + "' jar='myClasses.jar' src='myClasses.zip'/>", "  </component>", "</category>"});
                ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
                PaletteInfo palette = this.loadPalette((JavaInfo)panel);
                ComponentEntryInfoTest.assertNull((Object)m_javaProject.findType(className));
                CategoryInfo category = palette.getCategory("category_1");
                ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
                ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, (JavaInfo)panel));
                CreationTool creationTool = (CreationTool)componentEntry.createTool();
                ICreationFactory creationFactory = creationTool.getFactory();
                creationFactory.activate();
                ComponentInfo newComponent = (ComponentInfo)creationFactory.getNewObject();
                ComponentEntryInfoTest.assertEquals((Object)className, (Object)newComponent.getDescription().getComponentClass().getName());
                ComponentEntryInfoTest.assertNotNull((Object)m_javaProject.findType(className));
            }
            finally {
                testBundle.uninstall();
                ComponentEntryInfoTest.waitEventLoop(0);
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_createTool_withLibrary2() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            String className2 = ClassForBundle2.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("myClasses.zip").add(className.replace('.', '/') + ".java", "src").close();
            testBundle.addJar("myClasses2.jar").addClass(ClassForBundle2.class).close();
            testBundle.addJar("myClasses2.zip").add(className2.replace('.', '/') + ".java", "src").close();
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses2.jar'/>", "</toolkit>");
            testBundle.install();
            try {
                ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='" + className2 + "'>", "    <library type='" + className + "' bundle='" + testBundle.getId() + "' jar='myClasses.jar' src='myClasses.zip'/>", "    <library type='" + className2 + "' bundle='" + testBundle.getId() + "' jar='myClasses2.jar' src='myClasses2.zip'/>", "  </component>", "</category>"});
                ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
                PaletteInfo palette = this.loadPalette((JavaInfo)panel);
                ComponentEntryInfoTest.assertNull((Object)m_javaProject.findType(className));
                CategoryInfo category = palette.getCategory("category_1");
                ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
                ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, (JavaInfo)panel));
                CreationTool creationTool = (CreationTool)componentEntry.createTool();
                ICreationFactory creationFactory = creationTool.getFactory();
                creationFactory.activate();
                ComponentInfo newComponent = (ComponentInfo)creationFactory.getNewObject();
                ComponentEntryInfoTest.assertEquals((Object)className2, (Object)newComponent.getDescription().getComponentClass().getName());
                ComponentEntryInfoTest.assertNotNull((Object)m_javaProject.findType(className2));
                ComponentEntryInfoTest.assertNotNull((Object)m_javaProject.findType(className));
            }
            finally {
                testBundle.uninstall();
                ComponentEntryInfoTest.waitEventLoop(0);
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_createTool_withLibrary_whenPDE() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_project, null);
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("myClasses.zip").add(className.replace('.', '/') + ".java", "src").close();
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "</toolkit>");
            testBundle.install();
            ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component class='" + className + "'>", "    <library type='" + className + "' bundle='" + testBundle.getId() + "' jar='myClasses.jar' src='myClasses.zip'/>", "  </component>", "</category>"});
            PaletteInfo palette = this.loadPalette();
            ComponentEntryInfoTest.assertNull((Object)m_javaProject.findType(className));
            CategoryInfo category = palette.getCategory("category_1");
            ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
            ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, this.m_lastParseInfo));
            componentEntry.createTool();
            ComponentEntryInfoTest.assertNotNull((Object)m_javaProject.findType(className));
            String manifest = ComponentEntryInfoTest.getFileContent("META-INF/MANIFEST.MF");
            Assertions.assertThat((String)manifest).contains(new CharSequence[]{"Bundle-ClassPath: .,\n myClasses.jar"});
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_hasClass_noSpecialRule() throws Exception {
        this.prepareMyComponent(new String[0]);
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='t' class='test.MyComponent'/>", "</category>"});
        ComponentEntryInfo entry = this.loadSingleComponent("t");
        this.assertHasClass(entry, true);
    }

    @Test
    public void test_hasClass_useWitness_true() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.core.paletteComponentExists", "<component package='test.' witness='test2.Witness'/>");
            testBundle.install(true);
            ComponentEntryInfoTest.setFileContentSrc("test2/Witness.java", ComponentEntryInfoTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "package test2;", "public class Witness {", "}"));
            ComponentEntryInfoTest.waitForAutoBuild();
            ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='t' class='test.NoSuchComponent'/>", "</category>"});
            ComponentEntryInfo entry = this.loadSingleComponent("t");
            this.assertHasClass(entry, true);
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_hasClass_useWitness_false() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.core.paletteComponentExists", "<component package='test.' witness='test2.Witness'/>");
            testBundle.install(true);
            this.prepareMyComponent(new String[0]);
            ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='t' class='test.MyComponent'/>", "</category>"});
            ComponentEntryInfo entry = this.loadSingleComponent("t");
            this.assertHasClass(entry, false);
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_hasClass_hasType_false() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.core.paletteComponentExists", "<component package='test.' hasType='true'/>");
            testBundle.install(true);
            this.prepareMyComponent(new String[0]);
            ComponentEntryInfoTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"test.MyComponent"));
            ComponentEntryInfoTest.assertTrue((boolean)ComponentEntryInfoTest.getFile("bin/test/MyComponent.class").exists());
            ComponentEntryInfoTest.getFileSrc("test/MyComponent.java").delete(true, null);
            ComponentEntryInfoTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"test.MyComponent"));
            ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='t' class='test.MyComponent'/>", "</category>"});
            ComponentEntryInfo entry = this.loadSingleComponent("t");
            this.assertHasClass(entry, false);
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_hasClass_hasType_true() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.core.paletteComponentExists", "<component package='test.' hasType='true'/>");
            testBundle.install(true);
            this.prepareMyComponent(new String[0]);
            ComponentEntryInfoTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"test.MyComponent"));
            ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='t' class='test.MyComponent'/>", "</category>"});
            ComponentEntryInfo entry = this.loadSingleComponent("t");
            this.assertHasClass(entry, true);
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_hasClass_always() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.core.paletteComponentExists", "<component package='test.' always='true'/>");
            testBundle.install(true);
            ComponentEntryInfoTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"test.MyComponent"));
            ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='t' class='test.MyComponent'/>", "</category>"});
            ComponentEntryInfo entry = this.loadSingleComponent("t");
            this.assertHasClass(entry, true);
        }
        finally {
            testBundle.dispose();
        }
    }

    private void assertHasClass(ComponentEntryInfo entry, boolean expected) throws Exception {
        entry.initialize(null, this.m_lastParseInfo);
        ComponentEntryInfoTest.assertEquals((Object)expected, (Object)ReflectionUtils.invokeMethod((Object)entry, (String)"hasClass()", (Object[])new Object[0]));
    }

    @Test
    public void test_preloadingCache() throws Exception {
        TestBundle testBundle = new TestBundle();
        Image image = new Image(null, 11, 29);
        try {
            String className = ClassForBundle.class.getName();
            String descriptionsPath = "wbp-meta/" + CodeUtils.getPackage((String)className).replace('.', '/') + "/";
            testBundle.addClass(ClassForBundle.class);
            testBundle.setFile(descriptionsPath + ".wbp-cache-descriptions", "Please, cache this package.");
            String componentPath = descriptionsPath + StringUtils.substringAfterLast((String)className, (String)".");
            testBundle.setFile(componentPath + ".wbp-component.xml", ComponentEntryInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>test1 test2 <p attr='val'>test3</p> test4 test5</description>", "</component>"));
            testBundle.setFile(componentPath + ".png", ImageUtils.getBytesPNG((Image)image));
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <palette>", "    <category id='org.eclipse.wb.tests.testBundle.components' name='Test' description='Test'>", "      <component class='" + className + "'/>", "    </category>", "  </palette>", "</toolkit>");
            testBundle.install();
            try {
                String toolkitId = "org.eclipse.wb.swing";
                Object cache = ReflectionUtils.invokeMethod(ComponentPresentationHelper.class, (String)"getCache(java.lang.String)", (Object[])new Object[]{toolkitId});
                ReflectionUtils.invokeMethod(ComponentPresentationHelper.class, (String)("fillPresentations(" + cache.getClass().getName().replace("$", ".") + ",java.lang.String,org.eclipse.core.runtime.IProgressMonitor)"), (Object[])new Object[]{cache, toolkitId, new NullProgressMonitor()});
                ComponentPresentation presentation = (ComponentPresentation)ReflectionUtils.invokeMethod((Object)cache, (String)"get(java.lang.String)", (Object[])new Object[]{className + " null"});
                ComponentEntryInfoTest.assertNotNull((Object)presentation);
                ComponentEntryInfoTest.assertEquals((Object)"test1 test2 <p attr=\"val\">test3</p> test4 test5", (Object)presentation.getDescription());
                ImageDescriptor icon = presentation.getIcon();
                ComponentEntryInfoTest.assertNotNull((Object)icon);
                ComponentEntryInfoTest.assertEquals((long)icon.getImageData((int)100).width, (long)11L);
                ComponentEntryInfoTest.assertEquals((long)icon.getImageData((int)100).height, (long)29L);
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            image.dispose();
            testBundle.dispose();
        }
    }

    @Test
    public void test_typeParameters_chooseType() throws Exception {
        final ComponentEntryInfo componentEntry = this.prepare_typeParameters();
        final AtomicReference creationToolResult = new AtomicReference();
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                CreationTool result = (CreationTool)componentEntry.createTool();
                creationToolResult.set(result);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Generic component creation").bot();
                SWTBotText textWidget = shell.textWithLabel("Row type:");
                ComponentEntryInfoTest.assertEquals((Object)"java.lang.Object", (Object)textWidget.getText());
                shell.button("...").click();
                ComponentEntryInfoTest.animateOpenTypeSelection(bot, "java.lang.String", "OK");
                ComponentEntryInfoTest.assertEquals((Object)"java.lang.String", (Object)textWidget.getText());
                shell.button("OK").click();
            }
        });
        CreationTool creationTool = (CreationTool)creationToolResult.get();
        ComponentEntryInfoTest.assertNotNull((Object)creationTool);
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        ComponentInfo newComponent = (ComponentInfo)creationFactory.getNewObject();
        Map templateArguments = newComponent.getTemplateArguments();
        Assertions.assertThat((Map)templateArguments).contains(new Map.Entry[]{MapEntry.entry((Object)"rowType", (Object)"java.lang.String")});
    }

    @Test
    public void test_typeParameters_cancel() throws Exception {
        final ComponentEntryInfo componentEntry = this.prepare_typeParameters();
        final AtomicReference creationToolResult = new AtomicReference();
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                CreationTool result = (CreationTool)componentEntry.createTool();
                creationToolResult.set(result);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Generic component creation").bot();
                SWTBotText textWidget = shell.textWithLabel("Row type:");
                ComponentEntryInfoTest.assertEquals((Object)"java.lang.Object", (Object)textWidget.getText());
                shell.button("...").click();
                ComponentEntryInfoTest.animateOpenTypeSelection(bot, "java.lang.String", "Cancel");
                ComponentEntryInfoTest.assertEquals((Object)"java.lang.Object", (Object)textWidget.getText());
                shell.button("Cancel").click();
            }
        });
        CreationTool creationTool = (CreationTool)creationToolResult.get();
        ComponentEntryInfoTest.assertNull((Object)creationTool);
    }

    @Test
    public void test_typeParameters_chooseBadType() throws Exception {
        String line = "<typeParameter name='rowType' type='java.util.List' title='My type'/>";
        final ComponentEntryInfo componentEntry = this.prepare_typeParameters(line);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                componentEntry.createTool();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Generic component creation").bot();
                shell.button("...").click();
                ComponentEntryInfoTest.animateOpenTypeSelection(bot, "java.lang.String", "OK");
                bot.shell("Error").bot().button("OK").click();
                shell.button("Cancel").click();
            }
        });
    }

    private ComponentEntryInfo prepare_typeParameters() throws Exception {
        String line = "<typeParameter name='rowType' type='java.lang.Object' title='Row type'/>";
        return this.prepare_typeParameters(line);
    }

    private ComponentEntryInfo prepare_typeParameters(String typeParameterLine) throws Exception {
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel<T> extends JPanel {", "}"));
        ComponentEntryInfoTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentEntryInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyPanel<%rowType%>()]]></source>", "    <typeParameters>", "      " + typeParameterLine, "    </typeParameters>", "  </creation>", "</component>"));
        ComponentEntryInfoTest.waitForAutoBuild();
        ComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <component id='myId' class='test.MyPanel'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        ComponentEntryInfo componentEntry = (ComponentEntryInfo)palette.getEntry("myId");
        ComponentEntryInfoTest.assertTrue((boolean)componentEntry.initialize(null, this.m_lastParseInfo));
        return componentEntry;
    }

    public static class ClassForBundle
    extends JButton {
        private static final long serialVersionUID = 0L;
    }

    public static class ClassForBundle2
    extends ClassForBundle {
        private static final long serialVersionUID = 0L;
    }
}

