/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.ObserveTypeContainer;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailSetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.SetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.WritableListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.WritableSetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.ListBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.SetBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.ValueBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateListStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateSetStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateValueStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.input.TreeViewerInputBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.input.ViewerInputBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.CheckedElementsObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.ItemsSwtObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.MultiSelectionObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.SingleSelectionObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.SwtObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.TextSwtObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.ui.property.BindingsProperty;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoRelatedTest;
import org.eclipse.wb.tests.designer.core.model.util.MorphingSupportTest;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.Test;

public class DatabindingsProviderTest
extends AbstractBindingTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_common() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo());
        DatabindingsProviderTest.assertNull((Object)provider.getRootInfo().getInitDataBindings());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo().getBindings());
        DatabindingsProviderTest.assertTrue((boolean)provider.getRootInfo().getContextInfo().getBindings().isEmpty());
        DatabindingsProviderTest.assertNull((Object)provider.getRootInfo().getContextInfo().getVariableIdentifier());
        List types = provider.getTypes();
        DatabindingsProviderTest.assertEquals((long)2L, (long)types.size());
        DatabindingsProviderTest.assertSame((Object)ObserveType.BEANS, types.get(0));
        DatabindingsProviderTest.assertSame((Object)ObserveType.BEANS, (Object)provider.getModelStartType());
        DatabindingsProviderTest.assertSame((Object)ObserveType.WIDGETS, types.get(1));
        DatabindingsProviderTest.assertSame((Object)ObserveType.WIDGETS, (Object)provider.getTargetStartType());
        List containers = provider.getContainers();
        DatabindingsProviderTest.assertEquals((long)2L, (long)containers.size());
        DatabindingsProviderTest.assertSame((Object)ObserveType.BEANS, (Object)((ObserveTypeContainer)containers.get(0)).getObserveType());
        DatabindingsProviderTest.assertSame(containers.get(0), (Object)provider.getContainer(ObserveType.BEANS));
        DatabindingsProviderTest.assertTrue((boolean)((ObserveTypeContainer)containers.get(0)).isModelStartType());
        DatabindingsProviderTest.assertFalse((boolean)((ObserveTypeContainer)containers.get(0)).isTargetStartType());
        DatabindingsProviderTest.assertSame((Object)ObserveType.WIDGETS, (Object)((ObserveTypeContainer)containers.get(1)).getObserveType());
        DatabindingsProviderTest.assertSame(containers.get(1), (Object)provider.getContainer(ObserveType.WIDGETS));
        DatabindingsProviderTest.assertFalse((boolean)((ObserveTypeContainer)containers.get(1)).isModelStartType());
        DatabindingsProviderTest.assertTrue((boolean)((ObserveTypeContainer)containers.get(1)).isTargetStartType());
    }

    @Test
    public void test_context_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    return bindingContext;", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getInitDataBindings());
        DatabindingsProviderTest.assertEquals((Object)"initDataBindings", (Object)provider.getRootInfo().getInitDataBindings().getName().getIdentifier());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo().getBindings());
        DatabindingsProviderTest.assertTrue((boolean)provider.getRootInfo().getContextInfo().getBindings().isEmpty());
        DatabindingsProviderTest.assertEquals((Object)"bindingContext", (Object)provider.getRootInfo().getContextInfo().getVariableIdentifier());
        DatabindingsProviderTest.assertFalse((boolean)provider.getRootInfo().getContextInfo().isAddInitializeContext());
        DatabindingsProviderTest.assertNull((Object)provider.getRootInfo().getContextInfo().getUserTryCatchBlock());
    }

    @Test
    public void test_context_2() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    initializeContext(bindingContext);", "    return bindingContext;", "  }", "  protected void initializeContext(DataBindingContext context) {", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getInitDataBindings());
        DatabindingsProviderTest.assertEquals((Object)"initDataBindings", (Object)provider.getRootInfo().getInitDataBindings().getName().getIdentifier());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo().getBindings());
        DatabindingsProviderTest.assertTrue((boolean)provider.getRootInfo().getContextInfo().getBindings().isEmpty());
        DatabindingsProviderTest.assertEquals((Object)"bindingContext", (Object)provider.getRootInfo().getContextInfo().getVariableIdentifier());
        DatabindingsProviderTest.assertTrue((boolean)provider.getRootInfo().getContextInfo().isAddInitializeContext());
        DatabindingsProviderTest.assertNull((Object)provider.getRootInfo().getContextInfo().getUserTryCatchBlock());
    }

    @Test
    public void test_context_3() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    try {", "    } catch (Throwable e) {", "        System.out.println(e);", "    } finally {", "        System.out.println(bindingContext);", "    }", "    return bindingContext;", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getInitDataBindings());
        DatabindingsProviderTest.assertEquals((Object)"initDataBindings", (Object)provider.getRootInfo().getInitDataBindings().getName().getIdentifier());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo());
        DatabindingsProviderTest.assertNotNull((Object)provider.getRootInfo().getContextInfo().getBindings());
        DatabindingsProviderTest.assertTrue((boolean)provider.getRootInfo().getContextInfo().getBindings().isEmpty());
        DatabindingsProviderTest.assertEquals((Object)"bindingContext", (Object)provider.getRootInfo().getContextInfo().getVariableIdentifier());
        DatabindingsProviderTest.assertFalse((boolean)provider.getRootInfo().getContextInfo().isAddInitializeContext());
        DatabindingsProviderTest.assertEquals((Object)"} catch (Throwable e) {\n\t\t\t\tSystem.out.println(e);\n\t\t} finally {\n\t\t\t\tSystem.out.println(bindingContext);\n\t\t}", (Object)provider.getRootInfo().getContextInfo().getUserTryCatchBlock());
    }

    @Test
    public void test_updateBindables() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Object m_object;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_object = new GridData();", "    m_shell.setLayoutData(m_object);", "    m_shell.setLayout(new FillLayout());", "    Button button = new Button(m_shell, SWT.NONE);", "    button.setText(\"New Button\");", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)3L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"m_object - Object", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        AbstractJavaInfoRelatedTest.getJavaInfoByName("button").delete();
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Object m_object;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_object = new GridData();", "    m_shell.setLayoutData(m_object);", "    m_shell.setLayout(new FillLayout());", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_synchronizedObserves() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)2L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        List widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        IObserveInfo shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        DatabindingsProviderTest.assertTrue((boolean)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).isEmpty());
        ControlInfo buttonInfo = (ControlInfo)DatabindingsProviderTest.createJavaInfo("org.eclipse.swt.widgets.Button");
        shell.getLayout().command_CREATE(buttonInfo, null);
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      Button button = new Button(m_shell, SWT.NONE);", "      button.setText(\"New Button\");", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)2L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        List shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)1L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"button - \"New Button\"", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
        buttonInfo.getVariableSupport().convertLocalToField();
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Button button;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      button = new Button(m_shell, SWT.NONE);", "      button.setText(\"New Button\");", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)3L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"button - Button", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)1L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"button - \"New Button\"", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
        final ControlInfo comboInfo = (ControlInfo)DatabindingsProviderTest.createJavaInfo("org.eclipse.swt.widgets.Combo");
        shell.getLayout().command_CREATE(comboInfo, null);
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Button button;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      button = new Button(m_shell, SWT.NONE);", "      button.setText(\"New Button\");", "    }", "    {", "      Combo combo = new Combo(m_shell, SWT.NONE);", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)3L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"button - Button", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)2L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"button - \"New Button\"", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"combo", (Object)((IObserveInfo)shellChildren.get(1)).getPresentation().getText());
        shell.getLayout().command_MOVE(comboInfo, buttonInfo);
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Button button;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      Combo combo = new Combo(m_shell, SWT.NONE);", "    }", "    {", "      button = new Button(m_shell, SWT.NONE);", "      button.setText(\"New Button\");", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)3L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"button - Button", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)2L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"combo", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"button - \"New Button\"", (Object)((IObserveInfo)shellChildren.get(1)).getPresentation().getText());
        comboInfo.getVariableSupport().convertLocalToField();
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Button button;", "  private Combo combo;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      combo = new Combo(m_shell, SWT.NONE);", "    }", "    {", "      button = new Button(m_shell, SWT.NONE);", "      button.setText(\"New Button\");", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)4L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"button - Button", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"combo - Combo", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(3)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)2L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"combo", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"button - \"New Button\"", (Object)((IObserveInfo)shellChildren.get(1)).getPresentation().getText());
        buttonInfo.delete();
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Combo combo;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      combo = new Combo(m_shell, SWT.NONE);", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)3L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"combo - Combo", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)1L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"combo", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
        ExecutionUtils.run((ObjectInfo)shell.getRootJava(), (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Class<?> textWidgetClass = DatabindingsProviderTest.this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Text");
                MorphingTargetDescription target = new MorphingTargetDescription(textWidgetClass, null);
                MorphingSupportTest.morph((JavaInfo)comboInfo, target);
            }
        });
        DatabindingsProviderTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Text combo;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    {", "      combo = new Text(m_shell, SWT.NONE);", "    }", "  }", "}"), this.m_lastEditor);
        beanObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        DatabindingsProviderTest.assertEquals((long)3L, (long)beanObservables.size());
        DatabindingsProviderTest.assertEquals((Object)"m_shell - Shell", (Object)((IObserveInfo)beanObservables.get(0)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"combo - Text", (Object)((IObserveInfo)beanObservables.get(1)).getPresentation().getText());
        DatabindingsProviderTest.assertEquals((Object)"getClass()", (Object)((IObserveInfo)beanObservables.get(2)).getPresentation().getText());
        widgetObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        DatabindingsProviderTest.assertEquals((long)1L, (long)widgetObservables.size());
        shellObserve = (IObserveInfo)widgetObservables.get(0);
        DatabindingsProviderTest.assertEquals((Object)"m_shell", (Object)shellObserve.getPresentation().getText());
        shellChildren = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        DatabindingsProviderTest.assertEquals((long)1L, (long)shellChildren.size());
        DatabindingsProviderTest.assertEquals((Object)"combo", (Object)((IObserveInfo)shellChildren.get(0)).getPresentation().getText());
    }

    @Test
    public void test_validate_reference() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)observables.get(0);
        List properties = shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(shellObserve, (IObserveInfo)properties.get(0), shellObserve, (IObserveInfo)properties.get(0)));
    }

    @Test
    public void test_validate_null() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo contextObserve = (IObserveInfo)beansObservables.get(10);
        IObserveInfo contextValidateStatusMapProperty_nullFactory = (IObserveInfo)contextObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        this.validateType(contextObserve, contextValidateStatusMapProperty_nullFactory, false, false, false, false, false, false, false);
    }

    @Test
    public void test_validate_InputCollection() throws Exception {
        DatabindingsProviderTest.setFileContentSrc("test/TestBean.java", DatabindingsProviderTest.getSourceDQ("package test;", "public class TestBean {", "  public String getValue() {", "    return null;", "  }", "  public java.util.List getValues() {", "    return null;", "  }", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        DatabindingsProviderTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private java.util.ArrayList m_list;", "  private TestBean m_bean;", "  private CheckboxTableViewer m_viewer;", "  private java.util.ArrayList m_otherList;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_viewer = new CheckboxTableViewer(m_shell, SWT.BORDER);", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo listObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo listInputCollectionPropety = (IObserveInfo)listObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo beanNamesProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IObserveInfo beanValueProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo beanValuesProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, beanObserve, beanNamesProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, beanObserve, beanValueProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, beanObserve, beanValuesProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(beanObserve, beanNamesProperty, listObserve, listInputCollectionPropety));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(beanObserve, beanValueProperty, listObserve, listInputCollectionPropety));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(beanObserve, beanValuesProperty, listObserve, listInputCollectionPropety));
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo tableObserve = (IObserveInfo)((IObserveInfo)widgetsObservables.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerSelectionDetailProperty = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IObserveInfo viewerMultiSelectionProperty = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo viewerCheckedProperty = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo viewerInputProperty = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, viewerObserve, viewerSelectionDetailProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(viewerObserve, viewerSelectionDetailProperty, listObserve, listInputCollectionPropety));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, viewerObserve, viewerMultiSelectionProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(viewerObserve, viewerMultiSelectionProperty, listObserve, listInputCollectionPropety));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, viewerObserve, viewerCheckedProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(viewerObserve, viewerCheckedProperty, listObserve, listInputCollectionPropety));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(listObserve, listInputCollectionPropety, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, listObserve, listInputCollectionPropety));
        IObserveInfo otherListObserve = (IObserveInfo)beansObservables.get(4);
        IObserveInfo otherListInputCollectionPropety = (IObserveInfo)otherListObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(listObserve, listInputCollectionPropety, otherListObserve, otherListInputCollectionPropety));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(otherListObserve, otherListInputCollectionPropety, listObserve, listInputCollectionPropety));
    }

    @Test
    public void test_validate_Input() throws Exception {
        DatabindingsProviderTest.setFileContentSrc("test/TestBean.java", DatabindingsProviderTest.getSourceDQ("package test;", "public class TestBean {", "  public String getValue() {", "    return null;", "  }", "  public java.util.List getValues() {", "    return null;", "  }", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        DatabindingsProviderTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private java.util.ArrayList m_list;", "  private TestBean m_bean;", "  private TableViewer m_viewer;", "  private WritableValue m_direct;", "  private CheckboxTableViewer m_otherViewer;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_viewer = new TableViewer(m_shell, SWT.BORDER);", "    m_otherViewer = new CheckboxTableViewer(m_shell, SWT.BORDER);", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo shellBackgroundObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(4);
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(shellObserve, shellBackgroundObserve, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(viewerObserve, viewerInputProperty, shellObserve, shellBackgroundObserve));
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo listObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo listInputCollectionPropety = (IObserveInfo)listObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(listObserve, listInputCollectionPropety, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, listObserve, listInputCollectionPropety));
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo beanValueProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo beanValuesProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo beanNamesProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(beanObserve, beanValueProperty, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(viewerObserve, viewerInputProperty, beanObserve, beanValueProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(beanObserve, beanValuesProperty, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, beanObserve, beanValuesProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(beanObserve, beanNamesProperty, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, beanObserve, beanNamesProperty));
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(4);
        IObserveInfo directDetailPropety = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(directObserve, directDetailPropety, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, directObserve, directDetailPropety));
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerMultiSelectionProperty = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo otherViewerCheckedProperty = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo otherViewerInputProperty = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(otherViewerObserve, otherViewerMultiSelectionProperty, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, otherViewerObserve, otherViewerMultiSelectionProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(otherViewerObserve, otherViewerCheckedProperty, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertTrue((boolean)provider.validate(viewerObserve, viewerInputProperty, otherViewerObserve, otherViewerCheckedProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(otherViewerObserve, otherViewerInputProperty, viewerObserve, viewerInputProperty));
        DatabindingsProviderTest.assertFalse((boolean)provider.validate(viewerObserve, viewerInputProperty, otherViewerObserve, otherViewerInputProperty));
    }

    @Test
    public void test_validate_OnlyList() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerMultiSelectionProperty_OnlyList = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        this.validateType(viewerObserve, viewerMultiSelectionProperty_OnlyList, true, false, false, true, false, false, true);
    }

    @Test
    public void test_validate_OnlySet() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerCheckedProperty_OnlySet = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.validateType(viewerObserve, viewerCheckedProperty_OnlySet, false, true, false, false, true, false, true);
    }

    @Test
    public void test_validate_OnlyValue() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo shellForegroundProperty = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.validateType(shellObserve, shellForegroundProperty, false, false, true, true, true, true, true);
    }

    @Test
    public void test_validate_List() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValuesProperty_List = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.validateType(beanObserve, beanValuesProperty_List, true, false, true, true, false, true, true);
    }

    @Test
    public void test_validate_Set() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanBeanNamesProperty_Set = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.validateType(beanObserve, beanBeanNamesProperty_Set, false, true, true, false, true, true, true);
    }

    @Test
    public void test_validate_Any() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValueProperty_Any = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        this.validateType(beanObserve, beanValueProperty_Any, false, false, true, true, true, true, true);
    }

    @Test
    public void test_validate_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerSelectionDetailProperty_Detail = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.validateType(viewerObserve, viewerSelectionDetailProperty_Detail, true, true, true, true, true, true, false);
    }

    private void createValidate() throws Exception {
        this.createValidate("CheckboxTableViewer");
    }

    private void createValidate(String viewerType) throws Exception {
        DatabindingsProviderTest.setFileContentSrc("test/TestBean.java", DatabindingsProviderTest.getSourceDQ("package test;", "public class TestBean {", "  public String getValue() {", "    return null;", "  }", "  public java.util.List getValues() {", "    return null;", "  }", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        DatabindingsProviderTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private TestBean m_bean;", "  private WritableValue m_direct;", "  private " + viewerType + " m_viewer;", "  private " + viewerType + " m_otherViewer;", "  private TestBean m_otherBean;", "  private java.util.ArrayList m_list;", "  private Text m_text;", "  private Combo m_combo;", "  private java.util.HashSet m_set;", "  private DataBindingContext m_context;", "  private TestBean m_bean1;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_viewer = new " + viewerType + "(m_shell, SWT.BORDER);", "    m_otherViewer = new " + viewerType + "(m_shell, SWT.BORDER);", "    m_text = new Text(m_shell, SWT.BORDER);", "    m_combo = new Combo(m_shell, SWT.BORDER);", "  }", "}"});
        DatabindingsProviderTest.assertNotNull((Object)shell);
    }

    private void validateType(IObserveInfo testObserve, IObserveInfo testProperty, boolean onlyList, boolean onlySet, boolean onlyValue, boolean list, boolean set, boolean any, boolean detail) throws Exception {
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo otherBeanObserve = (IObserveInfo)beansObservables.get(5);
        IObserveInfo otherBeanValueProperty_Any = (IObserveInfo)otherBeanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo otherBeanValuesProperty_List = (IObserveInfo)otherBeanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo otherBeanNamesProperty_Set = (IObserveInfo)otherBeanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo shellBackgroundObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerMultiSelectionProperty_OnlyList = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo otherViewerCheckedProperty_OnlySet = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        DatabindingsProviderTest.assertEquals((Object)onlyList, (Object)provider.validate(testObserve, testProperty, otherViewerObserve, otherViewerMultiSelectionProperty_OnlyList));
        DatabindingsProviderTest.assertEquals((Object)onlyList, (Object)provider.validate(otherViewerObserve, otherViewerMultiSelectionProperty_OnlyList, testObserve, testProperty));
        DatabindingsProviderTest.assertEquals((Object)onlySet, (Object)provider.validate(testObserve, testProperty, otherViewerObserve, otherViewerCheckedProperty_OnlySet));
        DatabindingsProviderTest.assertEquals((Object)onlySet, (Object)provider.validate(otherViewerObserve, otherViewerCheckedProperty_OnlySet, testObserve, testProperty));
        DatabindingsProviderTest.assertEquals((Object)onlyValue, (Object)provider.validate(testObserve, testProperty, shellObserve, shellBackgroundObserve));
        DatabindingsProviderTest.assertEquals((Object)onlyValue, (Object)provider.validate(shellObserve, shellBackgroundObserve, testObserve, testProperty));
        DatabindingsProviderTest.assertEquals((Object)list, (Object)provider.validate(testObserve, testProperty, otherBeanObserve, otherBeanValuesProperty_List));
        DatabindingsProviderTest.assertEquals((Object)list, (Object)provider.validate(otherBeanObserve, otherBeanValuesProperty_List, testObserve, testProperty));
        DatabindingsProviderTest.assertEquals((Object)set, (Object)provider.validate(testObserve, testProperty, otherBeanObserve, otherBeanNamesProperty_Set));
        DatabindingsProviderTest.assertEquals((Object)set, (Object)provider.validate(otherBeanObserve, otherBeanNamesProperty_Set, testObserve, testProperty));
        DatabindingsProviderTest.assertEquals((Object)any, (Object)provider.validate(testObserve, testProperty, otherBeanObserve, otherBeanValueProperty_Any));
        DatabindingsProviderTest.assertEquals((Object)any, (Object)provider.validate(otherBeanObserve, otherBeanValueProperty_Any, testObserve, testProperty));
        DatabindingsProviderTest.assertEquals((Object)detail, (Object)provider.validate(testObserve, testProperty, directObserve, directProperty_Detail));
        DatabindingsProviderTest.assertEquals((Object)detail, (Object)provider.validate(directObserve, directProperty_Detail, testObserve, testProperty));
    }

    @Test
    public void test_createBinding_OnlyList_OnlyList() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerMultiSelectionProperty_OnlyList = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo comboObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(3);
        IObserveInfo comboItemsProperty_OnlyList = (IObserveInfo)comboObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(6);
        this.assertCreateBinding(viewerObserve, viewerMultiSelectionProperty_OnlyList, comboObserve, comboItemsProperty_OnlyList, ListBindingInfo.class, MultiSelectionObservableInfo.class, ItemsSwtObservableInfo.class, UpdateListStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlyList_List() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerMultiSelectionProperty_OnlyList = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValuesProperty_List = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.assertCreateBinding(viewerObserve, viewerMultiSelectionProperty_OnlyList, beanObserve, beanValuesProperty_List, ListBindingInfo.class, MultiSelectionObservableInfo.class, ListBeanObservableInfo.class, UpdateListStrategyInfo.class);
    }

    @Test
    public void test_createBinding_List_List() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValuesProperty_List = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo bean1Observe = (IObserveInfo)beansObservables.get(11);
        IObserveInfo bean1ValuesProperty_List = (IObserveInfo)bean1Observe.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.assertCreateBinding(bean1Observe, bean1ValuesProperty_List, beanObserve, beanValuesProperty_List, ListBindingInfo.class, ListBeanObservableInfo.class, ListBeanObservableInfo.class, UpdateListStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlyList_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerMultiSelectionProperty_OnlyList = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(viewerObserve, viewerMultiSelectionProperty_OnlyList, directObserve, directProperty_Detail, ListBindingInfo.class, MultiSelectionObservableInfo.class, DetailListBeanObservableInfo.class, UpdateListStrategyInfo.class);
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerPartSelectionProperty_Detail = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(viewerObserve, viewerMultiSelectionProperty_OnlyList, otherViewerObserve, otherViewerPartSelectionProperty_Detail, ListBindingInfo.class, MultiSelectionObservableInfo.class, DetailListBeanObservableInfo.class, UpdateListStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlySet_OnlySet() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerCheckedProperty_OnlySet = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerCheckedProperty_OnlySet = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.assertCreateBinding(viewerObserve, viewerCheckedProperty_OnlySet, otherViewerObserve, otherViewerCheckedProperty_OnlySet, SetBindingInfo.class, CheckedElementsObservableInfo.class, CheckedElementsObservableInfo.class, UpdateSetStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlySet_Set() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerCheckedProperty_OnlySet = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanNamesProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(viewerObserve, viewerCheckedProperty_OnlySet, beanObserve, beanNamesProperty, SetBindingInfo.class, CheckedElementsObservableInfo.class, SetBeanObservableInfo.class, UpdateSetStrategyInfo.class);
    }

    @Test
    public void test_createBinding_Set_Set() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo bean1Observe = (IObserveInfo)beansObservables.get(11);
        IObserveInfo bean1NamesProperty = (IObserveInfo)bean1Observe.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanNamesProperty = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(bean1Observe, bean1NamesProperty, beanObserve, beanNamesProperty, SetBindingInfo.class, SetBeanObservableInfo.class, SetBeanObservableInfo.class, UpdateSetStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlySet_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerCheckedProperty_OnlySet = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(viewerObserve, viewerCheckedProperty_OnlySet, directObserve, directProperty_Detail, SetBindingInfo.class, CheckedElementsObservableInfo.class, DetailSetBeanObservableInfo.class, UpdateSetStrategyInfo.class);
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerPartSelectionProperty_Detail = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(viewerObserve, viewerCheckedProperty_OnlySet, otherViewerObserve, otherViewerPartSelectionProperty_Detail, SetBindingInfo.class, CheckedElementsObservableInfo.class, DetailSetBeanObservableInfo.class, UpdateSetStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlyValue_OnlyValue() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo shellFontProperty = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(4);
        IObserveInfo textObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(2);
        IObserveInfo textTextProperty = (IObserveInfo)textObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(10);
        this.assertCreateBinding(textObserve, textTextProperty, shellObserve, shellFontProperty, ValueBindingInfo.class, TextSwtObservableInfo.class, SwtObservableInfo.class, UpdateValueStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlyValue_Any() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValueProperty_Any = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerSelectionProperty = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        this.assertCreateBinding(viewerObserve, viewerSelectionProperty, beanObserve, beanValueProperty_Any, ValueBindingInfo.class, SingleSelectionObservableInfo.class, ValueBeanObservableInfo.class, UpdateValueStrategyInfo.class);
    }

    @Test
    public void test_createBinding_Any_Any() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo bean1Observe = (IObserveInfo)beansObservables.get(11);
        IObserveInfo bean1ValueProperty_Any = (IObserveInfo)bean1Observe.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValueProperty_Any = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        this.assertCreateBinding(bean1Observe, bean1ValueProperty_Any, beanObserve, beanValueProperty_Any, ValueBindingInfo.class, ValueBeanObservableInfo.class, ValueBeanObservableInfo.class, UpdateValueStrategyInfo.class);
    }

    @Test
    public void test_createBinding_OnlyValue_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo shellTextProperty = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(8);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerSelectionDetailProperty_Detail = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(shellObserve, shellTextProperty, viewerObserve, viewerSelectionDetailProperty_Detail, ValueBindingInfo.class, SwtObservableInfo.class, DetailValueBeanObservableInfo.class, UpdateValueStrategyInfo.class);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(shellObserve, shellTextProperty, directObserve, directProperty_Detail, ValueBindingInfo.class, SwtObservableInfo.class, DetailValueBeanObservableInfo.class, UpdateValueStrategyInfo.class);
    }

    @Test
    public void test_createBinding_List_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValuesProperty_List = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directDetailProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(beanObserve, beanValuesProperty_List, directObserve, directDetailProperty_Detail, ListBindingInfo.class, ListBeanObservableInfo.class, DetailListBeanObservableInfo.class, UpdateListStrategyInfo.class);
    }

    @Test
    public void test_createBinding_Set_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanNamesProperty_Set = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directDetailProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateBinding(beanObserve, beanNamesProperty_Set, directObserve, directDetailProperty_Detail, SetBindingInfo.class, SetBeanObservableInfo.class, DetailSetBeanObservableInfo.class, UpdateSetStrategyInfo.class);
    }

    private void assertCreateBinding(IObserveInfo target, IObserveInfo targetProperty, IObserveInfo model, IObserveInfo modelProperty, Class<?> bindingClass, Class<?> targetObservable, Class<?> modelObservable, Class<?> strategy) throws Exception {
        DatabindingsProvider provider = this.getDatabindingsProvider();
        IBindingInfo binding0 = provider.createBinding(target, targetProperty, model, modelProperty);
        DatabindingsProviderTest.assertNotNull((Object)binding0);
        DatabindingsProviderTest.assertInstanceOf(bindingClass, (Object)binding0);
        DatabindingsProviderTest.assertBinding(binding0, target, targetProperty, model, modelProperty);
        DatabindingsProviderTest.assertBinding((BindingInfo)binding0, targetObservable, strategy, modelObservable, strategy);
        IBindingInfo binding1 = provider.createBinding(model, modelProperty, target, targetProperty);
        DatabindingsProviderTest.assertNotNull((Object)binding1);
        DatabindingsProviderTest.assertInstanceOf(bindingClass, (Object)binding1);
        DatabindingsProviderTest.assertBinding(binding1, model, modelProperty, target, targetProperty);
        DatabindingsProviderTest.assertBinding((BindingInfo)binding1, modelObservable, strategy, targetObservable, strategy);
    }

    private static void assertBinding(IBindingInfo binding, IObserveInfo target, IObserveInfo targetProperty, IObserveInfo model, IObserveInfo modelProperty) throws Exception {
        DatabindingsProviderTest.assertSame((Object)binding.getTarget(), (Object)target);
        DatabindingsProviderTest.assertSame((Object)binding.getTargetProperty(), (Object)targetProperty);
        DatabindingsProviderTest.assertSame((Object)binding.getModel(), (Object)model);
        DatabindingsProviderTest.assertSame((Object)binding.getModelProperty(), (Object)modelProperty);
    }

    private static void assertBinding(BindingInfo binding, Class<?> targetObservable, Class<?> targetStrategy, Class<?> modelObservable, Class<?> modelStrategy) {
        DatabindingsProviderTest.assertInstanceOf(targetObservable, (Object)binding.getTargetObservable());
        DatabindingsProviderTest.assertInstanceOf(targetStrategy, (Object)binding.getTargetStrategy());
        DatabindingsProviderTest.assertInstanceOf(modelObservable, (Object)binding.getModelObservable());
        DatabindingsProviderTest.assertInstanceOf(modelStrategy, (Object)binding.getModelStrategy());
    }

    private void assertCreateViewerBinding(IObserveInfo viewerObserve, IObserveInfo viewerInputProperty, IObserveInfo inputObserve, IObserveInfo inputObserveProperty, Class<?> inputObserveClass) throws Exception {
        DatabindingsProvider provider = this.getDatabindingsProvider();
        IBindingInfo ibinding0 = provider.createBinding(viewerObserve, viewerInputProperty, inputObserve, inputObserveProperty);
        DatabindingsProviderTest.assertInstanceOf(ViewerInputBindingInfo.class, (Object)ibinding0);
        DatabindingsProviderTest.assertBinding(ibinding0, viewerObserve, viewerInputProperty, inputObserve, inputObserveProperty);
        ViewerInputBindingInfo binding0 = (ViewerInputBindingInfo)ibinding0;
        DatabindingsProviderTest.assertNull((Object)binding0.getElementType());
        DatabindingsProviderTest.assertSame((Object)viewerObserve, (Object)binding0.getViewer());
        DatabindingsProviderTest.assertInstanceOf(inputObserveClass, (Object)binding0.getInputObservable());
        DatabindingsProviderTest.assertNotNull((Object)binding0.getLabelProvider());
        IBindingInfo ibinding1 = provider.createBinding(inputObserve, inputObserveProperty, viewerObserve, viewerInputProperty);
        DatabindingsProviderTest.assertInstanceOf(ViewerInputBindingInfo.class, (Object)ibinding1);
        DatabindingsProviderTest.assertBinding(ibinding1, viewerObserve, viewerInputProperty, inputObserve, inputObserveProperty);
        ViewerInputBindingInfo binding1 = (ViewerInputBindingInfo)ibinding1;
        DatabindingsProviderTest.assertNull((Object)binding1.getElementType());
        DatabindingsProviderTest.assertSame((Object)viewerObserve, (Object)binding1.getViewer());
        DatabindingsProviderTest.assertInstanceOf(inputObserveClass, (Object)binding1.getInputObservable());
        DatabindingsProviderTest.assertNotNull((Object)binding1.getLabelProvider());
    }

    @Test
    public void test_createBinding_Viewer_InputCollection() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo listObserve = (IObserveInfo)beansObservables.get(6);
        IObserveInfo listProperty_InputCollection = (IObserveInfo)listObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, listObserve, listProperty_InputCollection, WritableListBeanObservableInfo.class);
        IObserveInfo setObserve = (IObserveInfo)beansObservables.get(9);
        IObserveInfo setProperty_InputCollection = (IObserveInfo)setObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, setObserve, setProperty_InputCollection, WritableSetBeanObservableInfo.class);
    }

    @Test
    public void test_createBinding_Viewer_OnlyList() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerMultiSelectionProperty_OnlyList = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, otherViewerObserve, otherViewerMultiSelectionProperty_OnlyList, MultiSelectionObservableInfo.class);
    }

    @Test
    public void test_createBinding_Viewer_OnlySet() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        IObserveInfo otherTableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(1);
        IObserveInfo otherViewerObserve = (IObserveInfo)otherTableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo otherViewerCheckedProperty_OnlySet = (IObserveInfo)otherViewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, otherViewerObserve, otherViewerCheckedProperty_OnlySet, CheckedElementsObservableInfo.class);
    }

    @Test
    public void test_createBinding_Viewer_List() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanValuesProperty_List = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, beanObserve, beanValuesProperty_List, ListBeanObservableInfo.class);
    }

    @Test
    public void test_createBinding_Viewer_Set() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanNamesProperty_Set = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, beanObserve, beanNamesProperty_Set, SetBeanObservableInfo.class);
    }

    @Test
    public void test_createBinding_Viewer_Detail() throws Exception {
        this.createValidate();
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo tableObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)tableObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(5);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo directObserve = (IObserveInfo)beansObservables.get(2);
        IObserveInfo directDetailProperty_Detail = (IObserveInfo)directObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        this.assertCreateViewerBinding(viewerObserve, viewerInputProperty_Input, directObserve, directDetailProperty_Detail, DetailListBeanObservableInfo.class);
    }

    @Test
    public void test_createBinding_TreeViewer() throws Exception {
        this.createValidate("TreeViewer");
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List widgetsObservables = provider.getContainer(ObserveType.WIDGETS).getObservables();
        IObserveInfo shellObserve = (IObserveInfo)widgetsObservables.get(0);
        IObserveInfo treeObserve = (IObserveInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerObserve = (IObserveInfo)treeObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        IObserveInfo viewerInputProperty_Input = (IObserveInfo)viewerObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(4);
        List beansObservables = provider.getContainer(ObserveType.BEANS).getObservables();
        IObserveInfo beanObserve = (IObserveInfo)beansObservables.get(1);
        IObserveInfo beanNamesProperty_Set = (IObserveInfo)beanObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        IBindingInfo ibinding0 = provider.createBinding(viewerObserve, viewerInputProperty_Input, beanObserve, beanNamesProperty_Set);
        DatabindingsProviderTest.assertInstanceOf(TreeViewerInputBindingInfo.class, (Object)ibinding0);
        DatabindingsProviderTest.assertBinding(ibinding0, viewerObserve, viewerInputProperty_Input, beanObserve, beanNamesProperty_Set);
        TreeViewerInputBindingInfo binding0 = (TreeViewerInputBindingInfo)ibinding0;
        DatabindingsProviderTest.assertNull((Object)binding0.getElementType());
        DatabindingsProviderTest.assertSame((Object)viewerObserve, (Object)binding0.getViewer());
        DatabindingsProviderTest.assertInstanceOf(SetBeanObservableInfo.class, (Object)binding0.getInputObservable());
        DatabindingsProviderTest.assertNotNull((Object)binding0.getContentProvider());
        DatabindingsProviderTest.assertNotNull((Object)binding0.getLabelProvider());
        IBindingInfo ibinding1 = provider.createBinding(beanObserve, beanNamesProperty_Set, viewerObserve, viewerInputProperty_Input);
        DatabindingsProviderTest.assertInstanceOf(TreeViewerInputBindingInfo.class, (Object)ibinding1);
        DatabindingsProviderTest.assertBinding(ibinding1, viewerObserve, viewerInputProperty_Input, beanObserve, beanNamesProperty_Set);
        TreeViewerInputBindingInfo binding1 = (TreeViewerInputBindingInfo)ibinding1;
        DatabindingsProviderTest.assertNull((Object)binding1.getElementType());
        DatabindingsProviderTest.assertSame((Object)viewerObserve, (Object)binding1.getViewer());
        DatabindingsProviderTest.assertInstanceOf(SetBeanObservableInfo.class, (Object)binding1.getInputObservable());
        DatabindingsProviderTest.assertNotNull((Object)binding1.getContentProvider());
        DatabindingsProviderTest.assertNotNull((Object)binding1.getLabelProvider());
    }

    @Test
    public void test_property() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super (parent, style);", "  }", "}");
        composite.refresh();
        BindingsProperty property = (BindingsProperty)composite.getPropertyByTitle("bindings");
        DatabindingsProviderTest.assertNotNull((Object)property);
    }

    @Test
    public void test_property_disabled() throws Exception {
        DatabindingsProviderTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super (parent, style);", "  }", "}"));
        DatabindingsProviderTest.setFileContentSrc("test/MyComposite.wbp-component.xml", DatabindingsProviderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='databinding.disable'>true</parameter>", "  </parameters>", "</component>"));
        DatabindingsProviderTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super (parent, style);", "  }", "}");
        composite.refresh();
        DatabindingsProviderTest.assertNull((Object)composite.getPropertyByTitle("bindings"));
    }
}

