/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.LabelInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class LabelTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setText() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Label label = new Label(this, SWT.NONE);", "    label.setText('New label');", "  }", "}");
        shell.refresh();
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        Property textProperty = label.getPropertyByTitle("text");
        textProperty.setValue((Object)"New text");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Label label = new Label(this, SWT.NONE);", "    label.setText('New text');", "  }", "}");
    }

    @Test
    public void test_ButtonStylePresentation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);", "    new Label(this, SWT.SEPARATOR | SWT.VERTICAL);", "    new Label(this, SWT.SEPARATOR);", "  }", "}");
        shell.refresh();
        LabelInfo labelDefault = (LabelInfo)shell.getChildrenControls().get(0);
        LabelInfo labelSeparatorHorizontal = (LabelInfo)shell.getChildrenControls().get(1);
        LabelInfo labelSeparatorVertical = (LabelInfo)shell.getChildrenControls().get(2);
        LabelInfo labelSeparatorVerticalDef = (LabelInfo)shell.getChildrenControls().get(3);
        LabelTest.assertNotSame((Object)labelDefault.getPresentation().getIcon(), (Object)labelSeparatorHorizontal.getPresentation().getIcon());
        LabelTest.assertNotSame((Object)labelSeparatorHorizontal.getPresentation().getIcon(), (Object)labelSeparatorVertical.getPresentation().getIcon());
        LabelTest.assertSame((Object)labelSeparatorVertical.getPresentation().getIcon(), (Object)labelSeparatorVerticalDef.getPresentation().getIcon());
    }
}

