/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.internal.rcp.model.widgets.SashFormInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class SashFormTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parseWith_setLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    sashForm.setLayout(new FillLayout());", "  }", "}");
        SashFormTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setSize(500, 300)/ /setLayout(new FillLayout())/ /new SashForm(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.custom.SashForm} {local-unique: sashForm} {/new SashForm(this, SWT.NONE)/ /sashForm.setLayout(new FillLayout())/}");
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        SashFormTest.assertFalse((boolean)sashForm.hasLayout());
    }

    @Test
    public void test_parseWithout_setLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "  }", "}");
        SashFormTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setSize(500, 300)/ /setLayout(new FillLayout())/ /new SashForm(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.custom.SashForm} {local-unique: sashForm} {/new SashForm(this, SWT.NONE)/}");
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        SashFormTest.assertFalse((boolean)sashForm.hasLayout());
    }

    @Test
    public void test_isHorizontal_true() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        SashFormTest.assertTrue((boolean)sashForm.isHorizontal());
    }

    @Test
    public void test_isHorizontal_false() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.VERTICAL);", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        SashFormTest.assertFalse((boolean)sashForm.isHorizontal());
    }

    @Test
    public void test_CREATE_0() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        sashForm.command_CREATE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {1});", "  }", "}");
    }

    @Test
    public void test_CREATE_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {2, 4});", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        sashForm.command_CREATE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {2, 4, 3});", "  }", "}");
    }

    @Test
    public void test_MOVE_inner() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {2, 4});", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button_1 = (ControlInfo)sashForm.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)sashForm.getChildrenControls().get(1);
        sashForm.command_MOVE(button_2, button_1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {4, 2});", "  }", "}");
    }

    @Test
    public void test_MOVE_in() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        sashForm.command_MOVE(button_2, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {1, 1});", "  }", "}");
    }

    @Test
    public void test_MOVE_out() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {2, 3});", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)sashForm.getChildrenControls().get(1);
        fillLayout.command_MOVE(button_2, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {2});", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {1, 2});", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)sashForm.getChildrenControls().get(1);
        button_2.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {1});", "  }", "}");
    }

    @Ignore
    @Test
    public void test_RESIZE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        SashFormInfo sashForm = (SashFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button_1 = (ControlInfo)sashForm.getChildrenControls().get(0);
        sashForm.command_RESIZE(button_1, 150);
        int expectedRightWeight = Expectations.get(Integer.valueOf(331), new Expectations.IntValue("flanker-win", 339), new Expectations.IntValue("kosta-home", 339), new Expectations.IntValue("scheglov-win", 331));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(500, 300);", "    setLayout(new FillLayout());", "    SashForm sashForm = new SashForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(sashForm, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(sashForm, SWT.NONE);", "    }", "    sashForm.setWeights(new int[] {150, " + expectedRightWeight + "});", "  }", "}");
    }
}

