/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component.menu;

import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuBarInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Test;

public class JMenuGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_drop_JMenuBar_onJFrame() throws Exception {
        ContainerInfo frame = this.openContainer("// filler filler filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        JMenuBarInfo menuBar = (JMenuBarInfo)this.loadCreationTool("javax.swing.JMenuBar");
        this.canvas.moveTo((Object)frame, 100, 5).click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\t{\n\t\t\tJMenuBar menuBar = new JMenuBar();\n\t\t\tsetJMenuBar(menuBar);\n\t\t}\n\t}\n}");
        this.canvas.assertPrimarySelected(menuBar);
    }

    @Test
    public void test_drop_JMenuBar_onJInternalFrame() throws Exception {
        ContainerInfo frame = this.openContainer("// filler filler filler filler filler\npublic class Test extends JInternalFrame {\n\tpublic Test() {\n\t}\n}");
        JMenuBarInfo menuBar = (JMenuBarInfo)this.loadCreationTool("javax.swing.JMenuBar");
        this.canvas.moveTo((Object)frame, 100, 5).click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JInternalFrame {\n\tpublic Test() {\n\t\t{\n\t\t\tJMenuBar menuBar = new JMenuBar();\n\t\t\tsetJMenuBar(menuBar);\n\t\t}\n\t}\n}");
        this.canvas.assertPrimarySelected(menuBar);
    }

    @Test
    public void test_dontMoveMove_onItsItem() throws Exception {
        this.openContainer("// filler filler filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tJMenuBar menuBar = new JMenuBar();\n\t\tsetJMenuBar(menuBar);\n\t\t{\n\t\t\tJMenu menu = new JMenu(\"Test\");\n\t\t\tmenuBar.add(menu);\n\t\t}\n\t}\n}");
        Object menu = JMenuGefTest.getJavaInfoByName("menu");
        this.canvas.moveTo(menu, 0.5, -1.0).beginDrag().dragOn(0, 20);
        this.canvas.assertCommandNull();
    }
}

