/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component.menu;

import java.util.List;
import javax.swing.JPopupMenu;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.VoidInvocationVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuItemInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JPopupMenuAssociation;
import org.eclipse.wb.internal.swing.model.component.menu.JPopupMenuInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JPopupMenuSeparatorCreationSupport;
import org.eclipse.wb.internal.swing.model.component.menu.JPopupMenuSeparatorInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class JPopupMenuTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "    {", "      JMenuItem item_1 = new JMenuItem('Item 1');", "      popup.add(item_1);", "    }", "    {", "      JMenuItem item_2 = new JMenuItem('Item 2');", "      popup.add(item_2);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)panelInfo.getChildren(JPopupMenuInfo.class).get(0);
        JPopupMenuAssociation association = (JPopupMenuAssociation)popupInfo.getAssociation();
        JPopupMenuTest.assertEquals((Object)"addPopup(this, popup)", (Object)association.getSource());
        JPopupMenuTest.assertEquals((long)2L, (long)popupInfo.getChildrenItems().size());
        JMenuItemInfo item_0 = (JMenuItemInfo)popupInfo.getChildrenItems().get(0);
        JMenuItemInfo item_1 = (JMenuItemInfo)popupInfo.getChildrenItems().get(1);
        JPopupMenuTest.assertNull((Object)popupInfo.getAdapter(List.class));
        IMenuPopupInfo popupObject = MenuObjectInfoUtils.getMenuPopupInfo((Object)popupInfo);
        JPopupMenuTest.assertSame((Object)popupInfo, (Object)popupObject.getModel());
        JPopupMenuTest.assertSame((Object)popupInfo.getDescription().getIcon(), (Object)popupObject.getImageDescriptor());
        JPopupMenuTest.assertEquals((Object)new Rectangle(0, 0, 16, 16), (Object)popupObject.getBounds());
        JPopupMenuTest.assertSame((Object)IMenuPolicy.NOOP, (Object)popupObject.getPolicy());
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuPopupInfo((Object)popupInfo).getMenu();
        JPopupMenuTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        JPopupMenuTest.assertNotNull((Object)menuObject.getImageDescriptor());
        Assertions.assertThat((int)menuObject.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)menuObject.getBounds().height).isGreaterThanOrEqualTo(40);
        JPopupMenuTest.assertFalse((boolean)menuObject.isHorizontal());
        List items = menuObject.getItems();
        JPopupMenuTest.assertEquals((long)2L, (long)items.size());
        JPopupMenuTest.assertSame((Object)item_0, (Object)((IMenuItemInfo)items.get(0)).getModel());
        JPopupMenuTest.assertSame((Object)item_1, (Object)((IMenuItemInfo)items.get(1)).getModel());
        JPopupMenuTest.assertNotSame((Object)IMenuPolicy.NOOP, (Object)menuObject.getPolicy());
    }

    @Test
    public void test_noItems() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)panelInfo.getChildren(JPopupMenuInfo.class).get(0);
        JPopupMenuTest.assertEquals((long)0L, (long)popupInfo.getChildrenItems().size());
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuPopupInfo((Object)popupInfo).getMenu();
        JPopupMenuTest.assertTrue((menuObject.getBounds().width > 50 ? 1 : 0) != 0);
        JPopupMenuTest.assertTrue((menuObject.getBounds().height > 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_IMenuInfo_withSeparator() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "    {", "      JMenuItem item_1 = new JMenuItem('Item 1');", "      popup.add(item_1);", "    }", "    {", "      JSeparator separator = new JSeparator();", "      popup.add(separator);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)panelInfo.getChildren(JPopupMenuInfo.class).get(0);
        JMenuItemInfo itemInfo_1 = (JMenuItemInfo)popupInfo.getChildrenComponents().get(0);
        ComponentInfo separatorInfo = (ComponentInfo)popupInfo.getChildrenComponents().get(1);
        IMenuPopupInfo popupObject = MenuObjectInfoUtils.getMenuPopupInfo((Object)popupInfo);
        IMenuInfo menuObject = popupObject.getMenu();
        JPopupMenuTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        JPopupMenuTest.assertNotNull((Object)menuObject.getImageDescriptor());
        Rectangle bounds = menuObject.getBounds();
        Assertions.assertThat((bounds.width > 50 ? 1 : 0) != 0);
        Assertions.assertThat((bounds.height > 30 ? 1 : 0) != 0);
        JPopupMenuTest.assertFalse((boolean)menuObject.isHorizontal());
        List items = menuObject.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        IMenuItemInfo itemObject = (IMenuItemInfo)items.get(0);
        JPopupMenuTest.assertSame((Object)itemInfo_1, (Object)itemObject.getModel());
        Rectangle bounds2 = itemObject.getBounds();
        Assertions.assertThat((int)bounds2.x).isLessThan(5);
        Assertions.assertThat((int)bounds2.y).isLessThan(5);
        Assertions.assertThat((int)bounds2.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds2.height).isGreaterThan(18);
        itemObject = (IMenuItemInfo)items.get(1);
        JPopupMenuTest.assertSame((Object)separatorInfo, (Object)itemObject.getModel());
        bounds2 = itemObject.getBounds();
        Assertions.assertThat((int)bounds2.x).isGreaterThanOrEqualTo(0).isLessThan(5);
        Assertions.assertThat((int)bounds2.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds2.height).isGreaterThan(0).isLessThanOrEqualTo((Comparable)Expectations.get(Integer.valueOf(5), new Expectations.IntValue("mitin-aa", 12)));
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panelInfo.refresh();
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)JPopupMenuTest.createComponent(JPopupMenu.class);
        popupInfo.command_CREATE((ComponentInfo)panelInfo);
        JPopupMenuAssociation association = (JPopupMenuAssociation)popupInfo.getAssociation();
        JPopupMenuTest.assertEquals((Object)"addPopup(this, popupMenu)", (Object)association.getSource());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JPopupMenu popupMenu = new JPopupMenu();", "      addPopup(this, popupMenu);", "    }", "  }", "  private static void addPopup(Component component, final JPopupMenu popup) {", "    component.addMouseListener(new MouseAdapter() {", "      public void mousePressed(MouseEvent e) {", "        if (e.isPopupTrigger()) {", "          showMenu(e);", "        }", "      }", "      public void mouseReleased(MouseEvent e) {", "        if (e.isPopupTrigger()) {", "          showMenu(e);", "        }", "      }", "      private void showMenu(MouseEvent e) {", "        popup.show(e.getComponent(), e.getX(), e.getY());", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      JPopupMenu popup = new JPopupMenu();", "      addPopup(button_1, popup);", "      popup.add(new JMenuItem());", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        ComponentInfo buttonInfo_1 = (ComponentInfo)panelInfo.getChildrenComponents().get(0);
        ComponentInfo buttonInfo_2 = (ComponentInfo)panelInfo.getChildrenComponents().get(1);
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)buttonInfo_1.getChildren(JPopupMenuInfo.class).get(0);
        popupInfo.command_MOVE(buttonInfo_2);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      JPopupMenu popup = new JPopupMenu();", "      addPopup(button_2, popup);", "      popup.add(new JMenuItem());", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
    }

    @Test
    public void test_MOVE_toTheContainer() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popupMenu = new JPopupMenu();", "    addPopup(this, popupMenu);", "    JPanel innerPanel = new JPanel();", "    add(innerPanel);", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)JPopupMenuTest.getJavaInfoByName("popupMenu");
        ComponentInfo innerPanel = (ComponentInfo)JPopupMenuTest.getJavaInfoByName("innerPanel");
        popupInfo.command_MOVE(innerPanel);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JPanel innerPanel = new JPanel();", "    add(innerPanel);", "    JPopupMenu popupMenu = new JPopupMenu();", "    addPopup(innerPanel, popupMenu);", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
    }

    @Ignore
    @Test
    public void test_PASTE() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      {", "        JPopupMenu popup = new JPopupMenu();", "        addPopup(button_1, popup);", "        popup.add(new JMenuItem('Some item'));", "      }", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        ComponentInfo buttonInfo_1 = (ComponentInfo)panelInfo.getChildrenComponents().get(0);
        ComponentInfo buttonInfo_2 = (ComponentInfo)panelInfo.getChildrenComponents().get(1);
        JPopupMenuInfo popupInfo = (JPopupMenuInfo)buttonInfo_1.getChildren(JPopupMenuInfo.class).get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)popupInfo);
        JPopupMenuInfo popupCopyInfo = (JPopupMenuInfo)memento.create((JavaInfo)panelInfo);
        popupCopyInfo.command_CREATE(buttonInfo_2);
        memento.apply();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      {", "        JPopupMenu popup = new JPopupMenu();", "        addPopup(button_1, popup);", "        popup.add(new JMenuItem('Some item'));", "      }", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "      {", "        JPopupMenu popupMenu = new JPopupMenu();", "        addPopup(button_2, popupMenu);", "        {", "          JMenuItem menuItem = new JMenuItem('Some item');", "          popupMenu.add(menuItem);", "        }", "      }", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
    }

    @Test
    public void test_hasTrackingListener() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        panelInfo.refresh();
        Object[] mouseListeners = panelInfo.getComponent().getMouseListeners();
        Assertions.assertThat((Object[])mouseListeners).isNotEmpty();
    }

    @Test
    public void test_separator_addSeparator() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "    {", "      popup.addSeparator();", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        JPopupMenuTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/addPopup(this, popup)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JPopupMenu} {local-unique: popup} {/new JPopupMenu()/ /addPopup(this, popup)/ /popup.addSeparator()/}", "    {void} {void} {/popup.addSeparator()/}");
        JPopupMenuInfo popup = (JPopupMenuInfo)JPopupMenuTest.getJavaInfoByName("popup");
        JPopupMenuSeparatorInfo separator = (JPopupMenuSeparatorInfo)popup.getChildren(JPopupMenuSeparatorInfo.class).get(0);
        VariableSupport variable = separator.getVariableSupport();
        JPopupMenuTest.assertInstanceOf(VoidInvocationVariableSupport.class, (Object)variable);
        JPopupMenuSeparatorCreationSupport creation = (JPopupMenuSeparatorCreationSupport)separator.getCreationSupport();
        JPopupMenuTest.assertEquals((Object)"void", (Object)creation.toString());
        JPopupMenuTest.assertSame((Object)((InvocationVoidAssociation)separator.getAssociation()).getInvocation(), (Object)creation.getNode());
        JPopupMenuTest.assertTrue((boolean)creation.canReorder());
        JPopupMenuTest.assertFalse((boolean)creation.canReparent());
        JPopupMenuTest.assertTrue((boolean)creation.canDelete());
        JPopupMenuTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)separator.getAssociation());
    }

    @Test
    public void test_separator_newSeparator() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "    {", "      JPopupMenu.Separator separator = new JPopupMenu.Separator();", "      popup.add(separator);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        JPopupMenuTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/addPopup(this, popup)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JPopupMenu} {local-unique: popup} {/new JPopupMenu()/ /addPopup(this, popup)/ /popup.add(separator)/}", "    {new: javax.swing.JPopupMenu$Separator} {local-unique: separator} {/new JPopupMenu.Separator()/ /popup.add(separator)/}");
    }

    @Test
    public void test_separator_create_addSeparator() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        JPopupMenuInfo popup = (JPopupMenuInfo)JPopupMenuTest.getJavaInfoByName("popup");
        JPopupMenuSeparatorCreationSupport creationSupport = new JPopupMenuSeparatorCreationSupport((JavaInfo)popup);
        JPopupMenuSeparatorInfo separator = (JPopupMenuSeparatorInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JPopupMenu.Separator.class, (CreationSupport)creationSupport);
        MenuObjectInfoUtils.getMenuPopupInfo((Object)popup).getMenu().getPolicy().commandCreate((Object)separator, null);
        JPopupMenuTest.assertNotNull((Object)creationSupport.getInvocation());
        JPopupMenuTest.assertInstanceOf(VoidInvocationVariableSupport.class, (Object)separator.getVariableSupport());
        Association association = separator.getAssociation();
        JPopupMenuTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)association);
        JPopupMenuTest.assertEquals((Object)"popup.addSeparator()", (Object)association.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JPopupMenu popup = new JPopupMenu();", "    addPopup(this, popup);", "    popup.addSeparator();", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
    }
}

