/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.FlowLayout;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Ignore;
import org.junit.Test;

public class FlowLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutTest.setLayout(panel, FlowLayout.class);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));", "  }", "}");
    }

    @Test
    public void test_setLayout2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        FlowLayoutTest.setLayout(panel, FlowLayout.class);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_add_last() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "  }", "}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FlowLayoutTest.createJButton();
        layout.add(newComponent, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_add_before() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    {", "      JButton button = new JButton('111');", "      add(button);", "    }", "  }", "}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = FlowLayoutTest.createJButton();
        layout.add(newComponent, existingButton);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_move_before() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}"};
        String[] expectedLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}"};
        this.check_move_before(lines, expectedLines);
    }

    @Test
    public void test_moveComplex() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JPanel complexPanel = new JPanel();", "      add(complexPanel);", "      {", "        JButton button2 = new JButton();", "        complexPanel.add(button2);", "      }", "    }", "  }", "}"};
        String[] expectedLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel complexPanel = new JPanel();", "      add(complexPanel);", "      {", "        JButton button2 = new JButton();", "        complexPanel.add(button2);", "      }", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}"};
        this.check_move_before(lines, expectedLines);
    }

    @Test
    public void test_move_before_lazy() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getButton_1());", "    add(getButton_2());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton(\"Button 1\");", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton(\"button 2\");", "    }", "    return button_2;", "  }", "}"};
        String[] expectedLines = new String[]{"public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getButton_2());", "    add(getButton_1());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton(\"Button 1\");", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton(\"button 2\");", "    }", "    return button_2;", "  }", "}"};
        this.check_move_before(lines, expectedLines);
    }

    private void check_move_before(String[] lines, String[] expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.move(button_2, button_1);
        this.assertEditor(expectedLines);
    }

    @Test
    public void test_move_last() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.move(button_1, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
    }

    @Test
    public void test_reparentingVariable() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      panel.setLayout(new BorderLayout());", "      panel.setPreferredSize(new Dimension(150, 150));", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.add(button, BorderLayout.NORTH);", "      }", "    }", "  }", "}"};
        String[] expectedLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      panel.setLayout(new BorderLayout());", "      panel.setPreferredSize(new Dimension(150, 150));", "      add(panel);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}"};
        this.check_reparenting(lines, expectedLines);
    }

    private void check_reparenting(String[] lines, String[] expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        layout.move(button, null);
        this.assertEditor(expectedLines);
    }

    @Ignore
    @Test
    public void test_clipboard() throws Exception {
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      {", "        JButton button = new JButton('A');", "        inner.add(button);", "      }", "      {", "        JButton button = new JButton('B');", "        inner.add(button);", "      }", "    }", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines1);
        panel.refresh();
        ComponentInfo inner = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ContainerInfo copy = (ContainerInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)copy, null);
        memento.apply();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      {", "        JButton button = new JButton('A');", "        inner.add(button);", "      }", "      {", "        JButton button = new JButton('B');", "        inner.add(button);", "      }", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      {", "        JButton button = new JButton('A');", "        panel.add(button);", "      }", "      {", "        JButton button = new JButton('B');", "        panel.add(button);", "      }", "    }", "  }", "}"};
        this.assertEditor(lines);
    }
}

