/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.jface;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.WrapperByMethod;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.WrappedObjectAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.InnerClassPropertyEditor;
import org.eclipse.wb.internal.core.model.util.ExposeComponentSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.WrapperMethodControlVariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.NoEntryPointError;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ViewerTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_normalNoControl_hasExpression() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        VariableSupport variableSupport = table.getVariableSupport();
        NodeTarget nodeTarget = ViewerTest.getNodeStatementTarget((JavaInfo)shell, false, 1);
        String expectedSource = this.m_lastEditor.getSource();
        ViewerTest.assertTrue((boolean)variableSupport.hasExpression(nodeTarget));
        ViewerTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_normalNoControl_getReferenceExpression_viewerAsTarget() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        VariableSupport variableSupport = table.getVariableSupport();
        NodeTarget nodeTarget = ViewerTest.getNodeStatementTarget((JavaInfo)shell, false, 1);
        ViewerTest.assertEquals((Object)"table", (Object)variableSupport.getReferenceExpression(nodeTarget));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    Table table = tableViewer.getTable();", "  }", "}");
    }

    @Test
    public void test_normalNoControl_getReferenceExpression_blockAsTarget() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        VariableSupport variableSupport = table.getVariableSupport();
        NodeTarget nodeTarget = ViewerTest.getNodeBlockTarget((JavaInfo)shell, false, new int[0]);
        ViewerTest.assertEquals((Object)"table", (Object)variableSupport.getReferenceExpression(nodeTarget));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    Table table = tableViewer.getTable();", "  }", "}");
    }

    @Test
    public void test_normalNoControl_getAccessExpression_blockAsTarget() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        VariableSupport variableSupport = table.getVariableSupport();
        NodeTarget nodeTarget = ViewerTest.getNodeBlockTarget((JavaInfo)shell, false, new int[0]);
        ViewerTest.assertEquals((Object)"table.", (Object)variableSupport.getAccessExpression(nodeTarget));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    Table table = tableViewer.getTable();", "  }", "}");
    }

    @Test
    public void test_parseAnonymous_standalone() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER) {", "    };", "  }", "}");
        this.refresh();
        ViewerTest.assertNoErrors(this.m_lastParseInfo);
    }

    @Test
    public void test_parseAnonymous_wrapper() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    TableViewer tableViewer = new TableViewer(table) {", "    };", "  }", "}");
        this.refresh();
        ViewerTest.assertNoErrors(this.m_lastParseInfo);
    }

    @Test
    public void test_exposeViewer() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        ViewerInfo viewer = (ViewerInfo)table.getChildrenJava().get(0);
        IAction exposeAction = ViewerTest.findChildAction((IContributionManager)ViewerTest.getContextMenu(new ObjectInfo[]{viewer}), "Expose viewer...");
        ViewerTest.assertNotNull((Object)exposeAction);
        ReflectionUtils.invokeMethod(ExposeComponentSupport.class, (String)"expose(org.eclipse.wb.core.model.JavaInfo,java.lang.String,java.lang.String)", (Object[])new Object[]{viewer, "getTableViewer", "public"});
        this.assertEditor("class Test extends Shell {", "  private TableViewer tableViewer;", "  public Test() {", "    setLayout(new FillLayout());", "    tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "  public TableViewer getTableViewer() {", "    return tableViewer;", "  }", "}");
    }

    @Test
    public void test_exposedViewer() throws Exception {
        ViewerTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private TableViewer m_viewer;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    m_viewer = new TableViewer(this, SWT.BORDER);", "  }", "  public TableViewer getViewer() {", "    return m_viewer;", "  }", "}"));
        ViewerTest.waitForAutoBuild();
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    MyComposite composite = new MyComposite(this, SWT.NONE);", "  }", "}");
        ViewerTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new MyComposite(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: test.MyComposite} {local-unique: composite} {/new MyComposite(this, SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {}", "      {method: public org.eclipse.jface.viewers.TableViewer test.MyComposite.getViewer()} {property} {}");
    }

    @Test
    public void test_parseNormalNoControl() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    tableViewer.setUseHashlookup(true);", "  }", "}");
        ViewerTest.assertEquals((long)2L, (long)shell.getChildrenJava().size());
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        ViewerInfo viewer = (ViewerInfo)table.getChildren().get(0);
        ViewerTest.assertEquals((Object)"tableViewer", (Object)viewer.getVariableSupport().getName());
        Association association = viewer.getAssociation();
        ViewerTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)association);
        association = table.getAssociation();
        ViewerTest.assertInstanceOf(WrappedObjectAssociation.class, (Object)association);
        ViewerTest.assertEquals((Object)"new TableViewer(this, SWT.BORDER)", (Object)association.getSource());
        ViewerTest.assertSame((Object)association.getStatement(), (Object)viewer.getAssociation().getStatement());
        VariableSupport variable = table.getVariableSupport();
        ViewerTest.assertInstanceOf(WrapperMethodControlVariableSupport.class, (Object)variable);
        ViewerTest.assertEquals((Object)"viewer", (Object)variable.toString());
        ViewerTest.assertEquals((Object)"tableViewer.getTable()", (Object)variable.getTitle());
        CreationSupport creation = table.getCreationSupport();
        ViewerTest.assertInstanceOf(WrapperMethodControlCreationSupport.class, (Object)creation);
        ViewerTest.assertEquals((Object)"viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()", (Object)creation.toString());
        ViewerTest.assertEquals((Object)viewer.getCreationSupport().getNode(), (Object)creation.getNode());
        ViewerTest.assertTrue((boolean)creation.canReorder());
        ViewerTest.assertTrue((boolean)creation.canReparent());
        ViewerTest.assertTrue((boolean)table.canDelete());
        table.delete();
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
    }

    @Test
    public void test_normalNoControl_materialize() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        table.addMethodInvocation("setHeaderVisible(boolean)", "true");
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    Table table = tableViewer.getTable();", "    table.setHeaderVisible(true);", "  }", "}");
        ViewerTest.assertInstanceOf(WrapperMethodControlCreationSupport.class, (Object)table.getCreationSupport());
        ViewerTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)table.getVariableSupport());
        MethodInvocation getTableNode = (MethodInvocation)table.getRelatedNodes().get(0);
        ViewerTest.assertTrue((boolean)table.isRepresentedBy((ASTNode)getTableNode));
    }

    @Test
    public void test_normalNoControl_move() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    Composite composite = new Composite(this, SWT.NONE);", "  }", "}");
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        fillLayout.command_MOVE((ControlInfo)table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Composite composite = new Composite(this, SWT.NONE);", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
    }

    @Test
    public void test_normalNoControl_reparent() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    //", "    Composite composite = new Composite(this, SWT.NONE);", "    composite.setLayout(new RowLayout());", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(1);
        RowLayoutInfo rowLayout = (RowLayoutInfo)composite.getLayout();
        rowLayout.command_MOVE((ControlInfo)table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    Composite composite = new Composite(this, SWT.NONE);", "    composite.setLayout(new RowLayout());", "    //", "    TableViewer tableViewer = new TableViewer(composite, SWT.BORDER);", "  }", "}");
    }

    @Test
    public void test_normalWithControl_reparent() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    Table table = tableViewer.getTable();", "    //", "    Composite composite = new Composite(this, SWT.NONE);", "    composite.setLayout(new RowLayout());", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(1);
        RowLayoutInfo rowLayout = (RowLayoutInfo)composite.getLayout();
        rowLayout.command_MOVE((ControlInfo)table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    Composite composite = new Composite(this, SWT.NONE);", "    composite.setLayout(new RowLayout());", "    //", "    TableViewer tableViewer = new TableViewer(composite, SWT.BORDER);", "    Table table = tableViewer.getTable();", "  }", "}");
    }

    @Test
    public void test_materialized_move() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(1);
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        rowLayout.command_MOVE(table, button);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_newCreated_move() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        ViewerInfo viewer = ViewerTest.createTableViewer(this.m_lastEditor);
        ControlInfo table = (ControlInfo)viewer.getWrapper().getWrappedInfo();
        rowLayout.command_CREATE(table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "    }", "  }", "}");
        rowLayout.command_MOVE(table, button);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_parseAroundTable() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      TableViewer viewer = new TableViewer(table);", "      viewer.getTable().setEnabled(false);", "    }", "  }", "}");
        ViewerTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new Table(this, SWT.BORDER)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.widgets.Table} {local-unique: table} {/new Table(this, SWT.BORDER)/ /new TableViewer(table)/ /viewer.getTable().setEnabled(false)/}", "    {new: org.eclipse.jface.viewers.TableViewer} {local-unique: viewer} {/new TableViewer(table)/ /viewer.getTable()/}");
        TableInfo table = (TableInfo)ViewerTest.getJavaInfoByName("table");
        ViewerInfo viewer = (ViewerInfo)ViewerTest.getJavaInfoByName("viewer");
        ViewerTest.assertSame((Object)table, (Object)viewer.getParent());
        WrapperByMethod wrapper = viewer.getWrapper();
        ViewerTest.assertSame((Object)viewer, (Object)wrapper.getWrapperInfo());
        ViewerTest.assertSame((Object)table, (Object)wrapper.getWrappedInfo());
    }

    @Test
    public void test_property_useHashlookup() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        ViewerInfo viewer = (ViewerInfo)table.getChildrenJava().get(0);
        Property property = viewer.getPropertyByTitle("useHashlookup");
        ViewerTest.assertEquals((Object)Boolean.FALSE, (Object)property.getValue());
        property.setValue((Object)Boolean.TRUE);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    tableViewer.setUseHashlookup(true);", "  }", "}");
        property.setValue((Object)Boolean.FALSE);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
    }

    @Test
    public void test_property_style() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        ViewerInfo viewer = (ViewerInfo)table.getChildrenJava().get(0);
        Property property = viewer.getPropertyByTitle("Style");
        ViewerTest.assertEquals((Object)2048, (Object)property.getValue());
    }

    @Test
    public void test_contentProvider() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        ViewerInfo viewer = (ViewerInfo)table.getChildrenJava().get(0);
        final Property property = viewer.getPropertyByTitle("contentProvider");
        InnerClassPropertyEditor propertyEditor = (InnerClassPropertyEditor)property.getEditor();
        ViewerTest.assertEquals((Object)"<double click>", (Object)ViewerTest.getPropertyText(property));
        propertyEditor.activate(null, property, null);
        this.assertEditor("class Test extends Shell {", "  private static class ContentProvider implements IStructuredContentProvider {", "    public Object[] getElements(Object inputElement) {", "      return new Object[0];", "    }", "    public void dispose() {", "    }", "    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {", "    }", "  }", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = new TableViewer(this, SWT.BORDER);", "    tableViewer.setContentProvider(new ContentProvider());", "  }", "}");
        ViewerTest.assertEquals((Object)"test.Test.ContentProvider", (Object)ViewerTest.getPropertyText(property));
        propertyEditor.doubleClick(property, null);
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"new ContentProvider", (String)"new ArrayContentProvider");
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                ViewerTest.openPropertyDialog(property);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                ViewerTest.animateOpenTypeSelection(bot, "ArrayContentPro", "OK");
            }
        });
        ViewerTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_noRootComposite() throws Exception {
        try {
            this.parseComposite("public class Test {", "  public Test(Composite parent) {", "    TableViewer tableViewer = new TableViewer(parent, SWT.BORDER);", "  }", "}");
            ViewerTest.fail();
        }
        catch (Throwable e) {
            Throwable rootCause = DesignerExceptionUtils.getRootCause((Throwable)e);
            Assertions.assertThat((Throwable)rootCause).isExactlyInstanceOf(NoEntryPointError.class);
        }
    }

    @Test
    public void test_CREATE_liveImage() throws Exception {
        this.parseComposite("// filler filler filler", "class Test extends Shell {", "  public Test() {", "  }", "}");
        ViewerInfo viewer = ViewerTest.createTableViewer(this.m_lastEditor);
        TableInfo table = (TableInfo)viewer.getWrapper().getWrappedInfo();
        Image image = table.getImage();
        ViewerTest.assertNotNull((Object)image);
    }

    @Test
    public void test_CREATE_liveImage_forcedSize() throws Exception {
        ViewerTest.setFileContentSrc("test/MyTable.java", this.getTestSource("public class MyTable extends Table {", "  public MyTable(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass () {", "  }", "}"));
        ViewerTest.setFileContentSrc("test/MyTableViewer.java", this.getTestSource("public class MyTableViewer extends TableViewer {", "  public MyTableViewer(Composite parent) {", "    super(new MyTable(parent, SWT.NO_SCROLL));", "  }", "  public MyTable getMyTable() {", "    return (MyTable) getTable();", "  }", "}"));
        ViewerTest.setFileContentSrc("test/MyTable.wbp-component.xml", ViewerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='liveComponent.forcedSize.width'>200</parameter>", "    <parameter name='liveComponent.forcedSize.height'>150</parameter>", "  </parameters>", "</component>"));
        ViewerTest.setFileContentSrc("test/MyTableViewer.wbp-component.xml", ViewerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyTableViewer(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='org.eclipse.swt.widgets.Composite' parent='true'/>", "    </constructor>", "  </constructors>", "  <parameters>", "    <parameter name='viewer.control.method'>getMyTable</parameter>", "  </parameters>", "</component>"));
        ViewerTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "class Test extends Shell {", "  public Test() {", "  }", "}");
        ViewerInfo viewer = ViewerTest.createViewer(this.m_lastEditor, "test.MyTableViewer");
        TableInfo table = (TableInfo)viewer.getWrapper().getWrappedInfo();
        Image image = table.getImage();
        ViewerTest.assertNotNull((Object)image);
        Rectangle bounds = image.getBounds();
        ViewerTest.assertEquals((long)200L, (long)bounds.width);
        ViewerTest.assertEquals((long)150L, (long)bounds.height);
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        ViewerInfo viewer = ViewerTest.createTableViewer(this.m_lastEditor);
        TableInfo table = (TableInfo)JavaInfoUtils.getWrapped((JavaInfo)viewer);
        ViewerTest.assertSame((Object)table, (Object)JavaInfoUtils.getWrapped((JavaInfo)table));
        CreationSupport creationSupport = table.getCreationSupport();
        ViewerTest.assertNull((Object)creationSupport.getNode());
        ViewerTest.assertFalse((boolean)creationSupport.isJavaInfo(null));
        ViewerTest.assertFalse((boolean)creationSupport.canReorder());
        ViewerTest.assertFalse((boolean)creationSupport.canReparent());
        fillLayout.command_CREATE((ControlInfo)table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "    }", "  }", "}");
        ViewerTest.assertSame((Object)shell, (Object)table.getParent());
        creationSupport = table.getCreationSupport();
        ViewerTest.assertInstanceOf(WrapperMethodControlCreationSupport.class, (Object)creationSupport);
        ViewerTest.assertSame((Object)table, (Object)ReflectionUtils.getFieldObject((Object)creationSupport, (String)"m_javaInfo"));
        ViewerTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)table.getVariableSupport());
        ViewerTest.assertEquals((Object)"{viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {local-unique: table} {/tableViewer.getTable()/}", (Object)table.toString());
        ViewerTest.assertSame((Object)viewer, table.getChildrenJava().get(0));
        ViewerTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)viewer.getCreationSupport());
        ViewerTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)viewer.getVariableSupport());
        ViewerTest.assertEquals((Object)"tableViewer", (Object)viewer.getVariableSupport().getName());
        ViewerTest.assertEquals((Object)"{new: org.eclipse.jface.viewers.TableViewer} {local-unique: tableViewer} {/new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION)/ /tableViewer.getTable()/}", (Object)viewer.toString());
        Association viewerAssociation = viewer.getAssociation();
        Association tableAssociation = table.getAssociation();
        ViewerTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)viewerAssociation);
        ViewerTest.assertEquals((Object)"new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION)", (Object)viewerAssociation.getSource());
        ViewerTest.assertSame((Object)viewerAssociation.getStatement(), (Object)tableAssociation.getStatement());
    }

    @Test
    public void test_CREATE_useFieldVariable() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        ViewerInfo viewer = ViewerTest.createTableViewer(this.m_lastEditor);
        TableInfo table = (TableInfo)JavaInfoUtils.getWrapped((JavaInfo)viewer);
        GenerationSettings settings = viewer.getDescription().getToolkit().getGenerationSettings();
        settings.setVariable(FieldUniqueVariableDescription.INSTANCE);
        fillLayout.command_CREATE((ControlInfo)table, null);
        this.assertEditor("class Test extends Shell {", "  private Table table;", "  private TableViewer tableViewer;", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      table = tableViewer.getTable();", "    }", "  }", "}");
    }

    public static ViewerInfo createTableViewer(AstEditor editor) throws Exception {
        return ViewerTest.createViewer(editor, "org.eclipse.jface.viewers.TableViewer");
    }

    private static ViewerInfo createViewer(AstEditor editor, String tableViewerClassName) throws Exception {
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport();
        return (ViewerInfo)JavaInfoUtils.createJavaInfo((AstEditor)editor, (String)tableViewerClassName, (CreationSupport)creationSupport);
    }
}

