/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.core.model.association.WrappedObjectAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Before;
import org.junit.Test;

public class StaticFactoryTest
extends RcpModelTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        StaticFactoryTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'SF button'", "  * @wbp.factory.parameter.property text setText(java.lang.String)", "  */", "  public static Button createButton(Composite parent, String text) {", "    Button button = new Button(parent, SWT.NONE);", "    button.setText(text);", "    return button;", "  }", "  public static TableViewer createTableViewer(Composite parent) {", "    return new TableViewer(parent, SWT.BORDER | SWT.FULL_SELECTION);", "  }", "}"));
        StaticFactoryTest.waitForAutoBuild();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse_Button() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = StaticFactory.createButton(this, 'SF button');", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Association association = button.getAssociation();
        StaticFactoryTest.assertInstanceOf(FactoryParentAssociation.class, (Object)association);
        StaticFactoryTest.assertEquals((Object)"StaticFactory.createButton(this, \"SF button\")", (Object)association.getSource());
    }

    @Test
    public void test_parse_TableViewer() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    TableViewer tableViewer = StaticFactory.createTableViewer(this);", "  }", "}");
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(0);
        Association tableAssociation = table.getAssociation();
        StaticFactoryTest.assertInstanceOf(WrappedObjectAssociation.class, (Object)tableAssociation);
        StaticFactoryTest.assertEquals((Object)"StaticFactory.createTableViewer(this)", (Object)tableAssociation.getSource());
        ViewerInfo viewer = (ViewerInfo)table.getChildrenJava().get(0);
        Association viewerAssociation = viewer.getAssociation();
        StaticFactoryTest.assertInstanceOf(FactoryParentAssociation.class, (Object)viewerAssociation);
        StaticFactoryTest.assertEquals((Object)"StaticFactory.createTableViewer(this)", (Object)viewerAssociation.getSource());
    }

    @Test
    public void test_ADD_TableViewer() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    TableViewer tableViewer = StaticFactory.createTableViewer(this);", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "    }", "  }", "}");
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(1);
        RowLayoutInfo compositeLayout = (RowLayoutInfo)composite.getLayout();
        compositeLayout.command_MOVE(table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      //", "      TableViewer tableViewer = StaticFactory.createTableViewer(composite);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Button() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        RowLayoutInfo layout = (RowLayoutInfo)shell.getLayout();
        ControlInfo button = this.createNewButton(this.m_lastEditor);
        layout.command_CREATE(button, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = StaticFactory.createButton(this, 'SF button');", "    }", "  }", "}");
        StaticFactoryTest.assertEquals((Object)"StaticFactory.createButton(this, \"SF button\")", (Object)button.getAssociation().getSource());
    }

    private ControlInfo createNewButton(AstEditor editor) throws Exception {
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)editor, this.m_lastLoader.loadClass("test.StaticFactory"), (String)"createButton(org.eclipse.swt.widgets.Composite,java.lang.String)", (boolean)true);
        return (ControlInfo)JavaInfoUtils.createJavaInfo((AstEditor)editor, this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Button"), (CreationSupport)new StaticFactoryCreationSupport(description));
    }

    @Test
    public void test_CREATE_TableViewer() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        RowLayoutInfo layout = (RowLayoutInfo)shell.getLayout();
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.StaticFactory"), (String)"createTableViewer(org.eclipse.swt.widgets.Composite)", (boolean)true);
        ViewerInfo viewer = (ViewerInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.jface.viewers.TableViewer"), (CreationSupport)new StaticFactoryCreationSupport(description));
        ControlInfo table = (ControlInfo)JavaInfoUtils.getWrapped((JavaInfo)viewer);
        layout.command_CREATE(table, null);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      TableViewer tableViewer = StaticFactory.createTableViewer(this);", "      Table table = tableViewer.getTable();", "    }", "  }", "}");
        StaticFactoryTest.assertSame((Object)shell, (Object)table.getParent());
        StaticFactoryTest.assertSame((Object)table, (Object)viewer.getParent());
        StaticFactoryTest.assertEquals((Object)"StaticFactory.createTableViewer(this)", (Object)table.getAssociation().getSource());
        StaticFactoryTest.assertSame((Object)table.getAssociation().getStatement(), (Object)viewer.getAssociation().getStatement());
    }

    @Test
    public void test_CREATE_liveImage() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "class Test extends Shell {", "  public Test() {", "  }", "}");
        AbsoluteLayoutInfo absoluteLayout = (AbsoluteLayoutInfo)shell.getLayout();
        ControlInfo button = this.createNewButton(this.m_lastEditor);
        Image image = button.getImage();
        StaticFactoryTest.assertNotNull((Object)image);
        absoluteLayout.commandCreate(button, null);
        this.assertEditor("// filler filler filler", "class Test extends Shell {", "  public Test() {", "    {", "      Button button = StaticFactory.createButton(this, 'SF button');", "    }", "  }", "}");
    }
}

