/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.tests.gef.GefTestCase;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GraphicalViewerTest
extends GefTestCase {
    private Shell m_shell;
    private EditDomain m_domain;
    private GraphicalViewer m_viewer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_shell = new Shell();
        this.m_domain = new EditDomain(){

            public Tool getDefaultTool() {
                return null;
            }
        };
        this.m_viewer = new GraphicalViewer((Composite)this.m_shell);
        this.m_viewer.getControl().setSize(500, 400);
        this.m_viewer.setEditDomain(this.m_domain);
    }

    @After
    public void tearDown() throws Exception {
        this.m_shell.dispose();
    }

    @Test
    public void test_Selection() throws Exception {
        TestEditPart part1 = new TestEditPart((IEditPartViewer)this.m_viewer);
        TestEditPart part2 = new TestEditPart((IEditPartViewer)this.m_viewer);
        TestEditPart part3 = new TestEditPart((IEditPartViewer)this.m_viewer);
        GraphicalViewerTest.assertEquals((long)0L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part3.getSelected());
        GraphicalViewerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        this.m_viewer.select((EditPart)part1);
        GraphicalViewerTest.assertEquals((long)2L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part1), this.m_viewer.getSelectedEditParts().get(0));
        this.m_viewer.select((EditPart)part2);
        GraphicalViewerTest.assertEquals((long)0L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)2L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part2), this.m_viewer.getSelectedEditParts().get(0));
        this.m_viewer.appendSelection((EditPart)part3);
        GraphicalViewerTest.assertEquals((long)0L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)2L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)2L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part2), this.m_viewer.getSelectedEditParts().get(0));
        GraphicalViewerTest.assertSame((Object)((Object)part3), this.m_viewer.getSelectedEditParts().get(1));
        this.m_viewer.appendSelection((EditPart)part1);
        GraphicalViewerTest.assertEquals((long)2L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)3L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part2), this.m_viewer.getSelectedEditParts().get(0));
        GraphicalViewerTest.assertSame((Object)((Object)part3), this.m_viewer.getSelectedEditParts().get(1));
        GraphicalViewerTest.assertSame((Object)((Object)part1), this.m_viewer.getSelectedEditParts().get(2));
        this.m_viewer.appendSelection((EditPart)part2);
        GraphicalViewerTest.assertEquals((long)1L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)2L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)3L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part3), this.m_viewer.getSelectedEditParts().get(0));
        GraphicalViewerTest.assertSame((Object)((Object)part1), this.m_viewer.getSelectedEditParts().get(1));
        GraphicalViewerTest.assertSame((Object)((Object)part2), this.m_viewer.getSelectedEditParts().get(2));
        this.m_viewer.deselect((EditPart)part2);
        GraphicalViewerTest.assertEquals((long)2L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)2L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part3), this.m_viewer.getSelectedEditParts().get(0));
        GraphicalViewerTest.assertSame((Object)((Object)part1), this.m_viewer.getSelectedEditParts().get(1));
        this.m_viewer.deselectAll();
        GraphicalViewerTest.assertEquals((long)0L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part3.getSelected());
        GraphicalViewerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        ArrayList<TestEditPart> selection = new ArrayList<TestEditPart>();
        selection.add(part2);
        selection.add(part1);
        this.m_viewer.setSelection((ISelection)new StructuredSelection(selection));
        GraphicalViewerTest.assertEquals((long)2L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)1L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part3.getSelected());
        GraphicalViewerTest.assertEquals((long)2L, (long)this.m_viewer.getSelectedEditParts().size());
        GraphicalViewerTest.assertSame((Object)((Object)part2), this.m_viewer.getSelectedEditParts().get(0));
        GraphicalViewerTest.assertSame((Object)((Object)part1), this.m_viewer.getSelectedEditParts().get(1));
        this.m_viewer.setSelection((ISelection)new StructuredSelection());
        GraphicalViewerTest.assertEquals((long)0L, (long)part1.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part2.getSelected());
        GraphicalViewerTest.assertEquals((long)0L, (long)part3.getSelected());
        GraphicalViewerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
    }

    @Test
    public void test_Invoke_SelectionListener() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                actualLogger.log("selectionChanged(" + String.valueOf(event) + ")");
            }
        };
        this.m_viewer.addSelectionChangedListener(listener);
        actualLogger.assertEmpty();
        TestEditPart part1 = new TestEditPart((IEditPartViewer)this.m_viewer);
        this.m_viewer.appendSelection((EditPart)part1);
        TestLogger expectedLogger = new TestLogger();
        expectedLogger.log("selectionChanged(" + String.valueOf(new SelectionChangedEvent((ISelectionProvider)this.m_viewer, (ISelection)new StructuredSelection((Object)part1))) + ")");
        actualLogger.assertEquals(expectedLogger);
        TestEditPart part2 = new TestEditPart((IEditPartViewer)this.m_viewer);
        this.m_viewer.select((EditPart)part2);
        expectedLogger.log("selectionChanged(" + String.valueOf(new SelectionChangedEvent((ISelectionProvider)this.m_viewer, (ISelection)new StructuredSelection((Object)part2))) + ")");
        actualLogger.assertEquals(expectedLogger);
        this.m_viewer.select((EditPart)part2);
        actualLogger.assertEmpty();
        this.m_viewer.deselectAll();
        expectedLogger.log("selectionChanged(" + String.valueOf(new SelectionChangedEvent((ISelectionProvider)this.m_viewer, (ISelection)new StructuredSelection())) + ")");
        actualLogger.assertEquals(expectedLogger);
        ArrayList<TestEditPart> selection = new ArrayList<TestEditPart>();
        selection.add(part2);
        selection.add(part1);
        this.m_viewer.setSelection((ISelection)new StructuredSelection(selection));
        expectedLogger.log("selectionChanged(" + String.valueOf(new SelectionChangedEvent((ISelectionProvider)this.m_viewer, (ISelection)new StructuredSelection(selection))) + ")");
        actualLogger.assertEquals(expectedLogger);
        this.m_viewer.deselect((EditPart)part1);
        expectedLogger.log("selectionChanged(" + String.valueOf(new SelectionChangedEvent((ISelectionProvider)this.m_viewer, (ISelection)new StructuredSelection((Object)part2))) + ")");
        actualLogger.assertEquals(expectedLogger);
        this.m_viewer.setSelection((ISelection)new StructuredSelection());
        expectedLogger.log("selectionChanged(" + String.valueOf(new SelectionChangedEvent((ISelectionProvider)this.m_viewer, (ISelection)new StructuredSelection())) + ")");
        actualLogger.assertEquals(expectedLogger);
    }

    private static final class TestEditPart
    extends GraphicalEditPart {
        private final IEditPartViewer m_viewer;

        public TestEditPart(IEditPartViewer viewer) {
            this.m_viewer = viewer;
        }

        protected Figure createFigure() {
            return null;
        }

        public IEditPartViewer getViewer() {
            return this.m_viewer;
        }
    }
}

