/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.awt.Component;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetVariable;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAllProperties;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class JavaInfoTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_toString_0() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoTest.assertEquals((Object)"{this: javax.swing.JPanel} {this} {}", (Object)panel.toString());
    }

    @Test
    public void test_toString_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(true);", "  }", "}");
        JavaInfoTest.assertEquals((Object)"{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/ /panel.setEnabled(true)/}", (Object)panel.toString());
    }

    @Test
    public void test_toString_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertEquals((Object)"{this: javax.swing.JPanel} {this} {/add(button)/}", (Object)panel.toString());
        JavaInfoTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", (Object)button.toString());
    }

    @Test
    public void test_toString_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton() {};", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", (Object)button.toString());
    }

    @Test
    public void test_isRepresentedBy_CreationSupport() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExpressionStatement statement = (ExpressionStatement)JavaInfoTest.getStatement((JavaInfo)panel, 0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        Expression creationExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)creationExpression));
    }

    @Test
    public void test_isRepresentedBy_localUniqueVariableDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableDeclarationStatement statement = (VariableDeclarationStatement)JavaInfoTest.getStatement((JavaInfo)panel, 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)DomGenerics.fragments((VariableDeclarationStatement)statement).get(0);
        JavaInfoTest.assertEquals((Object)"button", (Object)fragment.getName().getIdentifier());
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)fragment.getName()));
    }

    @Test
    public void test_isRepresentedBy_localUniqueVariableAssignment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    JButton button;", "    button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExpressionStatement statement = (ExpressionStatement)JavaInfoTest.getStatement((JavaInfo)panel, 1);
        Assignment assignment = (Assignment)statement.getExpression();
        JavaInfoTest.assertEquals((Object)"button", (Object)((SimpleName)assignment.getLeftHandSide()).getIdentifier());
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)assignment.getLeftHandSide()));
    }

    @Test
    public void test_isRepresentedBy_fieldInitializer() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button = new JButton();", "  Test() {", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldDeclaration fieldDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel).getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)fieldDeclaration).get(0);
        JavaInfoTest.assertEquals((Object)"button", (Object)fragment.getName().getIdentifier());
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)fragment.getName()));
    }

    @Test
    public void test_isRepresentedBy_fieldUnique() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExpressionStatement statement = (ExpressionStatement)JavaInfoTest.getStatement((JavaInfo)panel, 0);
        Assignment assignment = (Assignment)statement.getExpression();
        JavaInfoTest.assertEquals((Object)"button", (Object)((SimpleName)assignment.getLeftHandSide()).getIdentifier());
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)assignment.getLeftHandSide()));
    }

    @Test
    public void test_isRepresentedBy_referenceInTryStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  JButton button = new JButton();", "  Test() {", "    init();", "    add(button);", "  }", "  void init() {", "    try {", "      button.setEnabled(false);", "    } catch (Throwable e) {", "      showError(e);", "    }", "  }", "  void showError(Throwable e) {", "    System.out.println(e);", "  }", "}");
        JavaInfoTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertTrue((button.getDescription().getComponentClass() == JButton.class ? 1 : 0) != 0);
    }

    @Test
    public void test_isRepresentedBy_ParenthesizedExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    add((new JButton()));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        int index = this.m_lastEditor.getSource().indexOf("(new");
        ASTNode node = this.m_lastEditor.getEnclosingNode(index);
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy(node));
    }

    @Test
    public void test_isRepresentedBy_CastExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    add((Component) new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        int index = this.m_lastEditor.getSource().indexOf("(Component");
        ASTNode node = this.m_lastEditor.getEnclosingNode(index);
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy(node));
    }

    @Test
    public void test_isRepresentedBy_emptyField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    System.out.println(button);", "  }", "}");
        ASTNode node = this.m_lastEditor.getEnclosingNode("button)");
        JavaInfoTest.assertFalse((boolean)panel.isRepresentedBy(node));
    }

    @Test
    public void test_isRepresentedBy_nullField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button = null;", "  public Test() {", "    System.out.println(button);", "  }", "}");
        ASTNode node = this.m_lastEditor.getEnclosingNode("button)");
        JavaInfoTest.assertFalse((boolean)panel.isRepresentedBy(node));
    }

    @Test
    public void test_isRepresentedBy_SingleVariableDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    createContents(this);", "  }", "  private void createContents(JPanel parent) {", "    System.out.println(parent);", "  }", "}");
        SimpleName node = (SimpleName)this.getNode("parent);");
        JavaInfoTest.assertTrue((boolean)panel.isRepresentedBy((ASTNode)node));
        node = this.getNode("parent) {", SimpleName.class);
        JavaInfoTest.assertTrue((boolean)panel.isRepresentedBy((ASTNode)node));
    }

    @Test
    public void test_isRepresentedBy_SingleVariableDeclaration_moreThanOneInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    createContents(this, 0);", "    createContents(this, 1);", "  }", "  private void createContents(JPanel parent, int value) {", "    System.out.println(parent);", "  }", "}");
        SimpleName node = (SimpleName)this.getNode("parent);");
        JavaInfoTest.assertTrue((boolean)panel.isRepresentedBy((ASTNode)node));
    }

    @Test
    public void test_isRepresentedBy_ConstructorInvocation_argument() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    this(new JButton());", "  }", "  public Test(Component child) {", "    add(child);", "  }", "}");
        JavaInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(child)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/new JButton()/ /add(child)/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ClassInstanceCreation node = (ClassInstanceCreation)this.m_lastEditor.getEnclosingNode("new JButton()");
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)node));
        node = (SimpleName)this.m_lastEditor.getEnclosingNode("child);");
        JavaInfoTest.assertTrue((boolean)button.isRepresentedBy((ASTNode)node));
    }

    @Test
    public void test_isRepresentedBy_recursion() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    System.out.println(recursiveMethod(new Object()));", "  }", "  private Object recursiveMethod(Object o) {", "    o = recursiveMethod(o);", "    return o;", "  }", "}");
        ASTNode node = this.m_lastEditor.getEnclosingNode("recursiveMethod(new");
        JavaInfoTest.assertFalse((boolean)panel.isRepresentedBy(node));
    }

    @Test
    public void test_setVariableBroadcast() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        final ComponentInfo button = (ComponentInfo)JavaInfoTest.getJavaInfoByName("button");
        final VariableSupport expected_oldVariable = button.getVariableSupport();
        SimpleName name = (SimpleName)this.m_lastEditor.getEnclosingNode("button =");
        LocalUniqueVariableSupport expected_newVariable = new LocalUniqueVariableSupport((JavaInfo)button, name);
        AtomicInteger count = new AtomicInteger();
        button.addBroadcastListener((Object)new JavaInfoSetVariable((VariableSupport)expected_newVariable, count){
            private final /* synthetic */ VariableSupport val$expected_newVariable;
            private final /* synthetic */ AtomicInteger val$count;
            {
                this.val$expected_newVariable = variableSupport2;
                this.val$count = atomicInteger;
            }

            public void invoke(JavaInfo javaInfo, VariableSupport oldVariable, VariableSupport newVariable) throws Exception {
                JavaInfoTest.assertSame((Object)button, (Object)javaInfo);
                JavaInfoTest.assertSame((Object)expected_oldVariable, (Object)oldVariable);
                JavaInfoTest.assertSame((Object)this.val$expected_newVariable, (Object)newVariable);
                this.val$count.incrementAndGet();
            }
        });
        button.setVariableSupport((VariableSupport)expected_newVariable);
        JavaInfoTest.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void test_addExpressionStatement_1_local() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()"});
        panel.startEdit();
        String source = TemplateUtils.format((String)"{0}.setEnabled(false)", (Object[])new Object[]{panel});
        MethodInvocation invocation = (MethodInvocation)panel.addExpressionStatement(source);
        JavaInfoTest.assertNotNull((Object)invocation);
        this.assertEditor("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()", "panel.setEnabled(false)"});
        this.m_lastEditor.removeEnclosingStatement((ASTNode)invocation);
        JavaInfoTest.assertEditor(this.getTestSource("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}"), this.m_lastEditor);
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()"});
    }

    @Test
    public void test_addExpressionStatement_template() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String expressionSource = TemplateUtils.format((String)"{0}.setEnabled(true)", (Object[])new Object[]{panel});
        panel.addExpressionStatement(expressionSource);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
    }

    @Test
    public void test_replaceExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JLabel label = new JLabel();", "    add(label);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "    //", "    label.setLabelFor(button_1);", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
        MethodInvocation invocation = label.getMethodInvocation("setLabelFor(java.awt.Component)");
        Expression expression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
        label.replaceExpression(expression, TemplateUtils.getExpression((JavaInfo)button_2));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JLabel label = new JLabel();", "    add(label);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "    //", "    label.setLabelFor(button_2);", "  }", "}");
    }

    @Test
    public void test_getMethodInvocations() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "    panel.setEnabled(true);", "  }", "}");
        JavaInfoTest.assertEquals((long)0L, (long)panel.getMethodInvocations("setVisible(boolean)").size());
        List invocations = panel.getMethodInvocations("setEnabled(boolean)");
        JavaInfoTest.assertEquals((long)2L, (long)invocations.size());
        JavaInfoTest.assertEquals((Object)"panel.setEnabled(false)", (Object)this.m_lastEditor.getSource((ASTNode)invocations.get(0)));
        JavaInfoTest.assertEquals((Object)"panel.setEnabled(true)", (Object)this.m_lastEditor.getSource((ASTNode)invocations.get(1)));
        JavaInfoTest.assertNull((Object)panel.getMethodInvocation("setVisible(boolean)"));
        MethodInvocation invocation = panel.getMethodInvocation("setEnabled(boolean)");
        JavaInfoTest.assertNotNull((Object)invocation);
        JavaInfoTest.assertEquals((Object)"setEnabled", (Object)invocation.getName().getIdentifier());
    }

    @Test
    public void test_getMethodInvocations_all_emptyInvocation() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "    container.add(this);", "  }", "  public void setFoo(boolean value) {", "  }", "}"));
        JavaInfoTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this).setFoo(false);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        List invocations = button.getMethodInvocations();
        Assertions.assertThat((List)invocations).isNotEmpty();
    }

    @Test
    public void test_removeMethodInvocations() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "    panel.setEnabled(true);", "  }", "}");
        panel.removeMethodInvocations("setEnabled(boolean)");
        this.assertEditor("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
    }

    @Test
    public void test_addMethodInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()"});
        panel.addMethodInvocation("setSize(int,int)", "200, 100");
        this.assertEditor("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setSize(200, 100);", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()", "panel.setSize(200, 100)"});
    }

    @Test
    public void test_addMethodInvocation_withTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()", "panel.setEnabled(false)"});
        MethodInvocation invocation = panel.getMethodInvocation("setEnabled(boolean)");
        StatementTarget target = new StatementTarget(AstNodeUtils.getEnclosingStatement((ASTNode)invocation), false);
        panel.addMethodInvocation(target, "setSize(int,int)", "200, 100");
        this.assertEditor("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "    panel.setSize(200, 100);", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()", "panel.setEnabled(false)", "panel.setSize(200, 100)"});
    }

    @Test
    public void test_addMethodInvocation_this() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[0]);
        panel.addMethodInvocation("setSize(int,int)", "200, 100");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setSize(200, 100);", "  }", "}");
        JavaInfoTest.assertRelatedNodes((JavaInfo)panel, new String[]{"setSize(200, 100)"});
    }

    @Test
    public void test_getAllFieldAssignments() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public int m_value1;", "  public int m_value2;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value1 = 1;", "    button.m_value2 = 2;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        List assignments = button.getFieldAssignments();
        Assertions.assertThat((List)assignments).hasSize(2);
        JavaInfoTest.assertEquals((Object)"button.m_value1 = 1", (Object)this.m_lastEditor.getSource((ASTNode)assignments.get(0)));
        JavaInfoTest.assertEquals((Object)"button.m_value2 = 2", (Object)this.m_lastEditor.getSource((ASTNode)assignments.get(1)));
    }

    @Test
    public void test_getFieldAssignments() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value = 1;", "    button.m_value = 2;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Assertions.assertThat((List)button.getFieldAssignments("noSuchField")).isEmpty();
        List assignments = button.getFieldAssignments("m_value");
        Assertions.assertThat((List)assignments).hasSize(2);
        JavaInfoTest.assertEquals((Object)"button.m_value = 1", (Object)this.m_lastEditor.getSource((ASTNode)assignments.get(0)));
        JavaInfoTest.assertEquals((Object)"button.m_value = 2", (Object)this.m_lastEditor.getSource((ASTNode)assignments.get(1)));
    }

    @Test
    public void test_getFieldAssignments_FieldAccess() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public int m_value;", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"));
        JavaInfoTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this).m_value = 1;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Assertions.assertThat((List)button.getFieldAssignments("noSuchField")).isEmpty();
        List assignments = button.getFieldAssignments("m_value");
        Assertions.assertThat((List)assignments).hasSize(1);
        JavaInfoTest.assertEquals((Object)"new MyButton(this).m_value = 1", (Object)this.m_lastEditor.getSource((ASTNode)assignments.get(0)));
    }

    @Test
    public void test_getFieldAssignment() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value = 1;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertNull((Object)button.getFieldAssignment("noSuchField"));
        Assignment assignment = button.getFieldAssignment("m_value");
        JavaInfoTest.assertEquals((Object)"button.m_value = 1", (Object)this.m_lastEditor.getSource((ASTNode)assignment));
    }

    @Test
    public void test_getFieldAssignment_ParenthesizedExpression() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    (button).m_value = 1;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Assignment assignment = button.getFieldAssignment("m_value");
        JavaInfoTest.assertNotNull((Object)assignment);
        JavaInfoTest.assertEquals((Object)"(button).m_value = 1", (Object)this.m_lastEditor.getSource((ASTNode)assignment));
    }

    @Test
    public void test_addFieldAssignment() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Assignment assignment = button.addFieldAssignment("m_value", "1");
        JavaInfoTest.assertEquals((Object)"button.m_value = 1", (Object)this.m_lastEditor.getSource((ASTNode)assignment));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value = 1;", "    add(button);", "  }", "}");
    }

    @Test
    public void test_removeFieldAssignments_normal() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value = 1;", "    button.m_value = 2;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.removeFieldAssignments("m_value");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_removeFieldAssignments_withDangling() throws Exception {
        this.createTypeDeclaration("test", "MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value = button.m_value = 1;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.removeFieldAssignments("m_value");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_delete_1() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  // filler filler filler", "  public Test() {", "    add(new JButton());", "  }", "}"};
        final ContainerInfo panel = this.parseContainer(lines);
        JavaInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final boolean[] wasBefore = new boolean[1];
        final boolean[] wasAfter = new boolean[1];
        panel.addBroadcastListener((Object)new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                JavaInfoTest.assertSame((Object)panel, (Object)parent);
                JavaInfoTest.assertSame((Object)button, (Object)child);
                JavaInfoTest.assertTrue((boolean)button.isDeleting());
                JavaInfoTest.assertFalse((boolean)button.isDeleted());
                wasBefore[0] = true;
            }

            public void after(ObjectInfo parent, ObjectInfo child) throws Exception {
                JavaInfoTest.assertSame((Object)panel, (Object)parent);
                JavaInfoTest.assertSame((Object)button, (Object)child);
                JavaInfoTest.assertTrue((boolean)button.isDeleting());
                JavaInfoTest.assertTrue((boolean)button.isDeleted());
                wasAfter[0] = true;
            }
        });
        button.delete();
        JavaInfoTest.assertFalse((boolean)button.isDeleting());
        JavaInfoTest.assertTrue((boolean)button.isDeleted());
        JavaInfoTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  // filler filler filler", "  public Test() {", "  }", "}"), (Object)this.m_lastEditor.getSource());
        JavaInfoTest.assertTrue((boolean)wasBefore[0]);
        JavaInfoTest.assertTrue((boolean)wasAfter[0]);
        JavaInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_delete_whenNoParentVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JButton button = new JButton();", "    new JPanel().add(button);", "  }", "}");
        JavaInfoTest.assertHierarchy("{new: javax.swing.JPanel} {empty} {/new JPanel().add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /new JPanel().add(button)/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        JavaInfoTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_canDelete_script_false() throws Exception {
        this.check_canDelete_script("false", false);
    }

    @Test
    public void test_canDelete_script_true() throws Exception {
        this.check_canDelete_script("true", true);
    }

    @Test
    public void test_canDelete_script_notBoolean() throws Exception {
        this.check_canDelete_script("42", false);
    }

    private void check_canDelete_script(String script, boolean expected) throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        JavaInfoTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='canDelete'>" + script + "</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    MyButton button = new MyButton();", "    new JPanel().add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)JavaInfoTest.getJavaInfoByName("button");
        JavaInfoTest.assertEquals((Object)expected, (Object)button.canDelete());
    }

    @Test
    public void test_canBeRoot() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(new Button('AWT button'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertTrue((boolean)panel.canBeRoot());
        JavaInfoTest.assertFalse((boolean)button.canBeRoot());
    }

    @Test
    public void test_this_fieldName() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  private JButton button;", "  Test() {", "    this.button = new JButton();", "    add(this.button);", "  }", "}");
        JavaInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/this/ /add(this.button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {field-unique: button} {/new JButton()/ /add(this.button)/}");
    }

    @Test
    public void test_protectedProperty_use() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "  }", "  protected void setFoo(int value) {", "  }", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(new MyButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertNull((Object)button.getPropertyByTitle("foo"));
    }

    @Test
    public void test_protectedProperty_this() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "  protected void setFoo(int value) {", "  }", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoTest.assertNotNull((Object)panel.getPropertyByTitle("foo"));
    }

    @Test
    public void test_getPropertyByTitle() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoTest.assertNotNull((Object)button.getPropertyByTitle("text"));
        JavaInfoTest.assertNull((Object)button.getPropertyByTitle("no such property"));
    }

    @Test
    public void test_getProperties_allProperties() throws Exception {
        final ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat((Object[])panel.getProperties()).isNotEmpty();
        panel.addBroadcastListener((Object)new ObjectInfoAllProperties(){

            public void invoke(ObjectInfo object, List<Property> properties) throws Exception {
                if (object == panel) {
                    properties.clear();
                }
            }
        });
        Assertions.assertThat((Object[])panel.getProperties()).isEmpty();
    }

    @Test
    public void test_textInComponentTitle() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(new JButton());", "    add(new JButton('theText'));", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        JavaInfoTest.assertEquals((Object)"(no variable)", (Object)ObjectInfo.getText((ObjectInfo)button_1));
        JavaInfoTest.assertEquals((Object)"(no variable) - \"theText\"", (Object)ObjectInfo.getText((ObjectInfo)button_2));
    }

    @Test
    public void test_visibility() throws Exception {
        this.createModelType("test", "MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    add(getA());", "    add(getB());", "    add(getC());", "    add(getD());", "  }", "  private final JButton m_A = new JButton();", "  private final JButton m_B = new JButton();", "  private final JButton m_C = new JButton();", "  private final JButton m_D = new JButton();", "  public JButton getA() {", "    return m_A;", "  }", "  public JButton getB() {", "    return m_B;", "  }", "  public JButton getC() {", "    return m_C;", "  }", "  public JButton getD() {", "    return m_D;", "  }", "}"));
        JavaInfoTest.setFileContentSrc("test/MyPanel.getA.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='visible.inTree'>true</parameter>", "    <parameter name='visible.inGraphical'>true</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.setFileContentSrc("test/MyPanel.getB.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='visible.inTree'>false</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.setFileContentSrc("test/MyPanel.getC.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='visible.inGraphical'>false</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.setFileContentSrc("test/MyPanel.getD.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='visible'>false</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getA()} {property} {}", "  {method: public javax.swing.JButton test.MyPanel.getB()} {property} {}", "  {method: public javax.swing.JButton test.MyPanel.getC()} {property} {}", "  {method: public javax.swing.JButton test.MyPanel.getD()} {property} {}");
        List childrenComponents = panel.getChildrenComponents();
        ComponentInfo buttonA = (ComponentInfo)childrenComponents.get(0);
        ComponentInfo buttonB = (ComponentInfo)childrenComponents.get(1);
        ComponentInfo buttonC = (ComponentInfo)childrenComponents.get(2);
        ComponentInfo buttonD = (ComponentInfo)childrenComponents.get(3);
        Assertions.assertThat((List)childrenComponents).contains((Object[])new ComponentInfo[]{buttonA, buttonB, buttonC, buttonD});
        Assertions.assertThat((List)panel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{buttonA, buttonC});
        Assertions.assertThat((List)panel.getPresentation().getChildrenGraphical()).containsOnly((Object[])new ObjectInfo[]{buttonA, buttonB});
    }

    @Test
    public void test_setObject_FieldAccessor_notification() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public int foo = 1;", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property fooProperty = panel.getPropertyByTitle("foo");
        JavaInfoTest.assertEquals((Object)1, (Object)fooProperty.getValue());
        Object panelObject = panel.getObject();
        ReflectionUtils.setField((Object)panelObject, (String)"foo", (Object)2);
        panel.setObject(panelObject);
        JavaInfoTest.assertEquals((Object)1, (Object)fooProperty.getValue());
    }

    @Test
    public void test_setObject_SetterAccessor_notification() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private int foo = 1;", "  public int getFoo() {", "    return foo;", "  }", "  public void setFoo(int foo) {", "    this.foo = foo;", "  }", "}"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property fooProperty = panel.getPropertyByTitle("foo");
        JavaInfoTest.assertEquals((Object)1, (Object)fooProperty.getValue());
        Object panelObject = panel.getObject();
        ReflectionUtils.invokeMethod((Object)panelObject, (String)"setFoo(int)", (Object[])new Object[]{2});
        panel.setObject(panelObject);
        JavaInfoTest.assertEquals((Object)1, (Object)fooProperty.getValue());
    }

    @Test
    public void test_setObject_objectReadyValidator() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public int getFoo() {", "    return getComponentCount();", "  }", "  public void setFoo(int foo) {", "  }", "}"));
        JavaInfoTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='objectReadyValidator'>object.componentCount >= 2</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_3 = new JButton();", "      add(button_3);", "    }", "  }", "}");
        panel.refresh();
        Property fooProperty = panel.getPropertyByTitle("foo");
        JavaInfoTest.assertEquals((Object)2, (Object)fooProperty.getValue());
    }

    @Test
    public void test_getChildByObject() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        JavaInfoTest.assertSame((Object)panel, (Object)panel.getChildByObject(panel.getObject()));
        JavaInfoTest.assertSame((Object)button, (Object)panel.getChildByObject(button.getObject()));
        JavaInfoTest.assertNull((Object)panel.getChildByObject((Object)this));
        JavaInfoTest.assertNull((Object)panel.getChildByObject(null));
    }

    @Test
    public void test_getChildByObject_absoluteLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "  }", "}");
        panel.refresh();
        JavaInfoTest.assertSame((Object)panel, (Object)panel.getChildByObject(panel.getObject()));
        JavaInfoTest.assertNull((Object)panel.getChildByObject(null));
    }

    @Test
    public void test_refresh_afterCreate_script() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyButton extends JButton {", "}"));
        JavaInfoTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='refresh_afterCreate'>object.setEnabled(false)</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)JavaInfoTest.getJavaInfoByName("button");
        Component buttonObject = (Component)button.getObject();
        JavaInfoTest.assertFalse((boolean)buttonObject.isEnabled());
    }

    @Test
    public void test_refresh_afterCreate_script_placeholder() throws Exception {
        JavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler", "public class MyButton extends JButton {", "  public MyButton() {", "    throw new IllegalStateException('actual');", "  }", "  public void foo() {", "  }", "}"));
        JavaInfoTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='refresh_afterCreate'>System.out.println(0); object.foo(); System.out.println(1);</parameter>", "  </parameters>", "</component>"));
        JavaInfoTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)JavaInfoTest.getJavaInfoByName("button");
        JavaInfoTest.assertTrue((boolean)button.isPlaceholder());
    }
}

