/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import javax.swing.JButton;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ExposedPropertyCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse_0() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        ExposedPropertyCreationSupportTest.assertEquals((long)1L, (long)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ExposedPropertyCreationSupportTest.assert_creation((JavaInfo)frame);
        ExposedPropertyCreationSupport creationSupport = (ExposedPropertyCreationSupport)contentPane.getCreationSupport();
        ExposedPropertyCreationSupportTest.assertEquals((Object)frame.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        ExposedPropertyCreationSupportTest.assertSame((Object)frame, (Object)creationSupport.getHostJavaInfo());
        ExposedPropertyCreationSupportTest.assertEquals((Object)"getContentPane", (Object)creationSupport.getMethod().getName());
        ExposedPropertyCreationSupportTest.assertFalse((boolean)creationSupport.canReorder());
        ExposedPropertyCreationSupportTest.assertFalse((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_parse_1() throws Exception {
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/TitlePanel.java", this.getTestSource("public class TitlePanel extends JPanel {", "  private final JLabel m_titleLabel;", "  private final JPanel m_container;", "  public TitlePanel() {", "    setLayout(new BorderLayout());", "    {", "      m_titleLabel = new JLabel();", "      m_titleLabel.setOpaque(true);", "      m_titleLabel.setBackground(Color.ORANGE);", "      m_titleLabel.setText('Title');", "      m_titleLabel.setHorizontalAlignment(SwingConstants.CENTER);", "      add(m_titleLabel, BorderLayout.NORTH);", "    }", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "  public JPanel getContainer() {", "    return m_container;", "  }", "  public Component getNullComponent() {", "    return null;", "  }", "}"));
        ExposedPropertyCreationSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  public Test() {", "    TitlePanel titlePanel = new TitlePanel();", "    getContentPane().add(titlePanel, BorderLayout.CENTER);", "    {", "      JButton button = new JButton('JButton on exposed container');", "      titlePanel.getContainer().add(button);", "    }", "  }", "}");
        ExposedPropertyCreationSupportTest.assert_isCleanHierarchy((JavaInfo)frame);
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {/getContentPane().add(titlePanel, BorderLayout.CENTER)/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: test.TitlePanel} {local-unique: titlePanel} {/new TitlePanel()/ /getContentPane().add(titlePanel, BorderLayout.CENTER)/ /titlePanel.getContainer()/}", "      {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "      {method: public javax.swing.JPanel test.TitlePanel.getContainer()} {property} {/titlePanel.getContainer().add(button)/}", "        {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "        {new: javax.swing.JButton} {local-unique: button} {/new JButton('JButton on exposed container')/ /titlePanel.getContainer().add(button)/}");
        ExposedPropertyCreationSupportTest.assert_creation((JavaInfo)frame);
    }

    @Test
    public void test_parse_2() throws Exception {
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/PanelExpose.java", this.getTestSource("public class PanelExpose extends JPanel {", "  private final JLabel m_label;", "  private final JPanel m_container;", "  private final JButton m_button;", "  private final JCheckBox m_check;", "  public PanelExpose() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "      m_container.setLayout(null);", "      {", "        m_button = new JButton('Button');", "        m_container.add(m_button);", "        m_button.setBounds(10, 10, 200, 30);", "      }", "      {", "        m_check = new JCheckBox();", "        m_container.add(m_check);", "        m_check.setBounds(10, 50, 200, 30);", "      }", "    }", "    {", "      m_label = new JLabel('Label');", "      add(m_label, BorderLayout.NORTH);", "    }", "  }", "  public JLabel getLabel() {", "    return m_label;", "  }", "  public JPanel getContainer() {", "    return m_container;", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "  public JCheckBox getCheck() {", "    return m_check;", "  }", "}"));
        ExposedPropertyCreationSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    PanelExpose titlePanel = new PanelExpose();", "    getContentPane().add(titlePanel, BorderLayout.CENTER);", "    {", "      JButton button = new JButton('JButton on exposed container');", "      titlePanel.getContainer().add(button);", "      button.setBounds(10, 100, 300, 40);", "    }", "  }", "}");
        ExposedPropertyCreationSupportTest.assert_isCleanHierarchy((JavaInfo)frame);
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {/getContentPane().add(titlePanel, BorderLayout.CENTER)/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: test.PanelExpose} {local-unique: titlePanel} {/new PanelExpose()/ /getContentPane().add(titlePanel, BorderLayout.CENTER)/ /titlePanel.getContainer()/}", "      {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "      {method: public javax.swing.JPanel test.PanelExpose.getContainer()} {property} {/titlePanel.getContainer().add(button)/}", "        {implicit-layout: absolute} {implicit-layout} {}", "        {method: public javax.swing.JButton test.PanelExpose.getButton()} {property} {}", "        {method: public javax.swing.JCheckBox test.PanelExpose.getCheck()} {property} {}", "        {new: javax.swing.JButton} {local-unique: button} {/new JButton('JButton on exposed container')/ /titlePanel.getContainer().add(button)/ /button.setBounds(10, 100, 300, 40)/}", "      {method: public javax.swing.JLabel test.PanelExpose.getLabel()} {property} {}");
        ExposedPropertyCreationSupportTest.assert_creation((JavaInfo)frame);
    }

    @Test
    public void test_parse_3() throws Exception {
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/PanelExpose.java", this.getTestSource("public class PanelExpose extends JPanel {", "  private final JPanel m_container;", "  private final JButton m_button;", "  public PanelExpose() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "      m_container.setLayout(null);", "      {", "        m_button = new JButton('Button');", "        m_container.add(m_button);", "        m_button.setBounds(10, 10, 200, 30);", "      }", "    }", "  }", "  public JPanel getContainer() {", "    return m_container;", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        ExposedPropertyCreationSupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends PanelExpose {", "  public Test() {", "    getButton().setText('foo');", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: test.PanelExpose} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {method: public javax.swing.JPanel test.PanelExpose.getContainer()} {property} {}", "    {implicit-layout: absolute} {implicit-layout} {}", "    {method: public javax.swing.JButton test.PanelExpose.getButton()} {property} {/getButton().setText('foo')/}");
    }

    @Test
    public void test_parse_getExposedWhileCreateItsContainer() throws Exception {
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  private final JButton m_button = new JButton();", "  public MyContainer() {", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  private final MyContainer m_container;", "  public MyPanel() {", "    m_container = createContainer();", "    add(m_container);", "  }", "  public JButton getButton() {", "    return m_container.getButton();", "  }", "  protected abstract MyContainer createContainer();", "}"));
        ExposedPropertyCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected MyContainer createContainer() {", "    return new MyContainer();", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyContainer} {empty} {/new MyContainer()/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {method: public javax.swing.JButton test.MyContainer.getButton()} {property} {}", "  {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        this.refresh();
        ExposedPropertyCreationSupportTest.assertNoErrors(this.m_lastParseInfo);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        ExposedPropertyCreationSupportTest.assertEquals((Object)"method: public javax.swing.JButton test.MyPanel.getButton()", (Object)button.getCreationSupport().toString());
        ExposedPropertyCreationSupportTest.assertInstanceOf(JButton.class, button.getObject());
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo frame = this.parseContainer("public final class Test extends JFrame {", "  public Test() {", "    getContentPane().setEnabled(false);", "    setTitle('My frame');", "    //", "    JButton button = new JButton();", "    getContentPane().add(button);", "  }", "}");
        ExposedPropertyCreationSupportTest.assertEquals((long)1L, (long)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ExposedPropertyCreationSupportTest.assertTrue((boolean)contentPane.canDelete());
        contentPane.delete();
        this.assertEditor("public final class Test extends JFrame {", "  public Test() {", "    setTitle('My frame');", "  }", "}");
        ExposedPropertyCreationSupportTest.assertFalse((boolean)contentPane.isDeleted());
        ExposedPropertyCreationSupportTest.assertTrue((boolean)contentPane.getChildrenComponents().isEmpty());
    }

    @Test
    public void test_setContentPane_addDirectly() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class Test extends JFrame {", "  Test() {", "    JPanel panel = new JPanel();", "    setContentPane(panel);", "    panel.add(new JButton('My button'));", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setContentPane(panel)/}", "  {new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/ /setContentPane(panel)/ /panel.add(new JButton('My button'))/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/panel.add(new JButton('My button'))/}");
        ExposedPropertyCreationSupportTest.assertFalse((boolean)ExposedPropertyCreationSupport.isReplacementForExposed((JavaInfo)frame));
        ContainerInfo customContentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ExposedPropertyCreationSupportTest.assertTrue((boolean)ExposedPropertyCreationSupport.isReplacementForExposed((JavaInfo)customContentPane));
        customContentPane.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class Test extends JFrame {", "  Test() {", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_setContentPane_addUsingGetter() throws Exception {
        this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class Test extends JFrame {", "  Test() {", "    setContentPane(new JPanel());", "    getContentPane().add(new JButton());", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setContentPane(new JPanel())/}", "  {new: javax.swing.JPanel} {empty} {/setContentPane(new JPanel())/ /getContentPane().add(new JButton())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/getContentPane().add(new JButton())/}");
        this.refresh();
        ExposedPropertyCreationSupportTest.assertNoErrors(this.m_lastParseInfo);
    }

    @Test
    public void test_decorateIcon() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    getContentPane().add(new Container());", "  }", "}");
        ExposedPropertyCreationSupportTest.assertEquals((long)1L, (long)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ContainerInfo container = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ExposedPropertyCreationSupportTest.assertSame((Object)contentPane.getDescription(), (Object)container.getDescription());
        ExposedPropertyCreationSupportTest.assertSame((Object)container.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)container));
        ExposedPropertyCreationSupportTest.assertNotSame((Object)contentPane.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)contentPane));
    }

    @Test
    public void test_isDirect_true() throws Exception {
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private final JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        ExposedPropertyCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExposedPropertyCreationSupport creationSupport = (ExposedPropertyCreationSupport)button.getCreationSupport();
        ExposedPropertyCreationSupportTest.assertTrue((boolean)creationSupport.isDirect());
    }

    @Test
    public void test_isDirect_false() throws Exception {
        ExposedPropertyCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private final JButton m_button = new JButton();", "  public MyPanel() {", "    JPanel inner = new JPanel();", "    add(inner);", "    inner.add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        ExposedPropertyCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedPropertyCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExposedPropertyCreationSupport creationSupport = (ExposedPropertyCreationSupport)button.getCreationSupport();
        ExposedPropertyCreationSupportTest.assertFalse((boolean)creationSupport.isDirect());
    }
}

