/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.util.MorphingSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;
import org.mockito.Mockito;

public class MorphingSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_validate_noAssociationMethod() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addChild(Component component) {", "    add(component);", "  }", "}"));
        MorphingSupportTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MorphingSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addChild'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    myPanel.addChild(new JButton());", "  }", "}");
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JPanel.class, null);
        String message = MorphingSupportTest.validate((JavaInfo)myPanel, morphingTarget);
        MorphingSupportTest.assertNotNull((Object)message);
    }

    @Test
    public void test_validate_hasMethod_notAssociation() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addChild(Component component) {", "    add(component);", "  }", "}"));
        MorphingSupportTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MorphingSupportTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add'>", "      <parameter type='java.awt.Component' child='false'/>", "    </method>", "  </methods>", "</component>"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPanel myPanel = new JPanel();", "    add(myPanel);", "    myPanel.add(new JButton());", "  }", "}");
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        Class<?> targetClass = this.m_lastLoader.loadClass("test.MyPanel");
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(targetClass, null);
        String message = MorphingSupportTest.validate((JavaInfo)myPanel, morphingTarget);
        MorphingSupportTest.assertNotNull((Object)message);
    }

    @Test
    public void test_morph_removeMethodInvocations() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JLabel());", "    //", "    JButton button = new JButton();", "    button.setText('text');", "    button.setDefaultCapable(true);", "    add(button);", "    //", "    add(new JLabel());", "  }", "}");
        MorphingSupportTest.assertEquals((long)3L, (long)panel.getChildrenComponents().size());
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JTextField.class, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertEquals((long)3L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JLabel());", "    //", "    JTextField button = new JTextField();", "    button.setText('text');", "    add(button);", "    //", "    add(new JLabel());", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(1);
        MorphingSupportTest.assertEquals((Object)"{new: javax.swing.JTextField} {local-unique: button} {/button.setText(\"text\")/ /add(button)/ /new JTextField()/}", (Object)result.toString());
        MorphingSupportTest.assertSame(JTextField.class, (Object)result.getDescription().getComponentClass());
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JTextField()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        MorphingSupportTest.assertSame((Object)result, (Object)variable.getJavaInfo());
        InvocationChildAssociation association = (InvocationChildAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(button)", (Object)association.getSource());
        panel.refresh();
    }

    @Test
    public void test_morph_removeFieldAssignments() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public int m_value;", "}"));
        MorphingSupportTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.m_value = 1;", "    add(button);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JButton.class, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: button} {/add(button)/ /new JButton()/}", (Object)result.toString());
        MorphingSupportTest.assertSame(JButton.class, (Object)result.getDescription().getComponentClass());
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JButton()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        InvocationChildAssociation association = (InvocationChildAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(button)", (Object)association.getSource());
    }

    @Test
    public void test_morph_useConstructorWithSameArguments() throws Exception {
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('My text');", "    add(button);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines1);
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JLabel.class, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    JLabel button = new JLabel('My text');", "    add(button);", "  }", "}"};
        this.assertEditor(lines);
        MorphingSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JLabel} {local-unique: button} {/add(button)/ /new JLabel('My text')/}");
    }

    @Test
    public void test_morph_ConstructorParentAssociation() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        MorphingSupportTest.setFileContentSrc("test/MyButton2.java", this.getTestSource("public class MyButton2 extends JButton {", "  public MyButton2(Container container, boolean check) {", "  }", "}"));
        MorphingSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", MorphingSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        MorphingSupportTest.setFileContentSrc("test/MyButton2.wbp-component.xml", MorphingSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton2(%parent%, false)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "      <parameter type='boolean'/>", "    </constructor>", "  </constructors>", "</component>"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton(this);", "  }", "}");
        Class<?> targetClass = this.m_lastLoader.loadClass("test.MyButton2");
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(targetClass, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton2 button = new MyButton2(this, false);", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertEquals((Object)"{new: test.MyButton2} {local-unique: button} {/new MyButton2(this, false)/}", (Object)result.toString());
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new MyButton2(this, false)", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        ConstructorParentAssociation association = (ConstructorParentAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"new MyButton2(this, false)", (Object)association.getSource());
    }

    @Test
    public void test_morph_StaticFactoryCreationSupport() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = MyFactory.createButton();", "    add(button);", "  }", "}");
        Class<JTextField> targetClass = JTextField.class;
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(targetClass, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JTextField button = new JTextField();", "    add(button);", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JTextField()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        InvocationChildAssociation association = (InvocationChildAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(button)", (Object)association.getSource());
    }

    @Test
    public void test_morph_StaticFactoryCreationSupport_FactoryParentAssociation() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JButton createButton(Container parent) {", "    JButton button = new JButton();", "    parent.add(button);", "    return button;", "  }", "}"));
        MorphingSupportTest.setFileContentSrc("test/MyButton2.java", this.getTestSource("public class MyButton2 extends JButton {", "  public MyButton2(Container container) {", "  }", "}"));
        MorphingSupportTest.setFileContentSrc("test/MyButton2.wbp-component.xml", MorphingSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton2(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = MyFactory.createButton(this);", "  }", "}");
        Class<?> targetClass = this.m_lastLoader.loadClass("test.MyButton2");
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(targetClass, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton2 button = new MyButton2(this);", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new MyButton2(this)", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        ConstructorParentAssociation association = (ConstructorParentAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"new MyButton2(this)", (Object)association.getSource());
    }

    @Test
    public void test_morph_InstanceFactoryCreationSupport() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final MyFactory factory = new MyFactory();", "  public Test() {", "    JButton button = factory.createButton();", "    add(button);", "  }", "}");
        Class<JTextField> targetClass = JTextField.class;
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(targetClass, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertInstanceOf(InstanceFactoryCreationSupport.class, (Object)button.getCreationSupport());
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  private final MyFactory factory = new MyFactory();", "  public Test() {", "    JTextField button = new JTextField();", "    add(button);", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JTextField()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        InvocationChildAssociation association = (InvocationChildAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(button)", (Object)association.getSource());
    }

    @Test
    public void test_morph_keepChildren() throws Exception {
        MorphingSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MorphingSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    myPanel.add(new JButton());", "  }", "}");
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JPanel.class, null);
        MorphingSupportTest.morph((JavaInfo)myPanel, morphingTarget);
        MorphingSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JPanel myPanel = new JPanel();", "    add(myPanel);", "    myPanel.add(new JButton());", "  }", "}");
        myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertEquals((Object)"{new: javax.swing.JPanel} {local-unique: myPanel} {/add(myPanel)/ /myPanel.add(new JButton())/ /new JPanel()/}", (Object)myPanel.toString());
        MorphingSupportTest.assertSame(JPanel.class, (Object)myPanel.getDescription().getComponentClass());
        ConstructorCreationSupport creation = (ConstructorCreationSupport)myPanel.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JPanel()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)myPanel.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"myPanel", (Object)variable.getName());
        InvocationChildAssociation association = (InvocationChildAssociation)myPanel.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(myPanel)", (Object)association.getSource());
        List children = myPanel.getChildrenComponents();
        MorphingSupportTest.assertEquals((long)1L, (long)children.size());
        MorphingSupportTest.assertSame(JButton.class, (Object)((ComponentInfo)children.get(0)).getDescription().getComponentClass());
        panel.refresh();
    }

    @Test
    public void test_morph_lazyVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    add(getButton());", "  }", "  public JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        MorphingSupportTest.assertNoErrors((JavaInfo)panel);
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JTextField.class, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        this.assertEditor("public class Test extends JPanel {", "  private JTextField button;", "  public Test() {", "    add(getButton());", "  }", "  public JTextField getButton() {", "    if (button == null) {", "      button = new JTextField();", "    }", "    return button;", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertEquals((Object)"{new: javax.swing.JTextField} {lazy: button getButton()} {/button/ /add(getButton())/ /new JTextField()/}", (Object)result.toString());
        MorphingSupportTest.assertSame(JTextField.class, (Object)result.getDescription().getComponentClass());
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JTextField()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LazyVariableSupport variable = (LazyVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        InvocationChildAssociation association = (InvocationChildAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(getButton())", (Object)association.getSource());
        panel.refresh();
    }

    @Test
    public void test_morph_andSetProperty() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    JLabel component = new JLabel();", "    add(component);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JButton.class, null);
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.morph((JavaInfo)component, morphingTarget);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton component = new JButton();", "    add(component);", "  }", "}");
        ComponentInfo component2 = (ComponentInfo)panel.getChildrenComponents().get(0);
        component2.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton component = new JButton();", "    component.setEnabled(false);", "    add(component);", "  }", "}");
    }

    public static String validate(JavaInfo javaInfo, MorphingTargetDescription target) throws Exception {
        return MorphingSupport.validate((String)"java.awt.Component", (JavaInfo)javaInfo, (MorphingTargetDescription)target);
    }

    public static void morph(JavaInfo javaInfo, MorphingTargetDescription target) throws Exception {
        MorphingSupportTest.assertNull((Object)MorphingSupportTest.validate(javaInfo, target));
        MorphingSupport.morph((String)"java.awt.Component", (JavaInfo)javaInfo, (MorphingTargetDescription)target);
    }

    @Test
    public void test_actions() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MorphingSupportTest.assertNull((Object)MorphingSupportTest.getMorphManager((JavaInfo)panel));
        IMenuManager morphManager = MorphingSupportTest.getMorphManager((JavaInfo)button);
        MorphingSupportTest.assertNotNull((Object)MorphingSupportTest.findChildAction((IContributionManager)morphManager, "JCheckBox"));
        MorphingSupportTest.assertNotNull((Object)MorphingSupportTest.findChildAction((IContributionManager)morphManager, "JRadioButton"));
        MorphingSupportTest.assertNotNull((Object)MorphingSupportTest.findChildAction((IContributionManager)morphManager, "JLabel"));
        MorphingSupportTest.assertNotNull((Object)MorphingSupportTest.findChildAction((IContributionManager)morphManager, "&Subclass..."));
        MorphingSupportTest.assertNotNull((Object)MorphingSupportTest.findChildAction((IContributionManager)morphManager, "&Other..."));
        MorphingSupportTest.assertNull((Object)MorphingSupportTest.findChildAction((IContributionManager)morphManager, "JMenu"));
    }

    @Test
    public void test_actions_run() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager morphManager = MorphingSupportTest.getMorphManager((JavaInfo)button);
        IAction action = MorphingSupportTest.findChildAction((IContributionManager)morphManager, "JCheckBox");
        MorphingSupportTest.assertNotNull((Object)action);
        MorphingSupportTest.assertEquals((long)0L, (long)action.hashCode());
        MorphingSupportTest.assertEquals((Object)action, (Object)Mockito.mock(action.getClass()));
        MorphingSupportTest.assertFalse((boolean)action.equals((Object)this));
        action.run();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JCheckBox button = new JCheckBox();", "    add(button);", "  }", "}");
    }

    private static IMenuManager getMorphManager(JavaInfo component) throws Exception {
        MenuManager menuManager = MorphingSupportTest.getDesignerMenuManager();
        component.getBroadcastObject().addContextMenu(List.of(component), (ObjectInfo)component, (IMenuManager)menuManager);
        return MorphingSupportTest.findChildMenuManager((IContributionManager)menuManager, "Morph");
    }

    @Test
    public void test_morph_invoke_replaceChildren() throws Exception {
        final boolean[] invokeBeforeState = new boolean[1];
        final boolean[] parentBeforeState = new boolean[2];
        final boolean[] childrenBeforeState = new boolean[2];
        final boolean[] invokeAfterState = new boolean[1];
        final boolean[] parentAfterState = new boolean[2];
        final boolean[] childrenAfterState = new boolean[2];
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JLabel());", "    //", "    JButton button = new JButton();", "    button.setText('text');", "    button.setDefaultCapable(true);", "    add(button);", "    //", "    add(new JLabel());", "  }", "}");
        MorphingSupportTest.assertEquals((long)3L, (long)panel.getChildrenComponents().size());
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void replaceChildBefore(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                invokeBeforeState[0] = true;
                parentBeforeState[0] = oldChild.getParent() == parent;
                parentBeforeState[1] = newChild.getParent() == parent;
                childrenBeforeState[0] = parent.getChildren().contains(oldChild);
                childrenBeforeState[1] = parent.getChildren().contains(newChild);
            }

            public void replaceChildAfter(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                invokeAfterState[0] = true;
                parentAfterState[0] = oldChild.getParent() == parent;
                parentAfterState[1] = newChild.getParent() == parent;
                childrenAfterState[0] = parent.getChildren().contains(oldChild);
                childrenAfterState[1] = parent.getChildren().contains(newChild);
            }
        });
        MorphingTargetDescription morphingTarget = new MorphingTargetDescription(JTextField.class, null);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        MorphingSupportTest.assertFalse((boolean)invokeBeforeState[0]);
        MorphingSupportTest.assertFalse((boolean)invokeAfterState[0]);
        MorphingSupportTest.morph((JavaInfo)button, morphingTarget);
        MorphingSupportTest.assertTrue((boolean)invokeBeforeState[0]);
        MorphingSupportTest.assertTrue((boolean)parentBeforeState[0]);
        MorphingSupportTest.assertTrue((boolean)childrenBeforeState[0]);
        MorphingSupportTest.assertFalse((boolean)parentBeforeState[1]);
        MorphingSupportTest.assertFalse((boolean)childrenBeforeState[1]);
        MorphingSupportTest.assertTrue((boolean)invokeAfterState[0]);
        MorphingSupportTest.assertTrue((boolean)parentAfterState[0]);
        MorphingSupportTest.assertFalse((boolean)childrenAfterState[0]);
        MorphingSupportTest.assertTrue((boolean)parentAfterState[1]);
        MorphingSupportTest.assertTrue((boolean)childrenAfterState[1]);
        MorphingSupportTest.assertEquals((long)3L, (long)panel.getChildrenComponents().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JLabel());", "    //", "    JTextField button = new JTextField();", "    button.setText('text');", "    add(button);", "    //", "    add(new JLabel());", "  }", "}");
        ComponentInfo result = (ComponentInfo)panel.getChildrenComponents().get(1);
        MorphingSupportTest.assertEquals((Object)"{new: javax.swing.JTextField} {local-unique: button} {/button.setText(\"text\")/ /add(button)/ /new JTextField()/}", (Object)result.toString());
        MorphingSupportTest.assertSame(JTextField.class, (Object)result.getDescription().getComponentClass());
        ConstructorCreationSupport creation = (ConstructorCreationSupport)result.getCreationSupport();
        MorphingSupportTest.assertEquals((Object)"new JTextField()", (Object)this.m_lastEditor.getSource((ASTNode)creation.getCreation()));
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)result.getVariableSupport();
        MorphingSupportTest.assertEquals((Object)"button", (Object)variable.getName());
        InvocationChildAssociation association = (InvocationChildAssociation)result.getAssociation();
        MorphingSupportTest.assertEquals((Object)"add(button)", (Object)association.getSource());
        panel.refresh();
    }
}

