/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.gef;

import org.assertj.core.api.Assertions;
import org.eclipse.gef.EditPolicy;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.Test;

public class ChangeLayoutTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_removeSelectionPolicy_whenDropFillLayout() throws Exception {
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(0, 0, 100, 20);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        GraphicalEditPart buttonPart = this.canvas.getEditPart(button);
        EditPolicy policy = buttonPart.getEditPolicy((Object)"Selection Feedback");
        ChangeLayoutTest.assertNotNull((Object)policy);
        Assertions.assertThat((String)policy.toString()).contains(new CharSequence[]{"AbsoluteLayoutSelectionEditPolicy"});
        this.loadCreationTool("org.eclipse.swt.layout.FillLayout");
        this.canvas.create();
        this.canvas.target(composite).in(10, 10).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout(SWT.HORIZONTAL));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        policy = buttonPart.getEditPolicy((Object)"Selection Feedback");
        ChangeLayoutTest.assertNotNull((Object)policy);
        Assertions.assertThat((String)policy.toString()).contains(new CharSequence[]{"NonResizableSelectionEditPolicy"});
    }
}

