/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.rcp.model.forms.layout.column.ColumnLayoutDataInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.column.ColumnLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class ColumnLayoutTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_LayoutData_implicit() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ColumnLayoutDataInfo columnData = ColumnLayoutInfo.getColumnData((ControlInfo)button);
        columnData.setWidthHint(100);
        columnData.setHeightHint(200);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        ColumnLayoutData columnLayoutData = new ColumnLayoutData();", "        columnLayoutData.heightHint = 200;", "        columnLayoutData.widthHint = 100;", "        button.setLayoutData(columnLayoutData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_LayoutData_explicit() throws Exception {
        CompositeInfo shell = (CompositeInfo)this.parseJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new ColumnLayoutData(100, 200));", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ColumnLayoutDataInfo columnData = ColumnLayoutInfo.getColumnData((ControlInfo)button);
        ColumnLayoutTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)columnData.getCreationSupport());
    }

    @Test
    public void test_copyPaste() throws Exception {
        CompositeInfo shell = (CompositeInfo)this.parseJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new ColumnLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new ColumnLayoutData(100, 200));", "      }", "    }", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)composite);
        CompositeInfo newComposite = (CompositeInfo)memento.create((JavaInfo)shell);
        fillLayout.command_CREATE((ControlInfo)newComposite, null);
        memento.apply();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new ColumnLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new ColumnLayoutData(100, 200));", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new ColumnLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        {", "          button.setLayoutData(new ColumnLayoutData(100, 200));", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_selectionActions_1() throws Exception {
        CompositeInfo shell = (CompositeInfo)this.parseJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        ColumnLayoutData columnLayoutData = new ColumnLayoutData();", "        button.setLayoutData(columnLayoutData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        List<Object> actions = ColumnLayoutTest.getSelectionActions(new ObjectInfo[]{button});
        Assertions.assertThat(actions).hasSize(5);
        ColumnLayoutTest.assertNotNull((Object)ColumnLayoutTest.findAction(actions, "Left"));
        ColumnLayoutTest.assertNotNull((Object)ColumnLayoutTest.findAction(actions, "Center"));
        ColumnLayoutTest.assertNotNull((Object)ColumnLayoutTest.findAction(actions, "Right"));
        ColumnLayoutTest.assertNotNull((Object)ColumnLayoutTest.findAction(actions, "Fill"));
        ColumnLayoutTest.assertTrue((boolean)ColumnLayoutTest.findAction(actions, "Fill").isChecked());
        IAction leftAction = ColumnLayoutTest.findAction(actions, "Left");
        ColumnLayoutTest.assertFalse((boolean)leftAction.isChecked());
        leftAction.setChecked(true);
        leftAction.run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        ColumnLayoutData columnLayoutData = new ColumnLayoutData();", "        columnLayoutData.horizontalAlignment = ColumnLayoutData.LEFT;", "        button.setLayoutData(columnLayoutData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_selectionActions_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "  }", "}");
        shell.refresh();
        List<Object> actions = ColumnLayoutTest.getSelectionActions(new ObjectInfo[0]);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_selectionActions_3() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        List<Object> actions = ColumnLayoutTest.getSelectionActions(new ObjectInfo[]{shell, button});
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_convertFrom() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        ColumnLayoutData columnLayoutData = new ColumnLayoutData();", "        columnLayoutData.horizontalAlignment = ColumnLayoutData.RIGHT;", "        button.setLayoutData(columnLayoutData);", "      }", "    }", "  }", "}");
        shell.refresh();
        LayoutInfo gridLayout = (LayoutInfo)ColumnLayoutTest.createJavaInfo("org.eclipse.swt.layout.GridLayout");
        shell.setLayout(gridLayout);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_convertTo() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));", "    }", "  }", "}");
        shell.refresh();
        LayoutInfo columnLayout = (LayoutInfo)ColumnLayoutTest.createJavaInfo("org.eclipse.ui.forms.widgets.ColumnLayout");
        shell.setLayout(columnLayout);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new ColumnLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        ColumnLayoutData columnLayoutData = new ColumnLayoutData();", "        columnLayoutData.horizontalAlignment = ColumnLayoutData.RIGHT;", "        button.setLayoutData(columnLayoutData);", "      }", "    }", "  }", "}");
    }

    @Override
    protected String[] getTestSource_decorate(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"package test;", "import org.eclipse.swt.SWT;", "import org.eclipse.swt.widgets.*;", "import org.eclipse.swt.layout.*;", "import org.eclipse.ui.forms.widgets.*;"}, (String[])lines);
        return lines;
    }
}

