/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.rcp.model.forms.FormInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.MenuManagerInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class FormTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_properties() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        FormTest.assertNotNull((Object)form.getPropertyByTitle("Style"));
    }

    @Test
    public void test_getHead_getBody() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        List childrenControls = form.getChildrenControls();
        FormTest.assertEquals((long)2L, (long)childrenControls.size());
        CompositeInfo head = (CompositeInfo)childrenControls.get(0);
        FormTest.assertSame((Object)head, (Object)form.getHead());
        Assertions.assertThat((String)head.toString()).contains(new CharSequence[]{"getHead()"});
        FormTest.assertFalse((boolean)head.hasLayout());
        CompositeInfo body = (CompositeInfo)childrenControls.get(1);
        FormTest.assertSame((Object)body, (Object)form.getBody());
        Assertions.assertThat((String)body.toString()).contains(new CharSequence[]{"getBody()"});
        FormTest.assertTrue((boolean)body.hasLayout());
    }

    @Test
    public void test_head_getHeadClient() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.NONE);", "    {", "      Button buttonHead = new Button(form.getHead(), SWT.NONE);", "      form.setHeadClient(buttonHead);", "    }", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        CompositeInfo head = (CompositeInfo)form.getChildrenControls().get(0);
        List headControls = head.getChildrenControls();
        FormTest.assertEquals((long)1L, (long)headControls.size());
        ControlInfo buttonHead = (ControlInfo)headControls.get(0);
        FormTest.assertEquals((Object)"buttonHead", (Object)buttonHead.getVariableSupport().getName());
        FormTest.assertSame((Object)buttonHead, (Object)form.getHeadClient());
    }

    @Test
    public void test_head_setHeadClient() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.NONE);", "    form.setEnabled(true);", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        form.setHeadClient(button);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.NONE);", "    form.setEnabled(true);", "    {", "      Button button = new Button(form.getHead(), SWT.NONE);", "      form.setHeadClient(button);", "    }", "  }", "}");
        FormTest.assertSame((Object)button, (Object)form.getHeadClient());
    }

    @Test
    public void test_head_MoveOut() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.NONE);", "    {", "      Button button = new Button(form.getHead(), SWT.NONE);", "      form.setHeadClient(button);", "    }", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = form.getHeadClient();
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        rowLayout.command_MOVE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        FormTest.assertNull((Object)form.getHeadClient());
    }

    @Test
    public void test_head_MoveIn() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        form.setHeadClient(button);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Form form = new Form(this, SWT.NONE);", "    {", "      Button button = new Button(form.getHead(), SWT.NONE);", "      form.setHeadClient(button);", "    }", "  }", "}");
        FormTest.assertSame((Object)button, (Object)form.getHeadClient());
    }

    @Test
    public void test_exposedManagers_0() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.action.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        FormTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new Form(this, SWT.BORDER)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.ui.forms.widgets.Form} {local-unique: form} {/new Form(this, SWT.BORDER)/}", "    {method: public org.eclipse.jface.action.IToolBarManager org.eclipse.ui.forms.widgets.Form.getToolBarManager()} {property} {}", "    {method: public org.eclipse.jface.action.IMenuManager org.eclipse.ui.forms.widgets.Form.getMenuManager()} {property} {}", "    {method: public org.eclipse.swt.widgets.Composite org.eclipse.ui.forms.widgets.Form.getHead()} {property} {}", "    {method: public org.eclipse.swt.widgets.Composite org.eclipse.ui.forms.widgets.Form.getBody()} {property} {}", "      {implicit-layout: absolute} {implicit-layout} {}");
    }

    @Test
    public void test_exposedManagers_toolBarManager() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.action.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        FormTest.assertNotNull((Object)form.getToolBarManager());
        Rectangle bounds = form.getToolBarManager().getBounds();
        Assertions.assertThat((int)bounds.width).isLessThan(100);
    }

    @Test
    public void test_exposedManagers_menuManager() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.action.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "    form.setText('Some text');", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        MenuManagerInfo menuManager = form.getMenuManager();
        IMenuPopupInfo popupInfo = form.getMenuImpl(menuManager);
        FormTest.assertSame((Object)menuManager, (Object)popupInfo.getModel());
        Rectangle bounds = popupInfo.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(10);
        Assertions.assertThat((int)bounds.height).isGreaterThan(10);
    }

    @Test
    public void test_exposedManagers_createAction() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.action.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        ActionInfo newAction = ActionContainerInfo.createNew((JavaInfo)shell);
        form.getToolBarManager().command_CREATE(newAction, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "public class Test extends Shell {", "  private Action action;", "  public Test() {", "    createActions();", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "    form.getToolBarManager().add(action);", "  }", "  private void createActions() {", "    {", "      action = new Action('New Action') {", "      };", "    }", "  }", "}");
    }

    @Test
    public void test_FormToolkit_decorateFormHeading() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private FormToolkit m_toolkit = new FormToolkit(Display.getCurrent());", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        FormInfo form = (FormInfo)shell.getChildrenControls().get(0);
        IAction decorateAction = this.getDecorateAction(form);
        FormTest.assertFalse((boolean)decorateAction.isChecked());
        decorateAction.setChecked(true);
        decorateAction.run();
        this.assertEditor("public class Test extends Shell {", "  private FormToolkit m_toolkit = new FormToolkit(Display.getCurrent());", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "    m_toolkit.decorateFormHeading(form);", "  }", "}");
        decorateAction = this.getDecorateAction(form);
        FormTest.assertTrue((boolean)decorateAction.isChecked());
        decorateAction.setChecked(false);
        decorateAction.run();
        this.assertEditor("public class Test extends Shell {", "  private FormToolkit m_toolkit = new FormToolkit(Display.getCurrent());", "  public Test() {", "    setLayout(new FillLayout());", "    Form form = new Form(this, SWT.BORDER);", "  }", "}");
    }

    private IAction getDecorateAction(FormInfo form) throws Exception {
        MenuManager manager = FormTest.getDesignerMenuManager();
        form.getBroadcastObject().addContextMenu(List.of(form), (ObjectInfo)form, (IMenuManager)manager);
        IAction decorateAction = FormTest.findChildAction((IContributionManager)manager, "Decorate heading");
        FormTest.assertNotNull((Object)decorateAction);
        return decorateAction;
    }
}

