/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import javax.swing.JToolBar;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.VoidInvocationVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo;
import org.eclipse.wb.internal.swing.model.bean.ActionInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarSeparatorCreationSupport;
import org.eclipse.wb.internal.swing.model.component.JToolBarSeparatorInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class JToolBarTest
extends SwingModelTest {
    @Test
    public void test_association_Component() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "  }", "}");
        JToolBarTest.assertNoErrors((JavaInfo)panel);
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        JToolBarTest.assertEquals((long)1L, (long)bar.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        JToolBarTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_orientation_horizontal() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        JToolBarTest.assertTrue((boolean)bar.isHorizontal());
    }

    @Test
    public void test_orientation_vertical() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar(SwingConstants.VERTICAL);", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        JToolBarTest.assertFalse((boolean)bar.isHorizontal());
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = JToolBarTest.createJButton();
        bar.command_CREATE(newComponent, null);
        JToolBarTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_OUT() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo innerLayout = (FlowLayoutInfo)innerPanel.getLayout();
        innerLayout.move(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton('000');", "      bar.add(button);", "    }", "    {", "      JButton button = new JButton('111');", "      bar.add(button);", "    }", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_0 = (ComponentInfo)bar.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)bar.getChildrenComponents().get(1);
        bar.command_MOVE(button_1, button_0);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton('111');", "      bar.add(button);", "    }", "    {", "      JButton button = new JButton('000');", "      bar.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        bar.command_MOVE(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
    }

    @Test
    public void test_separator_Supports() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    //", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(0);
        JToolBarTest.assertEquals((Object)"bar.addSeparator()", (Object)separator.getAssociation().getSource());
        Statement associationStatement = separator.getAssociation().getStatement();
        VariableSupport variable = separator.getVariableSupport();
        JToolBarTest.assertInstanceOf(VoidInvocationVariableSupport.class, (Object)variable);
        JToolBarTest.assertEquals((Object)"void", (Object)variable.toString());
        JToolBarTest.assertEquals((Object)"addSeparator()", (Object)variable.getTitle());
        try {
            JToolBarTest.assertTarget(variable.getStatementTarget(), null, associationStatement, false);
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JToolBarTest.assertFalse((boolean)variable.hasName());
        try {
            variable.getName();
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variable.setName("can-not-set-name");
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variable.getReferenceExpression(null);
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variable.getAccessExpression(null);
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JToolBarTest.assertFalse((boolean)variable.canConvertLocalToField());
        try {
            variable.convertLocalToField();
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JToolBarTest.assertFalse((boolean)variable.canConvertFieldToLocal());
        try {
            variable.convertFieldToLocal();
            JToolBarTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JToolBarSeparatorCreationSupport creation = (JToolBarSeparatorCreationSupport)separator.getCreationSupport();
        JToolBarTest.assertEquals((Object)"void", (Object)creation.toString());
        JToolBarTest.assertSame((Object)((InvocationVoidAssociation)separator.getAssociation()).getInvocation(), (Object)creation.getNode());
        JToolBarTest.assertTrue((boolean)creation.canReorder());
        JToolBarTest.assertFalse((boolean)creation.canReparent());
        JToolBarTest.assertTrue((boolean)creation.canDelete());
        JToolBarTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)separator.getAssociation());
    }

    @Test
    public void test_addSeparator_noBeanProperties() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator(new Dimension(100, 50));", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo separator = (ComponentInfo)bar.getChildrenComponents().get(0);
        Object[] properties = separator.getProperties();
        Assertions.assertThat((Object[])properties).hasSize(1);
        JToolBarTest.assertNotNull((Object)PropertyUtils.getByPath((Property[])properties, (String)"Factory"));
        JToolBarTest.assertNotNull((Object)PropertyUtils.getByPath((Property[])properties, (String)"Factory/size"));
    }

    @Test
    public void test_separator_create() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorCreationSupport creationSupport = new JToolBarSeparatorCreationSupport((JavaInfo)bar);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JToolBar.Separator.class, (CreationSupport)creationSupport);
        bar.command_CREATE(separator, null);
        JToolBarTest.assertNotNull((Object)creationSupport.getInvocation());
        JToolBarTest.assertInstanceOf(VoidInvocationVariableSupport.class, (Object)separator.getVariableSupport());
        Association association = separator.getAssociation();
        JToolBarTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)association);
        JToolBarTest.assertEquals((Object)"bar.addSeparator()", (Object)association.getSource());
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
    }

    @Test
    public void test_separator_move() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(1);
        bar.command_MOVE((ComponentInfo)separator, button);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_separator_delete() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(0);
        JToolBarTest.assertTrue((boolean)separator.canDelete());
        separator.delete();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
    }

    private void createExternalAction() throws Exception {
        JToolBarTest.setFileContentSrc("test/ExternalAction.java", this.getTestSource("public class ExternalAction extends AbstractAction {", "  public ExternalAction() {", "    putValue(NAME, 'My name');", "    putValue(SHORT_DESCRIPTION, 'My short description');", "  }", "  public void actionPerformed(ActionEvent e) {", "  }", "}"));
        JToolBarTest.waitForAutoBuild();
    }

    @Test
    public void test_addAction_parse() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    //", "    JButton button = bar.add(action);", "    button.setEnabled(false);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarTest.assertEquals((long)1L, (long)bar.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        JToolBarTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)button, (String)"Factory/action"));
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)button.getCreationSupport();
        JToolBarTest.assertEquals((Object)"bar.add(action)", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        JToolBarTest.assertTrue((boolean)creationSupport.canReorder());
        JToolBarTest.assertFalse((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_addAction_generate() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        ComponentInfo newButton = bar.command_CREATE(action, null);
        this.assertEditor("class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = bar.add(action);", "    }", "  }", "}");
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)newButton.getCreationSupport();
        JToolBarTest.assertEquals((Object)"bar.add(action)", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        newButton.getProperties();
    }
}

