/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.GridLayout;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.GridLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Test;

public class GridLayoutTest
extends AbstractLayoutTest {
    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GridLayoutTest.setLayout(panel, GridLayout.class);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(1, 0, 0, 0));", "  }", "}");
    }

    @Test
    public void test_setColumns() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(2, 0));", "  }", "}");
        GridLayoutInfo layout = (GridLayoutInfo)panel.getLayout();
        layout.getPropertyByTitle("columns").setValue((Object)5);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(0, 5));", "  }", "}");
    }

    @Test
    public void test_Switching_fromNullLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JLabel label = new JLabel('New label');", "      label.setBounds(12, 50, 61, 15);", "      add(label);", "    }", "    {", "      JButton button = new JButton('New button');", "      button.setBounds(229, 82, 85, 27);", "      add(button);", "    }", "    {", "      JTextField textField = new JTextField();", "      textField.setBounds(85, 45, 140, 25);", "      add(textField);", "      textField.setColumns(10);", "    }", "    {", "      JComboBox comboBox = new JComboBox();", "      comboBox.setBounds(85, 12, 134, 27);", "      add(comboBox);", "    }", "  }", "}");
        panel.refresh();
        GridLayoutTest.setLayout(panel, GridLayout.class);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(0, 3, 0, 0));", "    {", "      JLabel label = new JLabel('');", "      add(label);", "    }", "    {", "      JComboBox comboBox = new JComboBox();", "      add(comboBox);", "    }", "    {", "      JLabel label = new JLabel('');", "      add(label);", "    }", "    {", "      JLabel label = new JLabel('New label');", "      add(label);", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField);", "      textField.setColumns(10);", "    }", "    {", "      JLabel label = new JLabel('');", "      add(label);", "    }", "    {", "      JLabel label = new JLabel('');", "      add(label);", "    }", "    {", "      JLabel label = new JLabel('');", "      add(label);", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
    }
}

