/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.jface.resource.FontRegistryInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontPropertyEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.swt.model.property.FontPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.junit.Test;

public class FontPropertyEditorTestRegistry
extends FontPropertyEditorTest {
    @Test
    public void test_info() throws Exception {
        this.createASTCompilationUnit("test", "MyRegistry.java", this.getTestSource("public class MyRegistry extends FontRegistry {", "  public static final String R_KEY = '_r_key_';", "  public MyRegistry() {", "    put(R_KEY, new FontData[]{new FontData('Courier New', 14, SWT.NONE)});", "  }", "}"));
        FontPropertyEditorTestRegistry.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "  }", "}");
        shell.refresh();
        List children = shell.getChildren(RegistryContainerInfo.class);
        FontPropertyEditorTestRegistry.assertEquals((long)1L, (long)children.size());
        RegistryContainerInfo containerInfo = (RegistryContainerInfo)children.get(0);
        FontPropertyEditorTestRegistry.assertSame((Object)containerInfo, (Object)RegistryContainerInfo.get((JavaInfo)shell));
        List fonts = containerInfo.getChildren(FontRegistryInfo.class);
        FontPropertyEditorTestRegistry.assertEquals((long)1L, (long)fonts.size());
        FontRegistryInfo fontRegistryInfo = (FontRegistryInfo)fonts.get(0);
        List keyFields = fontRegistryInfo.getKeyFields();
        FontPropertyEditorTestRegistry.assertEquals((long)1L, (long)keyFields.size());
        KeyFieldInfo keyFieldInfo = (KeyFieldInfo)keyFields.get(0);
        FontPropertyEditorTestRegistry.assertEquals((Object)"R_KEY", (Object)keyFieldInfo.keyName);
        FontPropertyEditorTestRegistry.assertEquals((Object)"_r_key_", (Object)keyFieldInfo.keyValue);
        FontPropertyEditorTestRegistry.assertNull((Object)keyFieldInfo.value);
    }

    @Test
    public void test_value() throws Exception {
        this.createASTCompilationUnit("test", "MyRegistry.java", this.getTestSource("public class MyRegistry extends FontRegistry {", "  public static final String R_KEY = '_r_key_';", "  public MyRegistry() {", "    put(R_KEY, new FontData[]{new FontData('Courier New', 14, SWT.NONE)});", "  }", "}"));
        FontPropertyEditorTestRegistry.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "    setFont(registry.get(MyRegistry.R_KEY));", "  }", "}");
        shell.refresh();
        FontPropertyEditorTestRegistry.assertNoErrors((JavaInfo)shell);
        Property property = shell.getPropertyByTitle("font");
        FontPropertyEditorTestRegistry.assertEquals((Object)"registry - R_KEY", (Object)PropertyEditorTestUtils.getText(property));
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
        FontPropertyEditorTestRegistry.assertEquals((Object)"new org.eclipse.swt.graphics.Font(null, \"Courier New\", 14, org.eclipse.swt.SWT.NORMAL)", (Object)PropertyEditorTestUtils.getClipboardSource(property));
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
        FontPropertyEditorTestRegistry.assertEquals((Object)FontPropertyEditor.getInvocationSource((JavaInfo)shell, (String)"Courier New", (int)14, (String)"org.eclipse.swt.SWT.NORMAL"), (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }

    @Test
    public void test_value_bold() throws Exception {
        this.createASTCompilationUnit("test", "MyRegistry.java", this.getTestSource("public class MyRegistry extends FontRegistry {", "  public static final String R_KEY = '_r_key_';", "  public MyRegistry() {", "    put(R_KEY, new FontData[]{new FontData('Courier New', 14, SWT.NONE)});", "  }", "}"));
        FontPropertyEditorTestRegistry.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "    setFont(registry.getBold(MyRegistry.R_KEY));", "  }", "}");
        shell.refresh();
        FontPropertyEditorTestRegistry.assertNoErrors((JavaInfo)shell);
        Property property = shell.getPropertyByTitle("font");
        FontPropertyEditorTestRegistry.assertEquals((Object)"registry - R_KEY(b)", (Object)PropertyEditorTestUtils.getText(property));
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
        FontPropertyEditorTestRegistry.assertEquals((Object)"new org.eclipse.swt.graphics.Font(null, \"Courier New\", 14, org.eclipse.swt.SWT.BOLD)", (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }

    @Test
    public void test_value_italic() throws Exception {
        this.createASTCompilationUnit("test", "MyRegistry.java", this.getTestSource("public class MyRegistry extends FontRegistry {", "  public static final String R_KEY = '_r_key_';", "  public MyRegistry() {", "    put(R_KEY, new FontData[]{new FontData('Courier New', 14, SWT.NONE)});", "  }", "}"));
        FontPropertyEditorTestRegistry.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "    setFont(registry.getItalic(MyRegistry.R_KEY));", "  }", "}");
        shell.refresh();
        FontPropertyEditorTestRegistry.assertNoErrors((JavaInfo)shell);
        Property property = shell.getPropertyByTitle("font");
        FontPropertyEditorTestRegistry.assertEquals((Object)"registry - R_KEY(i)", (Object)PropertyEditorTestUtils.getText(property));
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
        FontPropertyEditorTestRegistry.assertEquals((Object)"new org.eclipse.swt.graphics.Font(null, \"Courier New\", 14, org.eclipse.swt.SWT.ITALIC)", (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }
}

