/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.lang.reflect.TypeVariable;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.util.GenericTypeResolverJavaInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class GenericTypeResolverJavaInfoTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_hasTypeArgument() throws Exception {
        GenericTypeResolverJavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyButton<T> extends JButton {", "}"));
        GenericTypeResolverJavaInfoTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<String> button = new MyButton<String>();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)GenericTypeResolverJavaInfoTest.getJavaInfoByName("button");
        GenericTypeResolverJavaInfo resolver = new GenericTypeResolverJavaInfo((JavaInfo)button);
        Class buttonClass = button.getDescription().getComponentClass();
        TypeVariable typeVariable = buttonClass.getTypeParameters()[0];
        GenericTypeResolverJavaInfoTest.assertEquals((Object)"java.lang.String", (Object)resolver.resolve(typeVariable));
    }

    @Test
    public void test_hasTypeArgument_java7() throws Exception {
        GenericTypeResolverJavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyButton<T> extends JButton {", "}"));
        GenericTypeResolverJavaInfoTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<String> button = new MyButton<>();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)GenericTypeResolverJavaInfoTest.getJavaInfoByName("button");
        GenericTypeResolverJavaInfo resolver = new GenericTypeResolverJavaInfo((JavaInfo)button);
        Class buttonClass = button.getDescription().getComponentClass();
        TypeVariable typeVariable = buttonClass.getTypeParameters()[0];
        GenericTypeResolverJavaInfoTest.assertEquals((Object)"java.lang.String", (Object)resolver.resolve(typeVariable));
    }

    @Test
    public void test_noTypeArgument_hasBounds() throws Exception {
        GenericTypeResolverJavaInfoTest.setFileContentSrc("test/MyModel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyModel {", "}"));
        GenericTypeResolverJavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler", "public class MyButton<T extends MyModel> extends JButton {", "}"));
        GenericTypeResolverJavaInfoTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)GenericTypeResolverJavaInfoTest.getJavaInfoByName("button");
        GenericTypeResolverJavaInfo resolver = new GenericTypeResolverJavaInfo((JavaInfo)button);
        Class buttonClass = button.getDescription().getComponentClass();
        TypeVariable typeVariable = buttonClass.getTypeParameters()[0];
        GenericTypeResolverJavaInfoTest.assertEquals((Object)"test.MyModel", (Object)resolver.resolve(typeVariable));
    }

    @Test
    public void test_noTypeArgument_noBounds() throws Exception {
        GenericTypeResolverJavaInfoTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyButton<T> extends JButton {", "}"));
        GenericTypeResolverJavaInfoTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)GenericTypeResolverJavaInfoTest.getJavaInfoByName("button");
        GenericTypeResolverJavaInfo resolver = new GenericTypeResolverJavaInfo((JavaInfo)button);
        Class buttonClass = button.getDescription().getComponentClass();
        TypeVariable typeVariable = buttonClass.getTypeParameters()[0];
        GenericTypeResolverJavaInfoTest.assertEquals((Object)"java.lang.Object", (Object)resolver.resolve(typeVariable));
    }
}

