/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util.generic;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class CopyPropertyTopTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_copyExisting() throws Exception {
        CopyPropertyTopTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(String text) {", "    setText(text);", "  }", "}"));
        CopyPropertyTopTest.setFileContentSrc("test/MyButton.wbp-component.xml", CopyPropertyTopTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='copyPropertyTop from=Constructor/text to=MyButtonText'/>", "  </parameters>", "</component>"));
        CopyPropertyTopTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton('My text'));", "  }", "}");
        panel.refresh();
        CopyPropertyTopTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("MyButtonText");
        CopyPropertyTopTest.assertNotNull((Object)property);
        CopyPropertyTopTest.assertSame((Object)PropertyCategory.NORMAL, (Object)property.getCategory());
        CopyPropertyTopTest.assertEquals((Object)"My text", (Object)property.getValue());
        CopyPropertyTopTest.assertSame((Object)property, (Object)button.getPropertyByTitle("MyButtonText"));
    }

    @Test
    public void test_ignoreNotExisting() throws Exception {
        CopyPropertyTopTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        CopyPropertyTopTest.setFileContentSrc("test/MyButton.wbp-component.xml", CopyPropertyTopTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='copyPropertyTop from=noSuchProperty to=anyTitle'/>", "  </parameters>", "</component>"));
        CopyPropertyTopTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}");
        panel.refresh();
        CopyPropertyTopTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("anyTitle");
        CopyPropertyTopTest.assertNull((Object)property);
    }
}

