/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.editor.DesignerEditorTestCase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class SwingGefTest
extends DesignerEditorTestCase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        SwingGefTest.configureDefaults(ToolkitProvider.DESCRIPTION);
        if (m_testProject == null) {
            SwingGefTest.do_projectCreate();
            this.configureNewProject();
        }
        SwingGefTest.configureForTest();
    }

    protected void configureNewProject() throws Exception {
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        SwingGefTest.configureDefaults();
        super.tearDown();
    }

    public static void configureForTest() {
        IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
        preferences.setValue("templateLayoutName", "${defaultName}");
    }

    public static void configureDefaults() {
        IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
        preferences.setToDefault("templateLayoutName");
    }

    protected ContainerInfo openContainer(String lines) throws Exception {
        return (ContainerInfo)this.openEditor(lines);
    }

    protected <T extends ObjectInfo> T openEditor(String lines) throws Exception {
        ICompilationUnit unit = this.createModelCompilationUnit("test", "Test.java", this.getTestSource(lines));
        this.openDesign(unit);
        return (T)this.m_contentJavaInfo;
    }

    protected void assertEditor(String lines) {
        AstEditor editor = EditorState.getActiveJavaInfo().getEditor();
        SwingGefTest.assertEditor(this.getTestSource(lines), editor);
    }

    public String getTestSource(String source) {
        return "package test;\nimport java.awt.*;\nimport java.awt.event.*;\nimport javax.swing.*;\nimport javax.swing.border.*;\n%s\n".formatted(source);
    }

    protected final void prepareBox() throws Exception {
        this.prepareBox(100, 50);
    }

    protected final void prepareBox(int width, int height) throws Exception {
        SwingGefTest.setFileContentSrc("test/Box.java", this.getTestSource("public class Box extends JLabel {\n\tpublic Box() {\n\t\tsetPreferredSize(new Dimension(%d, %d));\n\t\tsetBackground(Color.PINK);\n\t\tsetOpaque(true);\n\t}\n\tpublic Box(String text) {\n\t\tthis();\n\t\tsetText(text);\n\t}\n}".formatted(width, height)));
        SwingGefTest.waitForAutoBuild();
    }

    protected final ComponentInfo loadCreationBox() throws Exception {
        return (ComponentInfo)this.loadCreationTool("test.Box");
    }

    protected final ComponentInfo loadButton() throws Exception {
        return (ComponentInfo)this.loadCreationTool("javax.swing.JButton", "empty");
    }

    protected final ComponentInfo loadButtonWithText() throws Exception {
        return (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
    }
}

