/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.internal.core.eval.ExecutionFlowProvider;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExecutionFlowUtilsTest
extends AbstractEngineTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            ExecutionFlowUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getExecutionFlowConstructor_single() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tpublic Test() {\n\t}\n}");
        ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)ExecutionFlowUtils.getExecutionFlowConstructor((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_getExecutionFlowConstructor_noConstructors() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\t// filler\n}");
        ExecutionFlowUtilsTest.assertSame(null, (Object)ExecutionFlowUtils.getExecutionFlowConstructor((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_getExecutionFlowConstructor_multipleWithTag() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int a) {\n\t}\n\t/**\n\t * @wbp.parser.constructor\n\t */\n\tpublic Test(double b) {\n\t}\n}");
        ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)ExecutionFlowUtils.getExecutionFlowConstructor((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_getExecutionFlowConstructor_multipleNoTag_noDefault() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int a) {\n\t}\n\tpublic Test(double b) {\n\t}\n}");
        try {
            ExecutionFlowUtils.getExecutionFlowConstructor((TypeDeclaration)typeDeclaration);
            ExecutionFlowUtilsTest.fail();
        }
        catch (MultipleConstructorsError e) {
            ExecutionFlowUtilsTest.assertSame(null, (Object)e.getEditor());
            ExecutionFlowUtilsTest.assertSame(null, (Object)e.getTypeDeclaration());
        }
    }

    @Test
    public void test_getExecutionFlowConstructor_multipleNoTag_useExecutionFlowProvider() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            Class<ExecutionFlowProvider_forDefaultConstructor> providerClass = ExecutionFlowProvider_forDefaultConstructor.class;
            testBundle.addClass(providerClass);
            testBundle.addExtension("org.eclipse.wb.core.java.executionFlowProviders", "<provider class='" + providerClass.getName() + "'/>");
            testBundle.install();
            try {
                TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t}\n\tpublic Test(int a) {\n\t}\n}");
                ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)ExecutionFlowUtils.getExecutionFlowConstructor((TypeDeclaration)typeDeclaration));
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_getExecutionFlow_entryPoint_forConstructor_0() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int a) {\n\t}\n\tpublic Test(double b) {\n\t}\n}");
        ExecutionFlowUtilsTest.assertSame(null, (Object)ExecutionFlowUtils.getExecutionFlow_entryPoint((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_getExecutionFlow_entryPoint_forConstructor_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\t/**\n\t * @wbp.parser.entryPoint\n\t */\n\tpublic Test(int a) {\n\t}\n\tpublic Test(double b) {\n\t}\n}");
        ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)ExecutionFlowUtils.getExecutionFlow_entryPoint((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_getExecutionFlow_entryPoint_forConstructor_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int a) {\n\t}\n\t/**\n\t * @wbp.parser.entryPoint\n\t */\n\tpublic Test(double b) {\n\t}\n}");
        ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)ExecutionFlowUtils.getExecutionFlow_entryPoint((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_getExecutionFlow_entryPoint_forMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\t/**\n\t * @wbp.parser.entryPoint\n\t */\n\tpublic void foo() {\n\t}\n\tpublic void bar() {\n\t}\n}");
        ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)ExecutionFlowUtils.getExecutionFlow_entryPoint((TypeDeclaration)typeDeclaration));
    }

    @Test
    public void test_visit_empty() throws Exception {
        String code = "Test() {} void root() {}";
        String[] expectedNodes = new String[]{};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_statement() throws Exception {
        String code = "Test() {} void root() {int value = 5;}";
        String[] expectedNodes = new String[]{"int value = 5;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_TryStatement() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  try {", "    int value = 5;", "  } catch (Exception e) {", "  } catch (Throwable e) {", "  }", "}");
        String[] expectedNodes = new String[]{"int value = 5;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_fields() throws Exception {
        String code = "int m_value = 1; Test() {} void root() {int value = 5;} private String m_string;";
        String[] expectedNodes = new String[]{"int m_value = 1;", "private String m_string;", "int value = 5;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_fields2() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("Test() {", "}", "void root() {", "  int value = 5;", "}", "int m_value = 1;", "private String m_string;");
        String[] expectedNodes = new String[]{"int m_value = 1;", "private String m_string;", "int value = 5;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_initializers_static() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("// filler filler filler filler filler", "static int foo;", "static {", "  int bar;", "}", "void root() {", "}");
        String[] expectedNodes = new String[]{"static int foo;", "int bar;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_initializers_instance() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("// filler filler filler filler filler", "int foo;", "{", "  int bar;", "}", "void root() {", "}");
        String[] expectedNodes = new String[]{"int foo;", "int bar;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_statements() throws Exception {
        String code = "Test() {} void root() {System.out.println();  System.exit(0);}";
        String[] expectedNodes = new String[]{"System.out.println();", "System.exit(0);"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_single_constructor() throws Exception {
        String code = "int f; Test() {System.out.println();} void root() {System.exit(0);}";
        String[] expectedNodes = new String[]{"int f;", "System.out.println();", "System.exit(0);"};
        this.check_visitNodes(code, expectedNodes, "<init>", "root()");
    }

    @Test
    public void test_visit_noConstructor() throws Exception {
        String code = "int f; void root() {System.exit(0);}";
        String[] expectedNodes = new String[]{"int f;", "System.exit(0);"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_noConstructor_withStatic() throws Exception {
        String code = "static int s; int f; void root() {System.exit(0);}";
        String[] expectedNodes = new String[]{"static int s;", "int f;", "System.exit(0);"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_local_constructor() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("public static void main(String[] args) {", "  Test test = new Test();", "}", "public Test() {", "  System.out.println();", "}");
        String[] expectedNodes = new String[]{"System.out.println();", "Test test = new Test();"};
        this.check_visitNodes(code, expectedNodes, "main(java.lang.String[])");
    }

    @Test
    public void test_visit_localMethod_fromMain() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("private int field;", "public static void main(String[] args) {", "  Test test = new Test();", "  test.open();", "}", "public Test() {", "  int a;", "}", "public void open() {", "  field = 0;", "}");
        String[] expectedNodes = new String[]{"private int field;", "int a;", "Test test = new Test();", "field = 0;", "test.open();"};
        this.check_visitNodes(code, expectedNodes, "main(java.lang.String[])");
    }

    @Test
    public void test_visit_several_constructors_good() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("/** @wbp.parser.constructor */", "Test() {", "  System.out.println();", "}", "Test(int foo) {", "}", "void root() {", "  System.exit(0);", "}");
        String[] expectedNodes = new String[]{"System.out.println();", "System.exit(0);"};
        this.check_visitNodes(code, expectedNodes, "<init>", "root()");
    }

    @Test
    public void test_visit_constructorInTheMiddle() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("private int f;", "Test() {", "  int a;", "}", "void createContents() {", "  int b;", "  f = 1;", "}");
        String[] expectedNodes = new String[]{"private int f;", "int b;", "f = 1;", "int a;"};
        this.check_visitNodes(code, expectedNodes, "createContents()", "<init>");
    }

    @Test
    public void test_visit_static() throws Exception {
        String code = "Test() {System.out.println();} static int m_value; static void root() {}";
        String[] expectedNodes = new String[]{"static int m_value;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_constructor() throws Exception {
        String code = "Test() {System.out.println();}";
        String[] expectedNodes = new String[]{"System.out.println();"};
        this.check_visitNodes(code, expectedNodes, "<init>()");
    }

    @Test
    public void test_visit_ifStatement_genericExpression() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  int a;", "  if (1 == 2) {", "    int b;", "  } else {", "    int c;", "  }", "}");
        String[] expectedNodes = new String[]{"int a;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_true() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  if (true) {", "    int a;", "  } else {", "    int b;", "  }", "}");
        String[] expectedNodes = new String[]{"int a;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_false() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  if (false) {", "    int a;", "  } else {", "    int b;", "  }", "}");
        String[] expectedNodes = new String[]{"int b;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_Beans_isDesignTime() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  if (java.beans.Beans.isDesignTime()) {", "    int a;", "  } else {", "    int b;", "  }", "}");
        String[] expectedNodes = new String[]{"int a;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_Beans_isDesignTime_not() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  if (!java.beans.Beans.isDesignTime()) {", "    int a;", "  } else {", "    int b;", "  }", "}");
        String[] expectedNodes = new String[]{"int b;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_local_isDesignTime() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  if (isDesignTime()) {", "    int a;", "  } else {", "    int b;", "  }", "}", "private static boolean isDesignTime() {", "  return false;", "}");
        String[] expectedNodes = new String[]{"int a;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_local_isDesignTime_not() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  if (!isDesignTime()) {", "    int a;", "  } else {", "    int b;", "  }", "}", "private static boolean isDesignTime() {", "  return false;", "}");
        String[] expectedNodes = new String[]{"int b;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_ifStatement_lazy() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("Object lazy;", "Object getLazy() {", "  if (lazy == null) {", "    lazy = null;", "  }", "  return lazy;", "}");
        String[] expectedNodes = new String[]{"Object lazy;", "lazy = null;", "return lazy;"};
        this.check_visitNodes(code, expectedNodes, "getLazy()");
    }

    @Test
    public void test_visit_ifStatement_otherCondition() throws Exception {
        String code = "void root() {int a; if (1 == 2) {int b;}}";
        String[] expectedNodes = new String[]{"int a;"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_invocation() throws Exception {
        String code = "void root() {System.out.println(); foo();}  void foo() {System.exit(0);}";
        String[] expectedNodes = new String[]{"System.out.println();", "System.exit(0);", "foo();"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_invocation_recursion() throws Exception {
        String code = ExecutionFlowUtilsTest.getSourceDQ("void root() {", "  System.out.println(0);", "  foo();", "}", "void foo() {", "  System.out.println(1);", "  foo();", "}");
        String[] expectedNodes = new String[]{"System.out.println(0);", "System.out.println(1);", "foo();", "foo();"};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    private void check_visitNodes(String code, String[] expectedNodes, String ... methodSignatures) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration[] rootMethods = new MethodDeclaration[methodSignatures.length];
        int i = 0;
        while (i < methodSignatures.length) {
            String methodSignature = methodSignatures[i];
            rootMethods[i] = methodSignature.equals("<init>") ? ExecutionFlowUtils.getExecutionFlowConstructor((TypeDeclaration)typeDeclaration) : AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
            ++i;
        }
        this.check_visitNodes(rootMethods, expectedNodes);
    }

    private void check_visitNodes(MethodDeclaration[] rootMethods, final String[] expectedNodes) {
        final int[] indexWrapper = new int[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(rootMethods);
        ExecutionFlowUtils.visit((ExecutionFlowUtils.VisitingContext)new ExecutionFlowUtils.VisitingContext(true), (ExecutionFlowDescription)flowDescription, (ExecutionFlowUtils.ExecutionFlowFrameVisitor)new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

            public void postVisit(ASTNode node) {
                if (node instanceof Statement && !(node instanceof Block)) {
                    this.assertNextNode(node);
                }
            }

            public void endVisit(FieldDeclaration node) {
                this.assertNextNode((ASTNode)node);
            }

            private void assertNextNode(ASTNode node) {
                String actualNodeSource;
                try {
                    actualNodeSource = ExecutionFlowUtilsTest.this.m_lastEditor.getSource(node);
                }
                catch (Throwable e) {
                    throw ReflectionUtils.propagate((Throwable)e);
                }
                int n = indexWrapper[0];
                indexWrapper[0] = n + 1;
                int index = n;
                ExecutionFlowUtilsTest.assertEquals((Object)expectedNodes[index], (Object)actualNodeSource);
            }
        });
        ExecutionFlowUtilsTest.assertEquals((int)expectedNodes.length, (int)indexWrapper[0]);
    }

    @Test
    public void test_visit_abstractMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public abstract class Test {\n\tpublic void root() {\n\t\tsomeAbstractMethod();\n\t}\n\tprotected abstract void someAbstractMethod();\n}");
        MethodDeclaration rootMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration[] rootMethods = new MethodDeclaration[]{rootMethod};
        String[] expectedNodes = new String[]{"someAbstractMethod();"};
        this.check_visitNodes(rootMethods, expectedNodes);
    }

    @Test
    public void test_visit_ConstructorInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tthis(false);\n\t}\n\tpublic Test(boolean b) {\n\t\tint a;\n\t}\n}");
        MethodDeclaration rootMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration[] rootMethods = new MethodDeclaration[]{rootMethod};
        String[] expectedNodes = new String[]{"int a;", "this(false);"};
        this.check_visitNodes(rootMethods, expectedNodes);
    }

    @Test
    public void test_visit_ConstructorInvocation_visitArgumentsFirst() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtilsTest.getSource("public class Test {", "  public Test() {", "    this(false);", "  }", "  public Test(boolean parameter) {", "  }", "}"));
        MethodDeclaration rootMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration[] rootMethods = new MethodDeclaration[]{rootMethod};
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(rootMethods);
        final ArrayList nodes = new ArrayList();
        ExecutionFlowUtils.visit((ExecutionFlowUtils.VisitingContext)new ExecutionFlowUtils.VisitingContext(true), (ExecutionFlowDescription)flowDescription, (ExecutionFlowUtils.ExecutionFlowFrameVisitor)new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

            public void postVisit(ASTNode node) {
                boolean isSingleStatement;
                boolean bl = isSingleStatement = node instanceof Statement && !(node instanceof Block);
                if (isSingleStatement || node instanceof Expression) {
                    nodes.add(ExecutionFlowUtilsTest.this.m_lastEditor.getSource(node));
                }
            }
        });
        Assertions.assertThat(nodes).containsExactly((Object[])new String[]{"false", "parameter", "this(false);"});
    }

    @Test
    public void test_visit_unwrapInvocationTargetException() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtilsTest.getSource("public class Test {", "  public Test() {", "    System.out.println();", "  }", "}"));
        MethodDeclaration rootMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration[] rootMethods = new MethodDeclaration[]{rootMethod};
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(rootMethods);
        final Error exception = new Error();
        try {
            ExecutionFlowUtils.visit((ExecutionFlowUtils.VisitingContext)new ExecutionFlowUtils.VisitingContext(true), (ExecutionFlowDescription)flowDescription, (ExecutionFlowUtils.ExecutionFlowFrameVisitor)new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

                public void endVisit(SimpleName node) {
                    if (node.toString().equals("println")) {
                        throw exception;
                    }
                }
            });
        }
        catch (Throwable e) {
            ExecutionFlowUtilsTest.assertSame((Object)exception, (Object)e);
        }
    }

    @Test
    public void test_visit_AnonymousClassDeclaration_noVisit() throws Exception {
        String threadCode = "new Thread(new Runnable() {public void run() {int a;}});";
        String code = "void root() {" + threadCode + "}";
        String[] expectedNodes = new String[]{threadCode};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_AnonymousClassDeclaration_withInvocation() throws Exception {
        String threadCode = "new Thread(new Runnable() {public void run() {foo();}});";
        String code = "void root() {" + threadCode + "} void foo() {int b;}";
        String[] expectedNodes = new String[]{threadCode};
        this.check_visitNodes(code, expectedNodes, "root()");
    }

    @Test
    public void test_visit_AnonymousClassDeclaration_withInvocation_doVisit() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            Class<ExecutionFlowProvider_RunnableInThread> providerClass = ExecutionFlowProvider_RunnableInThread.class;
            testBundle.addClass(providerClass);
            testBundle.addExtension("org.eclipse.wb.core.java.executionFlowProviders", "<provider class='" + providerClass.getName() + "'/>");
            testBundle.install();
            try {
                String threadCode = "new Thread(new Runnable() {public void run() {foo();}});";
                String code = "void root() {" + threadCode + "} void foo() {int b;}";
                String[] expectedNodes = new String[]{"int b;", "foo();", threadCode};
                this.check_visitNodes(code, expectedNodes, "root()");
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_findLastAssignment_variable() throws Exception {
        String code = "void root() {int value = 0; System.out.println(value);}";
        this.check_findLastAssignment(code, 1, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)((VariableDeclarationStatement)statements[0]).fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_variable_recursiveAssignment_leftSide() throws Exception {
        String code = "void root() {int value; value = 1;}";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"root()");
        ExecutionFlowUtilsTest.assertNotNull((Object)rootMethod);
        MethodDeclaration[] rootMethods = new MethodDeclaration[]{rootMethod};
        List statementsList = DomGenerics.statements((Block)rootMethod.getBody());
        Statement[] statements = statementsList.toArray(new Statement[statementsList.size()]);
        Assignment assignment = (Assignment)((ExpressionStatement)statements[1]).getExpression();
        SimpleName variable = (SimpleName)assignment.getLeftHandSide();
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(rootMethods), (ASTNode)variable);
        ExecutionFlowUtilsTest.assertSame((Object)assignment, (Object)lastAssignment);
    }

    @Test
    public void test_findLastAssignment_variable_recursiveAssignment_rightSide() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\t// filler filler filler\n\tvoid root() {\n\t\tint value = 0;\n\t\tvalue = value + 1;\n\t}\n}");
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"root()");
        ASTNode variable = this.m_lastEditor.getEnclosingNode("value + 1");
        VariableDeclarationFragment expected = (VariableDeclarationFragment)this.m_lastEditor.getEnclosingNode("value = 0").getParent();
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod}), (ASTNode)variable);
        ExecutionFlowUtilsTest.assertNotNull((Object)lastAssignment);
        ExecutionFlowUtilsTest.assertSame((Object)expected, (Object)lastAssignment);
    }

    @Test
    public void test_findLastAssignment_variable_reassign() throws Exception {
        String code = "void root() {int value = 0; value = 1; System.out.println(value);}";
        this.check_findLastAssignment(code, 2, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return ((ExpressionStatement)statements[1]).getExpression();
            }
        });
    }

    @Test
    public void test_findLastAssignment_variable_reassign2() throws Exception {
        String code = "void root() {int value; value = 0; System.out.println(value); value = 1; System.out.println(value);}";
        this.check_findLastAssignment(code, 4, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return ((ExpressionStatement)statements[3]).getExpression();
            }
        });
    }

    @Test
    public void test_findLastAssignment_variable_reassign_later() throws Exception {
        String code = "void root() {int value = 0; System.out.println(value); value = 1;}";
        this.check_findLastAssignment(code, 1, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)((VariableDeclarationStatement)statements[0]).fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_variable_sameInDifferentMethod() throws Exception {
        String code = "void root() {int value = 0; foo(); System.out.println(value);} void foo() {int value = 1;}";
        this.check_findLastAssignment(code, 2, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)((VariableDeclarationStatement)statements[0]).fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration() throws Exception {
        String code = "int value = 0; void root() {System.out.println(value);}";
        this.check_findLastAssignment(code, 0, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)typeDeclaration.getFields()[0].fragments().get(0);
            }
        });
    }

    @Test
    public void test_FieldDeclaration_this_1() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", ExecutionFlowUtilsTest.getSourceDQ("package test;", "class Test {", "  int value;", "  void root() {", "    int value = 0;", "    value = 1;", "    System.out.println(this.value);", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"root()");
        ExpressionStatement statement = (ExpressionStatement)rootMethod.getBody().statements().get(2);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        ASTNode variable = (ASTNode)invocation.arguments().get(0);
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod}), (ASTNode)variable);
        ExecutionFlowUtilsTest.assertNotNull((Object)lastAssignment);
        ExecutionFlowUtilsTest.assertSame((Object)typeDeclaration.getFields()[0], (Object)lastAssignment.getParent());
        List references = ExecutionFlowUtils.getReferences((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod}), (ASTNode)variable);
        String[] expectedReferences = new String[]{"int value;", "System.out.println(this.value);"};
        ExecutionFlowUtilsTest.assertEquals((int)expectedReferences.length, (int)references.size());
        int i = 0;
        while (i < references.size()) {
            ASTNode reference = (ASTNode)references.get(i);
            String expectedReference = expectedReferences[i];
            String actualReference = this.m_lastEditor.getSource(reference.getParent().getParent());
            ExecutionFlowUtilsTest.assertEquals((Object)expectedReference, (Object)actualReference);
            ++i;
        }
    }

    @Test
    public void test_FieldDeclaration_this_2() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", ExecutionFlowUtilsTest.getSourceDQ("package test;", "class Test {", "  int value;", "  void root() {", "    int value = 0;", "    value = 1;", "    this.value = 2;", "    System.out.println(value);", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        MethodDeclaration rootMeethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"root()");
        ExpressionStatement statement = (ExpressionStatement)rootMeethod.getBody().statements().get(3);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        ASTNode variable = (ASTNode)invocation.arguments().get(0);
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{rootMeethod}), (ASTNode)variable);
        ExecutionFlowUtilsTest.assertNotNull((Object)lastAssignment);
        ExpressionStatement statement2 = (ExpressionStatement)rootMeethod.getBody().statements().get(1);
        ExecutionFlowUtilsTest.assertSame((Object)statement2.getExpression(), (Object)lastAssignment);
        List references = ExecutionFlowUtils.getReferences((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{rootMeethod}), (ASTNode)variable);
        String[] expectedReferences = new String[]{"int value = 0;", "value = 1;", "System.out.println(value);"};
        ExecutionFlowUtilsTest.assertEquals((int)expectedReferences.length, (int)references.size());
        int i = 0;
        while (i < references.size()) {
            SimpleName reference = (SimpleName)references.get(i);
            String expectedReference = expectedReferences[i];
            String actualReference = this.m_lastEditor.getSource(reference.getParent().getParent());
            ExecutionFlowUtilsTest.assertEquals((Object)expectedReference, (Object)actualReference);
            ++i;
        }
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_noValue() throws Exception {
        String code = "int value; void root() {System.out.println(value);}";
        this.check_findLastAssignment(code, 0, (typeDeclaration, methodDeclaration, statements) -> (ASTNode)typeDeclaration.getFields()[0].fragments().get(0));
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_variable_thisMethod() throws Exception {
        String code = "int value = 0; void root() {int value = 1; System.out.println(value);}";
        this.check_findLastAssignment(code, 1, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)((VariableDeclarationStatement)statements[0]).fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_reassign_thisMethod() throws Exception {
        String code = "int value = 0; void root() {value = 1; System.out.println(value);}";
        this.check_findLastAssignment(code, 1, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return ((ExpressionStatement)statements[0]).getExpression();
            }
        });
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_reassign_otherMethod() throws Exception {
        String code = "int value = 0; void root() {foo(); System.out.println(value);} void foo() {value = 1;}";
        this.check_findLastAssignment(code, 1, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                Statement statement = (Statement)typeDeclaration.getMethods()[1].getBody().statements().get(0);
                return ((ExpressionStatement)statement).getExpression();
            }
        });
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_reassign_otherMethod2() throws Exception {
        String code = "int value = 0; void root() {System.out.println(value); foo();} void foo() {value = 1;}";
        this.check_findLastAssignment(code, 0, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)typeDeclaration.getFields()[0].fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_reassign_otherMethod3() throws Exception {
        String code = "int value = 0; void foo() {value = 1;} void root() {System.out.println(value); foo();}";
        this.check_findLastAssignment(code, 0, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)typeDeclaration.getFields()[0].fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_FieldDeclaration_reassign_otherMethod4() throws Exception {
        String code = "int value = 0; void root() {foo(); System.out.println(value);} void foo() {int value = 1;}";
        this.check_findLastAssignment(code, 1, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)typeDeclaration.getFields()[0].fragments().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_parameters() throws Exception {
        String code = "void root(int value) {System.out.println(value);}";
        this.check_findLastAssignment(code, "root(int)", 0, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)methodDeclaration.parameters().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_parameterName() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo(int value) {\n\t}\n}");
        MethodDeclaration fooMethod = typeDeclaration.getMethods()[0];
        SingleVariableDeclaration valueDeclaration = (SingleVariableDeclaration)DomGenerics.parameters((MethodDeclaration)fooMethod).get(0);
        SimpleName valueName = valueDeclaration.getName();
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{fooMethod});
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)valueName);
        ExecutionFlowUtilsTest.assertSame((Object)valueDeclaration, (Object)lastAssignment);
        ExecutionFlowUtilsTest.assertTrue((boolean)ExecutionFlowUtils.hasVariableStamp((ASTNode)valueName));
    }

    @Test
    public void test_findLastAssignment_parameterName_inBinaryFlowMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t}\n\tpublic void foo(int value) {\n\t}\n}");
        MethodDeclaration constructorMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration fooMethod = typeDeclaration.getMethods()[1];
        SingleVariableDeclaration valueDeclaration = (SingleVariableDeclaration)DomGenerics.parameters((MethodDeclaration)fooMethod).get(0);
        SimpleName valueName = valueDeclaration.getName();
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{constructorMethod});
        flowDescription.addBinaryFlowMethodBefore((Statement)constructorMethod.getBody(), fooMethod);
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)valueName);
        ExecutionFlowUtilsTest.assertSame((Object)valueDeclaration, (Object)lastAssignment);
        ExecutionFlowUtilsTest.assertTrue((boolean)ExecutionFlowUtils.hasVariableStamp((ASTNode)valueName));
    }

    @Test
    public void test_findLastAssignment_parameters_hide_field() throws Exception {
        String code = "int value = 1; void root(int value) {System.out.println(value);}";
        this.check_findLastAssignment(code, "root(int)", 0, new I_findLastAssignment(){

            @Override
            public ASTNode getExpected(TypeDeclaration typeDeclaration, MethodDeclaration methodDeclaration, Statement[] statements) {
                return (ASTNode)methodDeclaration.parameters().get(0);
            }
        });
    }

    @Test
    public void test_findLastAssignment_SuperConstructorInvocation_argument() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test extends java.util.ArrayList {\n\tpublic Test(int size) {\n\t\tsuper(size);\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        SingleVariableDeclaration sizeDeclaration = (SingleVariableDeclaration)DomGenerics.parameters((MethodDeclaration)methodDeclaration).get(0);
        SimpleName sizeArgument = (SimpleName)this.m_lastEditor.getEnclosingNode("size);");
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration});
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)sizeArgument);
        ExecutionFlowUtilsTest.assertSame((Object)sizeDeclaration, (Object)lastAssignment);
    }

    @Test
    public void test_findLastAssignment_followConstructorInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test extends java.util.ArrayList {\n\tpublic Test() {\n\t\tthis(0);\n\t}\n\tpublic Test(int size) {\n\t\tSystem.out.println(size);\n\t}\n}");
        MethodDeclaration entryPointConstructor = typeDeclaration.getMethods()[0];
        MethodDeclaration sizeConstructor = typeDeclaration.getMethods()[1];
        SingleVariableDeclaration sizeDeclaration = (SingleVariableDeclaration)DomGenerics.parameters((MethodDeclaration)sizeConstructor).get(0);
        SimpleName sizeArgument = (SimpleName)this.m_lastEditor.getEnclosingNode("size);");
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{entryPointConstructor}), (ASTNode)sizeArgument);
        ExecutionFlowUtilsTest.assertSame((Object)sizeDeclaration, (Object)lastAssignment);
    }

    @Test
    public void test_findLastAssignment_notInFlow_initializedFromConstructor() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", ExecutionFlowUtilsTest.getSourceDQ("package test;", "public class Test {", "  int m_field;", "  public Test() {", "    m_field = 5;", "  }", "  private void disconnectedMethod() {", "    System.out.println(m_field);", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)DomGenerics.types((CompilationUnit)compilationUnit).get(0);
        MethodDeclaration constructorMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration disconnectedMethod = typeDeclaration.getMethods()[1];
        Statement statement = (Statement)DomGenerics.statements((Block)constructorMethod.getBody()).get(0);
        Assignment expectedAssignment = (Assignment)((ExpressionStatement)statement).getExpression();
        Statement statement2 = (Statement)DomGenerics.statements((Block)disconnectedMethod.getBody()).get(0);
        MethodInvocation invocation = (MethodInvocation)((ExpressionStatement)statement2).getExpression();
        ASTNode variable = (ASTNode)DomGenerics.arguments((MethodInvocation)invocation).get(0);
        ASTNode actualAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{constructorMethod}), (ASTNode)variable);
        ExecutionFlowUtilsTest.assertSame((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void test_findLastAssignment_notInFlow_initializedInField() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", ExecutionFlowUtilsTest.getSourceDQ("package test;", "public class Test {", "  int m_field = 5;", "  public Test() {", "  }", "  private void disconnectedMethod() {", "    System.out.println(m_field);", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)DomGenerics.types((CompilationUnit)compilationUnit).get(0);
        MethodDeclaration constructorMethod = typeDeclaration.getMethods()[0];
        MethodDeclaration disconnectedMethod = typeDeclaration.getMethods()[1];
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclaration expectedAssignment = (VariableDeclaration)DomGenerics.fragments((FieldDeclaration)fieldDeclaration).get(0);
        Statement statement = (Statement)DomGenerics.statements((Block)disconnectedMethod.getBody()).get(0);
        MethodInvocation invocation = (MethodInvocation)((ExpressionStatement)statement).getExpression();
        ASTNode variable = (ASTNode)DomGenerics.arguments((MethodInvocation)invocation).get(0);
        ASTNode actualAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{constructorMethod}), (ASTNode)variable);
        ExecutionFlowUtilsTest.assertSame((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void test_findLastAssignment_applicationPattern_noConstructor() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test {\n\tprivate JPanel shell;\n\tpublic static void main(String[] args) {\n\t\tTest app = new Test();\n\t\tapp.open();\n\t}\n\tpublic void open() {\n\t\tshell = new JPanel();\n\t\tSystem.out.println(shell);\n\t}\n}");
        MethodDeclaration entryPointConstructor = typeDeclaration.getMethods()[0];
        Assignment shellAssignment = (Assignment)this.m_lastEditor.getEnclosingNode("shell =").getParent();
        SimpleName shellArgument = (SimpleName)this.m_lastEditor.getEnclosingNode("shell);");
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPointConstructor});
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)shellArgument);
        ExecutionFlowUtilsTest.assertSame((Object)shellAssignment, (Object)lastAssignment);
    }

    @Test
    public void test_findLastAssignment_applicationPattern_withConstructor() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test {\n\tprivate JPanel shell;\n\tpublic static void main(String[] args) {\n\t\tTest app = new Test();\n\t\tapp.open();\n\t}\n\tpublic Test() {\n\t}\n\tpublic void open() {\n\t\tshell = new JPanel();\n\t\tSystem.out.println(shell);\n\t}\n}");
        MethodDeclaration entryPointConstructor = typeDeclaration.getMethods()[0];
        Assignment shellAssignment = (Assignment)this.m_lastEditor.getEnclosingNode("shell =").getParent();
        SimpleName shellArgument = (SimpleName)this.m_lastEditor.getEnclosingNode("shell);");
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPointConstructor});
        ASTNode lastAssignment = ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)shellArgument);
        ExecutionFlowUtilsTest.assertSame((Object)shellAssignment, (Object)lastAssignment);
    }

    private void check_findLastAssignment(String code, int variableStatementIndex, I_findLastAssignment helper) throws Exception {
        this.check_findLastAssignment(code, "root()", variableStatementIndex, helper);
    }

    private void check_findLastAssignment(String code, String methodSignature, int variableStatementIndex, I_findLastAssignment helper) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
        ExecutionFlowUtilsTest.assertNotNull((Object)rootMethod);
        MethodDeclaration[] rootMethods = new MethodDeclaration[]{rootMethod};
        List statementsList = DomGenerics.statements((Block)rootMethod.getBody());
        Statement[] statements = statementsList.toArray(new Statement[statementsList.size()]);
        ASTNode expectedAssignment = helper.getExpected(typeDeclaration, rootMethod, statements);
        SimpleName variable = (SimpleName)((MethodInvocation)((ExpressionStatement)statements[variableStatementIndex]).getExpression()).arguments().get(0);
        ExecutionFlowUtilsTest.assertSame((Object)expectedAssignment, (Object)ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)new ExecutionFlowDescription(rootMethods), (ASTNode)variable));
    }

    @Test
    public void test_findLastAssignment_cache() throws Exception {
        String code = "void root() {int value = 0; System.out.println(value);}";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"root()");
        ExecutionFlowUtilsTest.assertNotNull((Object)rootMethod);
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod});
        List statementsList = DomGenerics.statements((Block)rootMethod.getBody());
        Statement[] statements = statementsList.toArray(new Statement[statementsList.size()]);
        ASTNode expectedAssignment = (ASTNode)((VariableDeclarationStatement)statements[0]).fragments().get(0);
        SimpleName variable = (SimpleName)((MethodInvocation)((ExpressionStatement)statements[1]).getExpression()).arguments().get(0);
        ExecutionFlowUtilsTest.assertSame((Object)expectedAssignment, (Object)ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)variable));
        ExecutionFlowUtilsTest.assertSame((Object)expectedAssignment, (Object)ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)variable));
        rootMethod.getName().setIdentifier("root2");
        ExecutionFlowUtilsTest.assertSame((Object)expectedAssignment, (Object)ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)variable));
    }

    @Test
    public void test_getFinalExpression_1() throws Exception {
        this.check_getFinalExpression("555", new String[]{"package test;", "public class Test {", "  public Test() {", "    int a = !555;", "  }", "}"});
    }

    @Test
    public void test_getFinalExpression_2() throws Exception {
        this.check_getFinalExpression("555", new String[]{"package test;", "public class Test {", "  public Test() {", "    int a = 555;", "    System.out.println(!a);", "  }", "}"});
    }

    @Test
    public void test_getFinalExpression_3() throws Exception {
        this.check_getFinalExpression("555", new String[]{"package test;", "public class Test {", "  public Test() {", "    int a = 555;", "    int b = a;", "    System.out.println(!b);", "  }", "}"});
    }

    @Test
    public void test_getFinalExpression_4() throws Exception {
        this.check_getFinalExpression("555", new String[]{"package test;", "public class Test {", "  public Test() {", "    int a;", "    a = 555;", "    System.out.println(!a);", "  }", "}"});
    }

    @Test
    public void test_getFinalExpression_5() throws Exception {
        this.check_getFinalExpression("555", new String[]{"package test;", "public class Test {", "  private int a;", "  public Test() {", "    a = 555;", "    System.out.println(!a);", "  }", "}"});
    }

    private void check_getFinalExpression(String expectedSource, String[] lines) throws Exception {
        String source = ExecutionFlowUtilsTest.getSource(lines);
        int expressionPosition = source.indexOf(33);
        source = StringUtils.remove((String)source, (char)'!');
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", source);
        Expression expression = (Expression)AstNodeUtils.getEnclosingNode((ASTNode)typeDeclaration, (int)expressionPosition);
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{typeDeclaration.getMethods()[0]});
        Expression firstAssignment = ExecutionFlowUtils.getFinalExpression((ExecutionFlowDescription)flowDescription, (Expression)expression);
        ExecutionFlowUtilsTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getSource((ASTNode)firstAssignment));
    }

    @Test
    public void test_getAssignments_variable() throws Exception {
        String code = "void root() {int value = 0; System.out.println(value);}";
        String[] expected = new String[]{"value = 0"};
        this.check_getAssignments(code, 1, expected);
    }

    @Test
    public void test_getAssignments_variable2() throws Exception {
        String code = "void root() {int value = 0; value = 1; System.out.println(value);}";
        String[] expected = new String[]{"value = 0", "value = 1"};
        this.check_getAssignments(code, 2, expected);
    }

    @Test
    public void test_getAssignments_variable3() throws Exception {
        String code = "void root() {int value; value = 1; System.out.println(value);}";
        String[] expected = new String[]{"value = 1"};
        this.check_getAssignments(code, 2, expected);
    }

    @Test
    public void test_getAssignments_variable_call() throws Exception {
        String code = "void root() {int value = 0; foo(); System.out.println(value);} void foo() {int value = 2;}";
        String[] expected = new String[]{"value = 0"};
        this.check_getAssignments(code, 2, expected);
    }

    @Test
    public void test_getAssignments_variable_usingFieldAccess_inThisUnit() throws Exception {
        ExecutionFlowUtilsTest.setFileContentSrc("test/MyObject.java", ExecutionFlowUtilsTest.getSourceDQ("package test;", "public class MyObject {", "  public int m_value;", "}"));
        ExecutionFlowUtilsTest.waitForAutoBuild();
        String code = "void root() {int value = 0; System.out.println(value); new MyObject().m_value = 2;}";
        String[] expected = new String[]{"value = 0"};
        this.check_getAssignments(code, 1, expected);
    }

    @Test
    public void test_getAssignments_field() throws Exception {
        String code = "int value = 0; void root() {System.out.println(value);}";
        String[] expected = new String[]{"value = 0"};
        this.check_getAssignments(code, 0, expected);
    }

    @Test
    public void test_getAssignments_field_assign() throws Exception {
        String code = "int value = 0; void root() {value = 1; System.out.println(value);}";
        String[] expected = new String[]{"value = 0", "value = 1"};
        this.check_getAssignments(code, 1, expected);
    }

    @Test
    public void test_getAssignments_field_assign2() throws Exception {
        String code = "int value = 0; void root() {foo(); System.out.println(value);} void foo() {value = 1;}";
        String[] expected = new String[]{"value = 0", "value = 1"};
        this.check_getAssignments(code, 1, expected);
    }

    @Test
    public void test_getAssignments_field_hideVariable() throws Exception {
        String code = "int value = 0; void root() {int value = 1; System.out.println(value);}";
        String[] expected = new String[]{"value = 1"};
        this.check_getAssignments(code, 1, expected);
    }

    private void check_getAssignments(String code, int variableStatementIndex, String[] expectedAssignments) throws Exception {
        this.check_getAssignments(code, "root()", variableStatementIndex, expectedAssignments);
    }

    private void check_getAssignments(String code, String methodSignature, int variableStatementIndex, String[] expectedAssignments) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
        ExecutionFlowUtilsTest.assertNotNull((Object)rootMethod);
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod});
        List statementsList = DomGenerics.statements((Block)rootMethod.getBody());
        Statement[] statements = statementsList.toArray(new Statement[statementsList.size()]);
        SimpleName variable = (SimpleName)((MethodInvocation)((ExpressionStatement)statements[variableStatementIndex]).getExpression()).arguments().get(0);
        List actualAssignments = ExecutionFlowUtils.getAssignments((ExecutionFlowDescription)flowDescription, (ASTNode)variable);
        ExecutionFlowUtilsTest.assertNotNull((Object)actualAssignments);
        ExecutionFlowUtilsTest.assertEquals((int)expectedAssignments.length, (int)actualAssignments.size());
        int i = 0;
        while (i < expectedAssignments.length) {
            String expectedAssignment = expectedAssignments[i];
            String actualAssignment = this.m_lastEditor.getSource((ASTNode)actualAssignments.get(i));
            ExecutionFlowUtilsTest.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
            ++i;
        }
        ExecutionFlowUtilsTest.assertSame((Object)actualAssignments, (Object)ExecutionFlowUtils.getAssignments((ExecutionFlowDescription)flowDescription, (ASTNode)variable));
    }

    @Test
    public void test_getReferences_variable() throws Exception {
        String code = "void root() {int value = 0; System.out.println(value);}";
        String[] expected = new String[]{"value = 0", "System.out.println(value)"};
        this.check_getReferences(code, 1, expected);
    }

    @Test
    public void test_getReferences_field() throws Exception {
        String code = "int value = 0; void root() {value = 1; System.out.println(value);}";
        String[] expected = new String[]{"value = 0", "value = 1", "System.out.println(value)"};
        this.check_getReferences(code, 1, expected);
    }

    @Test
    public void test_getReferences_field_2() throws Exception {
        String code = "int value; void root() {value = 1; System.out.println(value);}";
        String[] expected = new String[]{"value", "value = 1", "System.out.println(value)"};
        this.check_getReferences(code, 1, expected);
    }

    @Test
    public void test_getReferences_field_3() throws Exception {
        String code = "int value; void root() {value = 1; System.out.println(value);} void foo() {value = 2;}";
        String[] expected = new String[]{"value", "value = 1", "System.out.println(value)", "value = 2"};
        this.check_getReferences(code, 1, expected);
    }

    @Test
    public void test_getReferences_field_4() throws Exception {
        String code = "void root() {System.out.println(value);} int value;";
        String[] expected = new String[]{"value", "System.out.println(value)"};
        this.check_getReferences(code, 0, expected);
    }

    @Test
    public void test_getReferences_field_inAnonymous() throws Exception {
        String code = ExecutionFlowUtilsTest.getSource("int value;", "void root() {", "  System.out.println(value);", "  new Object() {", "    public int hashCode() {", "      return value;", "    }", "  };", "}");
        String[] expected = new String[]{"value", "System.out.println(value)", "return value;"};
        this.check_getReferences(code, 0, expected);
    }

    @Test
    public void test_getReferences_field_usingThisObject() throws Exception {
        String code = ExecutionFlowUtilsTest.getSource("int value;", "void root() {", "  System.out.println(value);", "  new Object() {", "    public int hashCode() {", "      Test test = new Test();", "      return test.value;", "    }", "  };", "}");
        String[] expected = new String[]{"value", "System.out.println(value)", "test.value"};
        this.check_getReferences(code, 0, expected);
    }

    private void check_getReferences(String code, int variableStatementIndex, String[] expectedAssignments) throws Exception {
        this.check_getReferences(code, "root()", variableStatementIndex, expectedAssignments);
    }

    private void check_getReferences(String code, String methodSignature, int variableStatementIndex, String[] expectedReferences) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
        ExecutionFlowUtilsTest.assertNotNull((Object)rootMethod);
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod});
        List statementsList = DomGenerics.statements((Block)rootMethod.getBody());
        Statement[] statements = statementsList.toArray(new Statement[statementsList.size()]);
        SimpleName variable = (SimpleName)((MethodInvocation)((ExpressionStatement)statements[variableStatementIndex]).getExpression()).arguments().get(0);
        List actualReferences = ExecutionFlowUtils.getReferences((ExecutionFlowDescription)flowDescription, (ASTNode)variable);
        ExecutionFlowUtilsTest.assertNotNull((Object)actualReferences);
        ExecutionFlowUtilsTest.assertEquals((int)expectedReferences.length, (int)actualReferences.size());
        int i = 0;
        while (i < expectedReferences.length) {
            String expectedAssignment = expectedReferences[i];
            ASTNode actualReference = (ASTNode)actualReferences.get(i);
            String actualAssignment = this.m_lastEditor.getSource(actualReference.getParent());
            ExecutionFlowUtilsTest.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
            ++i;
        }
        ExecutionFlowUtilsTest.assertSame((Object)actualReferences, (Object)ExecutionFlowUtils.getReferences((ExecutionFlowDescription)flowDescription, (ASTNode)variable));
    }

    @Test
    public void test_getDeclaration_variable() throws Exception {
        String code = "void root() {int value = 0; System.out.println(value);}";
        this.check_getDeclaration(code, 1, "value = 0");
    }

    @Test
    public void test_getDeclaration_methodParameter() throws Exception {
        String code = "void root(int value) {System.out.println(value);}";
        this.check_getDeclaration(code, "root(int)", 0, "int value");
    }

    @Test
    public void test_getDeclaration_lazy() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tprivate Object lazy;\n\tprivate Object getLazy() {\n\t\tif (lazy == null) {\n\t\t\tlazy = new Object();\n\t\t}\n\t\treturn lazy;\n\t}\n\tpublic void root() {\n\t\tgetLazy();\n\t}\n}");
        VariableDeclaration expectedDeclaration = this.getNode("lazy;", VariableDeclaration.class);
        SimpleName variable = this.getNode("lazy = new", SimpleName.class);
        MethodDeclaration rootMethod = this.getNode("getLazy()", MethodDeclaration.class);
        ExecutionFlowUtilsTest.assertSame((Object)expectedDeclaration, (Object)ExecutionFlowUtils.getDeclaration((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod}), (ASTNode)variable));
    }

    @Test
    public void test_getDeclaration_methodParameter_direct() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void root(int value) {\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)methodDeclaration.parameters().get(0);
        ExecutionFlowUtilsTest.assertSame((Object)variableDeclaration, (Object)ExecutionFlowUtils.getDeclaration((ExecutionFlowDescription)new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration}), (ASTNode)variableDeclaration.getName()));
    }

    private void check_getDeclaration(String code, int variableStatementIndex, String expectedDeclaration) throws Exception {
        this.check_getDeclaration(code, "root()", variableStatementIndex, expectedDeclaration);
    }

    private void check_getDeclaration(String code, String methodSignature, int variableStatementIndex, String expectedDeclaration) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration rootMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
        ExecutionFlowUtilsTest.assertNotNull((Object)rootMethod);
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod});
        List statementsList = DomGenerics.statements((Block)rootMethod.getBody());
        Statement[] statements = statementsList.toArray(new Statement[statementsList.size()]);
        SimpleName variable = (SimpleName)((MethodInvocation)((ExpressionStatement)statements[variableStatementIndex]).getExpression()).arguments().get(0);
        VariableDeclaration declaration = ExecutionFlowUtils.getDeclaration((ExecutionFlowDescription)flowDescription, (ASTNode)variable);
        ExecutionFlowUtilsTest.assertEquals((Object)expectedDeclaration, (Object)this.m_lastEditor.getSource((ASTNode)declaration));
        ExecutionFlowUtilsTest.assertSame((Object)declaration, (Object)ExecutionFlowUtils.getDeclaration((ExecutionFlowDescription)flowDescription, (ASTNode)variable));
    }

    @Test
    public void test_noVariableInformationForDanglingNode() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint foo = 1;\n\t\tSystem.out.println(foo);\n\t}\n}");
        MethodDeclaration rootMethod = typeDeclaration.getMethods()[0];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{rootMethod});
        ASTNode fooNode = this.m_lastEditor.getEnclosingNode("foo)");
        VariableDeclaration declaration = ExecutionFlowUtils.getDeclaration((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode);
        ExecutionFlowUtilsTest.assertNotNull((Object)declaration);
        Assertions.assertThat((List)ExecutionFlowUtils.getReferences((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode)).containsOnly((Object[])new ASTNode[]{declaration.getName(), fooNode});
        Assertions.assertThat((List)ExecutionFlowUtils.getAssignments((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode)).containsOnly((Object[])new ASTNode[]{declaration});
        ExecutionFlowUtilsTest.assertEquals((Object)ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode), (Object)declaration);
        this.m_lastEditor.removeEnclosingStatement(fooNode);
        ExecutionFlowUtilsTest.assertNull((Object)ExecutionFlowUtils.getDeclaration((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode));
        Assertions.assertThat((List)ExecutionFlowUtils.getReferences((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode)).isEmpty();
        Assertions.assertThat((List)ExecutionFlowUtils.getAssignments((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode)).isEmpty();
        ExecutionFlowUtilsTest.assertNull((Object)ExecutionFlowUtils.getLastAssignment((ExecutionFlowDescription)flowDescription, (ASTNode)fooNode));
    }

    @Test
    public void test_getInvocations_ConstructorInvocation_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tthis(1);\n\t}\n\tpublic Test(int value) {\n\t}\n}");
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        List invocations = ExecutionFlowUtils.getInvocations((ExecutionFlowDescription)flowDescription, (MethodDeclaration)target);
        Assertions.assertThat((List)invocations).hasSize(1);
        ExecutionFlowUtilsTest.assertEquals((Object)"this(1);", (Object)this.m_lastEditor.getSource((ASTNode)invocations.get(0)));
    }

    @Test
    public void test_getInvocations_ConstructorInvocation_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tthis(false);\n\t}\n\tpublic Test(int value) {\n\t}\n\tpublic Test(boolean value) {\n\t}\n}");
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        List invocations = ExecutionFlowUtils.getInvocations((ExecutionFlowDescription)flowDescription, (MethodDeclaration)target);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_getInvocations_ClassInstanceCreation_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test(1);\n\t}\n\tpublic Test(int value) {\n\t}\n\tpublic static void main2() {\n\t\tTest test = new Test(2);\n\t}\n}");
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        List invocations = ExecutionFlowUtils.getInvocations((ExecutionFlowDescription)flowDescription, (MethodDeclaration)target);
        Assertions.assertThat((List)invocations).hasSize(1);
        ExecutionFlowUtilsTest.assertEquals((Object)"new Test(1)", (Object)this.m_lastEditor.getSource((ASTNode)invocations.get(0)));
    }

    @Test
    public void test_getInvocations_ClassInstanceCreation_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic static void main(String[] args) {\n\t\tTest test = new Test(false);\n\t}\n\tpublic Test(int value) {\n\t}\n\tpublic Test(boolean value) {\n\t}\n}");
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        List invocations = ExecutionFlowUtils.getInvocations((ExecutionFlowDescription)flowDescription, (MethodDeclaration)target);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_getInvocations_MethodInvocation_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\ttarget(1);\n\t}\n\tpublic void target(int value) {\n\t}\n\tpublic void disconnectedMethod() {\n\t\ttarget(2);\n\t}\n}");
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        List invocations = ExecutionFlowUtils.getInvocations((ExecutionFlowDescription)flowDescription, (MethodDeclaration)target);
        Assertions.assertThat((List)invocations).hasSize(1);
        ExecutionFlowUtilsTest.assertEquals((Object)"target(1)", (Object)this.m_lastEditor.getSource((ASTNode)invocations.get(0)));
    }

    @Test
    public void test_getInvocations_MethodInvocation_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tnotTarget(false);\n\t}\n\tpublic void targetMethod(int value) {\n\t}\n\tpublic void notTarget(boolean value) {\n\t}\n}");
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        MethodDeclaration target = typeDeclaration.getMethods()[1];
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        List invocations = ExecutionFlowUtils.getInvocations((ExecutionFlowDescription)flowDescription, (MethodDeclaration)target);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    public static class ExecutionFlowProvider_RunnableInThread
    extends ExecutionFlowProvider {
        public boolean shouldVisit(AnonymousClassDeclaration anonymous) throws Exception {
            ClassInstanceCreation enclosingCreation;
            ASTNode anonymousCreation;
            return AstNodeUtils.isSuccessorOf((ITypeBinding)anonymous.resolveBinding(), (String)"java.lang.Runnable") && (anonymousCreation = anonymous.getParent()).getLocationInParent() == ClassInstanceCreation.ARGUMENTS_PROPERTY && AstNodeUtils.isSuccessorOf((Expression)(enclosingCreation = (ClassInstanceCreation)anonymousCreation.getParent()), (String)"java.lang.Thread");
        }
    }

    public static class ExecutionFlowProvider_forDefaultConstructor
    extends ExecutionFlowProvider {
        public MethodDeclaration getDefaultConstructor(TypeDeclaration typeDeclaration) {
            for (MethodDeclaration constructor : AstNodeUtils.getConstructors((TypeDeclaration)typeDeclaration)) {
                if (!"<init>(int)".equals(AstNodeUtils.getMethodSignature((MethodDeclaration)constructor))) continue;
                return constructor;
            }
            return null;
        }
    }

    private static interface I_findLastAssignment {
        public ASTNode getExpected(TypeDeclaration var1, MethodDeclaration var2, Statement[] var3);
    }
}

