/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ExposedFieldCreationSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedFieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ExposedFieldCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse_simplestCase() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JButton button = new JButton();", "  public MyPanel() {", "    add(button);", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {field: javax.swing.JButton} {button} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExposedFieldCreationSupportTest.assert_creation((JavaInfo)panel);
        ExposedFieldCreationSupport creationSupport = (ExposedFieldCreationSupport)button.getCreationSupport();
        ExposedFieldCreationSupportTest.assertEquals((Object)panel.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        ExposedFieldCreationSupportTest.assertSame((Object)panel, (Object)creationSupport.getHostJavaInfo());
        ExposedFieldCreationSupportTest.assertEquals((Object)"button", (Object)creationSupport.getField().getName());
        ExposedFieldCreationSupportTest.assertTrue((boolean)creationSupport.isDirect());
        ExposedFieldCreationSupportTest.assertFalse((boolean)creationSupport.canReorder());
        ExposedFieldCreationSupportTest.assertFalse((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_parse_noPrivateField() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton button = new JButton();", "  public MyPanel() {", "    add(button);", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_parse_noNullValue() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JButton button = null;", "  public MyPanel() {", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_parse_noDisconnected() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JButton button = new JButton();", "  public MyPanel() {", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_parse_noRecursion() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JPanel m_this = this;", "  public MyPanel() {", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_parse_JFrame() throws Exception {
        String[] lines = new String[]{"public class Test extends JFrame {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ExposedFieldCreationSupportTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_parse_logicalHierarchy() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JLabel m_label;", "  public final JPanel m_container;", "  public final JButton m_button;", "  public final JCheckBox m_check;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "      {", "        m_button = new JButton();", "        m_container.add(m_button);", "      }", "      {", "        m_check = new JCheckBox();", "        m_container.add(m_check);", "      }", "    }", "    {", "      m_label = new JLabel();", "      add(m_label, BorderLayout.NORTH);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {field: javax.swing.JButton} {m_button} {}", "    {field: javax.swing.JCheckBox} {m_check} {}", "  {field: javax.swing.JLabel} {m_label} {}");
        ExposedFieldCreationSupportTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_reference_SimpleName() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    m_container.setEnabled(false);", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {/m_container.setEnabled(false)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_reference_QualifiedName() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    myPanel.m_container.setEnabled(false);", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myPanel)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: myPanel} {/new MyPanel()/ /add(myPanel)/ /myPanel.m_container/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {field: javax.swing.JPanel} {m_container} {/myPanel.m_container.setEnabled(false)/}", "      {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo container = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        panel.refresh();
        ExposedFieldCreationSupportTest.assertFalse((boolean)container.getComponent().isEnabled());
    }

    @Test
    public void test_reference_logicalChild() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/PanelExpose.java", this.getTestSource("public class PanelExpose extends JPanel {", "  protected final JPanel m_container;", "  protected final JButton m_button;", "  public PanelExpose() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "      m_container.setLayout(null);", "      {", "        m_button = new JButton('Button');", "        m_container.add(m_button);", "        m_button.setBounds(10, 10, 200, 30);", "      }", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends PanelExpose {", "  public Test() {", "    m_button.setEnabled(false);", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.PanelExpose} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {}", "    {implicit-layout: absolute} {implicit-layout} {}", "    {field: javax.swing.JButton} {m_button} {/m_button.setEnabled(false)/}");
    }

    @Test
    public void test_isJavaInfo_fieldHidden() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JButton button = new JButton();", "  public MyPanel() {", "    add(button);", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {field: javax.swing.JButton} {button} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
        SimpleName useName = (SimpleName)this.m_lastEditor.getEnclosingNode("button);");
        ComponentInfo fieldButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExposedFieldCreationSupportTest.assertInstanceOf(ExposedFieldVariableSupport.class, (Object)fieldButton.getVariableSupport());
        ExposedFieldCreationSupportTest.assertFalse((boolean)fieldButton.isRepresentedBy((ASTNode)useName));
        ComponentInfo localButton = (ComponentInfo)panel.getChildrenComponents().get(1);
        ExposedFieldCreationSupportTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)localButton.getVariableSupport());
        ExposedFieldCreationSupportTest.assertTrue((boolean)localButton.isRepresentedBy((ASTNode)useName));
    }

    @Test
    public void test_delete() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(true);", "    m_container.setEnabled(false);", "    m_container.add(new JButton());", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {/setEnabled(true)/}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {/m_container.setEnabled(false)/ /m_container.add(new JButton())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/m_container.add(new JButton())/}");
        ComponentInfo container = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExposedFieldCreationSupportTest.assertTrue((boolean)container.getCreationSupport().canDelete());
        ExposedFieldCreationSupportTest.assertTrue((boolean)container.canDelete());
        container.delete();
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {/setEnabled(true)/}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
    }

    @Test
    public void test_decorateIcon() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    add(new JPanel());", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {/add(new JPanel())/}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JPanel} {empty} {/add(new JPanel())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ComponentInfo exposedContainer = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo innerPanel = (ComponentInfo)panel.getChildrenComponents().get(1);
        ExposedFieldCreationSupportTest.assertSame((Object)exposedContainer.getDescription(), (Object)innerPanel.getDescription());
        ExposedFieldCreationSupportTest.assertSame((Object)innerPanel.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)innerPanel));
        ExposedFieldCreationSupportTest.assertNotSame((Object)exposedContainer.getPresentation().getIcon(), (Object)ObjectInfo.getImageDescriptor((ObjectInfo)exposedContainer));
    }

    @Test
    public void test_isDirect_true() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public final JButton m_button;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "    {", "      m_button = new JButton();", "      add(m_button, BorderLayout.WEST);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {field: javax.swing.JButton} {m_button} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        ExposedFieldCreationSupport creationSupport = (ExposedFieldCreationSupport)button.getCreationSupport();
        ExposedFieldCreationSupportTest.assertSame((Object)panel, (Object)creationSupport.getHostJavaInfo());
        ExposedFieldCreationSupportTest.assertTrue((boolean)creationSupport.isDirect());
    }

    @Test
    public void test_isDirect_false() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public final JButton m_button;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "      {", "        m_button = new JButton();", "        m_container.add(m_button);", "      }", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        ExposedFieldCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {field: javax.swing.JButton} {m_button} {}");
        ContainerInfo container = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)container.getChildrenComponents().get(0);
        ExposedFieldCreationSupport creationSupport = (ExposedFieldCreationSupport)button.getCreationSupport();
        ExposedFieldCreationSupportTest.assertSame((Object)panel, (Object)creationSupport.getHostJavaInfo());
        ExposedFieldCreationSupportTest.assertFalse((boolean)creationSupport.isDirect());
    }

    @Test
    public void test_clipboard() throws Exception {
        ExposedFieldCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JButton m_button;", "  public MyPanel() {", "    {", "      m_button = new JButton();", "      add(m_button);", "    }", "  }", "}"));
        ExposedFieldCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel myPanel_0 = new MyPanel();", "      add(myPanel_0);", "      myPanel_0.m_button.setEnabled(false);", "    }", "  }", "}");
        ExposedFieldCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myPanel_0)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: myPanel_0} {/new MyPanel()/ /add(myPanel_0)/ /myPanel_0.m_button/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {field: javax.swing.JButton} {m_button} {/myPanel_0.m_button.setEnabled(false)/}");
        ComponentInfo myPanel_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)myPanel_0);
        ComponentInfo myPanel_copy = (ComponentInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add(myPanel_copy, null);
        memento.apply();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel myPanel_0 = new MyPanel();", "      add(myPanel_0);", "      myPanel_0.m_button.setEnabled(false);", "    }", "    {", "      MyPanel myPanel_0 = new MyPanel();", "      myPanel_0.m_button.setEnabled(false);", "      add(myPanel_0);", "    }", "  }", "}");
    }
}

