/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout.form.gef;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FormLayoutAlignmentTest
extends RcpGefTest {
    private CompositeInfo shell;
    private ControlInfo button_1;
    private ControlInfo button_2;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_alignLeft() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(0, 150);", "top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Align left edges");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(button_1, 0, SWT.LEFT);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_independentControls() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(0, 150);", "top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(0, 350);", "left = new FormAttachment(0, 150);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_leftParent() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(0, 10);", "top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(0, 210);", "left = new FormAttachment(0, 10);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_rightParent() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(100, -10);", "top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(100, -210);", "right = new FormAttachment(100, -10);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_leftAttached() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(button_1, 0, SWT.LEFT);", "top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(button_1, 200);", "left = new FormAttachment(button_1, 0, SWT.LEFT);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_rightAttached() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(button_1, 0, SWT.RIGHT);", "top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(button_1, -200);", "right = new FormAttachment(button_1, 0, SWT.RIGHT);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_notAttached() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"top = new FormAttachment(0, 200);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(0, 200);", "left = new FormAttachment(0);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_leftRightAttached() throws Exception {
        String[] constraints_1 = new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 150);"};
        this.parse_twoButtons_typical(constraints_1, new String[]{"left = new FormAttachment(button_1, 0, SWT.LEFT);", "top = new FormAttachment(0, 200);", "right = new FormAttachment(button_1, 200, SWT.LEFT);"});
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor_twoButtons_typical(constraints_1, new String[]{"right = new FormAttachment(button_1, 100);", "left = new FormAttachment(button_1, 0, SWT.LEFT);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    @Disabled
    public void test_replicateWidth_leftRightAttached_reverse() throws Exception {
        this.parse_twoButtons_typical(new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 150);"}, new String[]{"left = new FormAttachment(button_1, 0, SWT.LEFT);", "top = new FormAttachment(0, 200);", "right = new FormAttachment(button_1, 200, SWT.LEFT);"});
        this.runAlignmentAction("Replicate width", this.button_2, this.button_1);
        this.assertEditor_twoButtons_typical(new String[]{"left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 100);", "right = new FormAttachment(0, 250);"}, new String[]{"right = new FormAttachment(100, " + (250 - this.shell.getClientArea().width) + ");", "left = new FormAttachment(0, 50);", "top = new FormAttachment(0, 200);"});
    }

    @Test
    public void test_replicateWidth_leftAttachedToRight_rightNotAttached() throws Exception {
        this.parse_twoButtons("public class Test extends Shell {", "  private org.eclipse.swt.widgets.Button button_1;", "  private Control button_2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new org.eclipse.swt.widgets.Button(this, SWT.NONE);", "      button_1.setText('Some long text');", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        data_1.top = new FormAttachment(0, 100);", "        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      button_2 = new Button(this, SWT.NONE);", "      {", "        FormData data_2 = new FormData();", "        data_2.left = new FormAttachment(button_1, 5);", "        data_2.top = new FormAttachment(0, 200);", "        button_2.setLayoutData(data_2);", "      }", "    }", "  }", "}");
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor("public class Test extends Shell {", "  private org.eclipse.swt.widgets.Button button_1;", "  private Control button_2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new org.eclipse.swt.widgets.Button(this, SWT.NONE);", "      button_1.setText('Some long text');", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        data_1.top = new FormAttachment(0, 100);", "        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      button_2 = new Button(this, SWT.NONE);", "      {", "        FormData data_2 = new FormData();", "        data_2.right = new FormAttachment(button_1, " + (5 + this.button_1.getModelBounds().width) + ", SWT.RIGHT);", "        data_2.left = new FormAttachment(button_1, 5);", "        data_2.top = new FormAttachment(0, 200);", "        button_2.setLayoutData(data_2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_replicateWidth_leftAttachedToRight_rightNotAttached_createButton2() throws Exception {
        this.parse("public class Test extends Shell {", "  private org.eclipse.swt.widgets.Button button_1;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new org.eclipse.swt.widgets.Button(this, SWT.NONE);", "      button_1.setText('Some long text');", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        data_1.top = new FormAttachment(0, 100);", "        button_1.setLayoutData(data_1);", "      }", "    }", "  }", "}");
        this.button_1 = (ControlInfo)this.shell.getChildrenControls().get(0);
        this.button_2 = (ControlInfo)this.loadCreationTool("test.Button");
        this.canvas.create(75, 25).sideMode();
        this.canvas.moveTo((Object)this.shell, -100, -100);
        this.canvas.target(this.button_1).outX(5).inY(0).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  private org.eclipse.swt.widgets.Button button_1;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new org.eclipse.swt.widgets.Button(this, SWT.NONE);", "      button_1.setText('Some long text');", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        data_1.top = new FormAttachment(0, 100);", "        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData fd_button = new FormData();", "        fd_button.top = new FormAttachment(button_1, 0, SWT.TOP);", "        fd_button.left = new FormAttachment(button_1, 6);", "        button.setLayoutData(fd_button);", "      }", "    }", "  }", "}");
        this.runAlignmentAction_twoButtons("Replicate width");
        this.assertEditor("public class Test extends Shell {", "  private org.eclipse.swt.widgets.Button button_1;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new org.eclipse.swt.widgets.Button(this, SWT.NONE);", "      button_1.setText('Some long text');", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        data_1.top = new FormAttachment(0, 100);", "        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData fd_button = new FormData();", "        fd_button.right = new FormAttachment(button_1, " + (6 + this.button_1.getModelBounds().width) + ", SWT.RIGHT);", "        fd_button.top = new FormAttachment(button_1, 0, SWT.TOP);", "        fd_button.left = new FormAttachment(button_1, 6);", "        button.setLayoutData(fd_button);", "      }", "    }", "  }", "}");
    }

    private void parse(String ... lines) throws Exception {
        this.prepareComponent(75, 25);
        this.shell = this.openComposite(lines);
    }

    private void parse_twoButtons_typical(String[] constraints_1, String[] constraints_2) throws Exception {
        String[] lines = FormLayoutAlignmentTest.getLines_twoButtons_typical(constraints_1, constraints_2);
        this.parse_twoButtons(lines);
    }

    private void assertEditor_twoButtons_typical(String[] constraints_1, String[] constraints_2) throws Exception {
        String[] lines = FormLayoutAlignmentTest.getLines_twoButtons_typical(constraints_1, constraints_2);
        this.assertEditor(lines);
    }

    private static String[] getLines_twoButtons_typical(String[] constraints_1, String[] constraints_2) {
        constraints_1 = (String[])ArrayUtils.clone((Object[])constraints_1);
        constraints_2 = (String[])ArrayUtils.clone((Object[])constraints_2);
        int i = 0;
        while (i < constraints_1.length) {
            constraints_1[i] = "        data_1." + constraints_1[i];
            ++i;
        }
        i = 0;
        while (i < constraints_2.length) {
            constraints_2[i] = "        data_2." + constraints_2[i];
            ++i;
        }
        Object[] lines = new String[]{"public class Test extends Shell {", "  private Button button_1;", "  private Button button_2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "      {", "        FormData data_1 = new FormData();"};
        lines = (String[])ArrayUtils.addAll((Object[])lines, (Object[])constraints_1);
        lines = (String[])ArrayUtils.addAll((Object[])lines, (Object[])new String[]{"        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      button_2 = new Button(this, SWT.NONE);", "      {", "        FormData data_2 = new FormData();"});
        lines = (String[])ArrayUtils.addAll((Object[])lines, (Object[])constraints_2);
        lines = (String[])ArrayUtils.addAll((Object[])lines, (Object[])new String[]{"        button_2.setLayoutData(data_2);", "      }", "    }", "  }", "}"});
        return lines;
    }

    private void parse_twoButtons(String ... lines) throws Exception {
        this.parse(lines);
        this.button_1 = (ControlInfo)this.shell.getChildrenControls().get(0);
        this.button_2 = (ControlInfo)this.shell.getChildrenControls().get(1);
    }

    private void runAlignmentAction_twoButtons(String actionText) throws Exception {
        this.runAlignmentAction(actionText, this.button_1, this.button_2);
    }

    private void runAlignmentAction(String actionText, ControlInfo ... controls) throws Exception {
        ArrayList actions = new ArrayList();
        List<ControlInfo> selectedObjects = List.of(controls);
        this.shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        IAction action = FormLayoutAlignmentTest.findAction(actions, actionText);
        FormLayoutAlignmentTest.assertNotNull((Object)action);
        action.run();
    }
}

