/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.internal.rcp.model.widgets.AbstractTabFolderInfo;
import org.eclipse.wb.internal.rcp.model.widgets.AbstractTabItemInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TabFolderInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class TabFolderGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_selectItem() throws Exception {
        TabFolderInfo folder = (TabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem item_1 = new TabItem(this, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      TabItem item_2 = new TabItem(this, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        Object item_1 = TabFolderGefTest.getJavaInfoByName("item_1");
        Object item_2 = TabFolderGefTest.getJavaInfoByName("item_2");
        TabFolderGefTest.assertSame(item_1, (Object)folder.getSelectedItem());
        this.canvas.doubleClick(item_2);
        TabFolderGefTest.assertSame(item_2, (Object)folder.getSelectedItem());
    }

    @Test
    public void test_control_canvas_CREATE_whenNoItems() throws Exception {
        TabFolderInfo folder = (TabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadButton();
        this.canvas.moveTo((Object)folder, 5, 100);
        this.canvas.assertEmptyFlowContainerFeedback(folder, true);
        this.canvas.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(this, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_control_canvas_CREATE_beforeItem() throws Exception {
        AbstractTabFolderInfo folder = (AbstractTabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
        AbstractTabItemInfo item = (AbstractTabItemInfo)folder.getItems().get(0);
        this.loadButton();
        this.canvas.moveTo((Object)item, 5, 100);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(item, 1));
        this.canvas.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(this, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
    }

    @Test
    public void test_control_canvas_CREATE_onItem() throws Exception {
        AbstractTabFolderInfo folder = (AbstractTabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
        AbstractTabItemInfo item = (AbstractTabItemInfo)folder.getItems().get(0);
        this.loadButton();
        this.canvas.moveTo((Object)item, 0.5, 0.5);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(item));
        this.canvas.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "      {", "        Button button = new Button(this, SWT.NONE);", "        existingItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_control_tree_CREATE_whenNoItems() throws Exception {
        TabFolderInfo folder = (TabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadButton();
        this.tree.moveOn(folder);
        this.tree.assertFeedback_on(folder);
        this.tree.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(this, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_control_tree_CREATE_beforeItem() throws Exception {
        AbstractTabFolderInfo folder = (AbstractTabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
        AbstractTabItemInfo item = (AbstractTabItemInfo)folder.getItems().get(0);
        this.loadButton();
        this.tree.moveBefore(item);
        this.tree.assertFeedback_before(item);
        this.tree.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(this, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
    }

    @Test
    public void test_control_tree_CREATE_onItem() throws Exception {
        AbstractTabFolderInfo folder = (AbstractTabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
        AbstractTabItemInfo item = (AbstractTabItemInfo)folder.getItems().get(0);
        this.loadButton();
        this.tree.moveOn(item);
        this.tree.assertFeedback_on(item);
        this.tree.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "      {", "        Button button = new Button(this, SWT.NONE);", "        existingItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_item_canvas_CREATE_whenNoItems() throws Exception {
        TabFolderInfo folder = (TabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.TabItem");
        this.canvas.moveTo((Object)folder, 5, 100);
        this.canvas.assertEmptyFlowContainerFeedback(folder, true);
        this.canvas.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "    }", "  }", "}");
    }

    @Test
    public void test_item_canvas_CREATE_beforeItem() throws Exception {
        AbstractTabFolderInfo folder = (AbstractTabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
        AbstractTabItemInfo item = (AbstractTabItemInfo)folder.getItems().get(0);
        this.loadCreationTool("org.eclipse.swt.widgets.TabItem");
        this.canvas.moveTo((Object)item, 5, 100);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(item, 1));
        this.canvas.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "    }", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
    }

    @Test
    public void test_item_tree_CREATE_whenNoItems() throws Exception {
        TabFolderInfo folder = (TabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.TabItem");
        this.tree.moveOn(folder);
        this.tree.assertFeedback_on(folder);
        this.tree.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "    }", "  }", "}");
    }

    @Test
    public void test_item_tree_CREATE_beforeItem() throws Exception {
        AbstractTabFolderInfo folder = (AbstractTabFolderInfo)this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
        AbstractTabItemInfo item = (AbstractTabItemInfo)folder.getItems().get(0);
        this.loadCreationTool("org.eclipse.swt.widgets.TabItem");
        this.tree.moveBefore(item);
        this.tree.assertFeedback_before(item);
        this.tree.click();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem tabItem = new TabItem(this, SWT.NONE);", "      tabItem.setText('New Item');", "    }", "    {", "      TabItem existingItem = new TabItem(this, SWT.NONE);", "      existingItem.setText('Existing item');", "    }", "  }", "}");
    }

    @Test
    public void test_item_canvas_MOVE() throws Exception {
        this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem item_1 = new TabItem(this, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      TabItem item_2 = new TabItem(this, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        Object item_1 = TabFolderGefTest.getJavaInfoByName("item_1");
        Object item_2 = TabFolderGefTest.getJavaInfoByName("item_2");
        this.canvas.beginMove(item_2).dragTo(item_1, 2.0, 0.5);
        this.canvas.endDrag();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem item_2 = new TabItem(this, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "    {", "      TabItem item_1 = new TabItem(this, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
    }

    @Test
    public void test_item_tree_MOVE() throws Exception {
        this.openJavaInfo("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem item_1 = new TabItem(this, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      TabItem item_2 = new TabItem(this, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        Object item_1 = TabFolderGefTest.getJavaInfoByName("item_1");
        Object item_2 = TabFolderGefTest.getJavaInfoByName("item_2");
        this.tree.startDrag(item_2).dragBefore(item_1);
        this.tree.endDrag();
        this.assertEditor("public class Test extends TabFolder {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TabItem item_2 = new TabItem(this, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "    {", "      TabItem item_1 = new TabItem(this, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_canvas_onItem() throws Exception {
        this.openJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "      }", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('button');", "    }", "  }", "}");
        Object item = TabFolderGefTest.getJavaInfoByName("item");
        Object button = TabFolderGefTest.getJavaInfoByName("button");
        this.canvas.beginMove(button).dragTo(item);
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "        {", "          Button button = new Button(folder, SWT.NONE);", "          item.setControl(button);", "          button.setText('button');", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_tree_onItem() throws Exception {
        this.openJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "      }", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('button');", "    }", "  }", "}");
        Object item = TabFolderGefTest.getJavaInfoByName("item");
        Object button = TabFolderGefTest.getJavaInfoByName("button");
        this.tree.startDrag(button).dragOn(item);
        this.tree.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "        {", "          Button button = new Button(folder, SWT.NONE);", "          item.setControl(button);", "          button.setText('button');", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_canvas_beforeItem() throws Exception {
        this.openJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "      }", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('button');", "    }", "  }", "}");
        Object item = TabFolderGefTest.getJavaInfoByName("item");
        Object button = TabFolderGefTest.getJavaInfoByName("button");
        this.canvas.beginMove(button).dragTo(item, 5, 100);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(item, 1));
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem tabItem = new TabItem(folder, SWT.NONE);", "        tabItem.setText('New Item');", "        {", "          Button button = new Button(folder, SWT.NONE);", "          tabItem.setControl(button);", "          button.setText('button');", "        }", "      }", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_tree_beforeItem() throws Exception {
        this.openJavaInfo("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "      }", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('button');", "    }", "  }", "}");
        Object item = TabFolderGefTest.getJavaInfoByName("item");
        Object button = TabFolderGefTest.getJavaInfoByName("button");
        this.tree.startDrag(button).dragBefore(item);
        this.tree.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder folder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem tabItem = new TabItem(folder, SWT.NONE);", "        tabItem.setText('New Item');", "        {", "          Button button = new Button(folder, SWT.NONE);", "          tabItem.setControl(button);", "          button.setText('button');", "        }", "      }", "      {", "        TabItem item = new TabItem(folder, SWT.NONE);", "        item.setText('Item');", "      }", "    }", "  }", "}");
    }
}

