/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class GridLayoutParametersTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_Text() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newText = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
        layout.command_CREATE(newText, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Text_disabled() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("GridLayout.enableGrab", false);
            ControlInfo newText = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
            layout.command_CREATE(newText, 0, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }

    @Test
    public void test_CREATE_Table() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newTable = BTestUtils.createControl("org.eclipse.swt.widgets.Table");
        layout.command_CREATE(newTable, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Table table = new Table(this, SWT.BORDER | SWT.FULL_SELECTION);", "      table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));", "      table.setHeaderVisible(true);", "      table.setLinesVisible(true);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newLabel = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
        layout.command_CREATE(newLabel, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));", "      label.setText('New Label');", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_disabled() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("GridLayout.enableRightAlignment", false);
            ControlInfo newLabel = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
            layout.command_CREATE(newLabel, 0, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('New Label');", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }

    @Test
    public void test_CREATE_Text_afterLabel() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newText = (ControlInfo)GridLayoutParametersTest.createJavaInfo("org.eclipse.swt.widgets.Text");
        layout.command_CREATE(newText, 1, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Text_afterFiller() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newText = (ControlInfo)GridLayoutParametersTest.createJavaInfo("org.eclipse.swt.widgets.Text");
        layout.command_CREATE(newText, 1, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));", "    }", "  }", "}");
    }
}

