/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandsTest
extends Assertions {
    @Test
    public void test_CompoundCommand() throws Exception {
        CompoundCommand command = new CompoundCommand();
        CommandsTest.assertNotNull((Object)command.getCommands());
        CommandsTest.assertTrue((boolean)command.getCommands().isEmpty());
        CommandsTest.assertTrue((boolean)command.isEmpty());
        CommandsTest.assertEquals((int)0, (int)command.size());
        CommandsTest.assertEquals((Object)command.unwrap(), (Object)UnexecutableCommand.INSTANCE);
        command.add(null);
        CommandsTest.assertEquals((int)0, (int)command.size());
        CommandsTest.assertTrue((boolean)command.isEmpty());
        Command dummy = new Command(){};
        command.add(dummy);
        CommandsTest.assertEquals((int)1, (int)command.size());
        CommandsTest.assertFalse((boolean)command.isEmpty());
        CommandsTest.assertSame((Object)dummy, (Object)command.unwrap());
        command.add(new Command(){});
        CommandsTest.assertEquals((int)2, (int)command.size());
        CommandsTest.assertFalse((boolean)command.isEmpty());
        CommandsTest.assertSame((Object)command, (Object)command.unwrap());
        command = new CompoundCommand();
        final int[] counter = new int[1];
        command.add(new Command(){

            public void execute() {
                counter[0] = counter[0] + 1;
            }
        });
        command.add(new Command(){

            public void execute() {
                counter[0] = counter[0] + 1;
            }
        });
        command.execute();
        CommandsTest.assertEquals((int)2, (int)counter[0]);
    }
}

