/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.gef.core.SharedCursors;
import org.eclipse.wb.tests.gef.CursorLogger;
import org.eclipse.wb.tests.gef.GefCursorTestCase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CreationToolCursorTest
extends GefCursorTestCase {
    private CreationTool m_tool;

    public static final Cursor CURSOR_ADD() {
        return SharedCursors.CURSOR_ADD;
    }

    public static final Cursor CURSOR_NO() {
        return SharedCursors.CURSOR_NO;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ICreationFactory factory = new ICreationFactory(){

            public void activate() {
            }

            public Object getNewObject() {
                return "_NewObject_";
            }

            public String toString() {
                return "TestFactory";
            }
        };
        this.m_tool = new CreationTool(factory);
        this.m_domain.setActiveTool((Tool)this.m_tool);
    }

    @Test
    public void test_work_updateCursors_Move() throws Exception {
        EditPart shellEditPart = CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        EditPart buttonEditPart = CreationToolCursorTest.createEditPart(shellEditPart, 100, 100, 200, 100, null);
        this.m_viewer.select(buttonEditPart);
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(10, 10);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(30, 30);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(10, 40);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(90, 90);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(130, 130);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(120, 120);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(140, 120);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(450, 350);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_work_updateCursors_Accept_Click() throws Exception {
        EditPart shellEditPart = CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        EditPart buttonEditPart = CreationToolCursorTest.createEditPart(shellEditPart, 100, 100, 200, 100, null);
        this.m_viewer.select(buttonEditPart);
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(30, 30);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(50, 50, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(60, 60);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(120, 120);
        this.m_sender.dragTo(140, 120);
        this.m_sender.dragTo(140, 130);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_work_updateCursors_Not_Accept_Click() throws Exception {
        EditPart shellEditPart = CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        EditPart buttonEditPart = CreationToolCursorTest.createEditPart(shellEditPart, 100, 100, 200, 100, null);
        this.m_viewer.select(buttonEditPart);
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        CursorLogger expectedLogger = new CursorLogger();
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(130, 130);
        this.m_actualLogger.assertEmpty();
        this.m_sender.startDrag(130, 130, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(130, 120);
        this.m_sender.dragTo(120, 120);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(110, 110);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_work_updateCursors_Accept_Move_InvalidInputClick() throws Exception {
        CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(50, 50);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.click(60, 60, 2);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_work_updateCursors_Accept_Drag_InvalidInputClick() throws Exception {
        CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(50, 50);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(60, 60, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(70, 70);
        this.m_actualLogger.assertEmpty();
        this.m_sender.click(70, 70, 2);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_work_updateCursors_Accept_Drag_InvalidInputDrag() throws Exception {
        CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(50, 50);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(60, 60, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(70, 70);
        this.m_actualLogger.assertEmpty();
        this.m_sender.startDrag(70, 70, 2);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.dragTo(80, 80);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_work_updateCursors_Accept_Click_Again_Activate_SelectionTool() throws Exception {
        CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(50, 50);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_defaultToolProvider = new GefCursorTestCase.IDefaultToolProvider(){

            @Override
            public org.eclipse.wb.gef.core.tools.Tool getDefaultTool() {
                return new SelectionTool();
            }
        };
        this.m_sender.click(60, 60, 1);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_work_updateCursors_Accept_Click_Again_Activate_CreationTool() throws Exception {
        CreationToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, new Command(){});
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(50, 50);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_tool = new CreationTool(this.m_tool.getFactory());
        this.m_defaultToolProvider = new GefCursorTestCase.IDefaultToolProvider(){

            @Override
            public org.eclipse.wb.gef.core.tools.Tool getDefaultTool() {
                return CreationToolCursorTest.this.m_tool;
            }
        };
        this.m_sender.click(60, 60, 1);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_ADD());
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    private static final EditPart createEditPart(EditPart parentEditPart, int x, int y, int width, int height, Command acceptCreateCommand) throws Exception {
        return CreationToolCursorTest.createEditPart(parentEditPart, x, y, width, height, acceptCreateCommand, null);
    }
}

