/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.workbench.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xwt.DefaultLoadingContext;
import org.eclipse.xwt.ILoadingContext;
import org.eclipse.xwt.INamespaceHandler;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTLoader;
import org.eclipse.xwt.css.CSSHandler;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.ui.workbench.IContentPart;

public abstract class XWTAbstractPart
implements IContentPart {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private boolean constructing = true;
    private boolean xwtCaching = true;
    @Inject
    private Composite parent;
    @Inject
    private IStylingEngine engine;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    private IEclipseContext context;
    protected Object dataContext;

    static {
        try {
            XWT.registerNamespaceHandler((String)"http://www.eclipse.org/css", (INamespaceHandler)CSSHandler.handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    @Inject
    public void setContext(IEclipseContext context) {
        if (context == null) {
            return;
        }
        this.context = context;
    }

    @PostConstruct
    private final void partPostConstruct() {
        this.constructing = false;
    }

    public boolean isConstructing() {
        return this.constructing;
    }

    public IStylingEngine getStyleEngine() {
        return this.engine;
    }

    public boolean isXWTCaching() {
        return this.xwtCaching;
    }

    public void setXWTCaching(boolean pmfCaching) {
        this.xwtCaching = pmfCaching;
    }

    public EHandlerService getHandlerService() {
        return this.handlerService;
    }

    public ECommandService getCommandService() {
        return this.commandService;
    }

    @Override
    public Object getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(Object dataContext) {
        this.dataContext = dataContext;
    }

    public Composite getParent() {
        return this.parent;
    }

    @Inject
    public void setParent(Composite parent) {
        if (parent != null && this.parent == null) {
            this.parent = parent;
            parent.getShell().setBackgroundMode(1);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected void refresh(URL url, Object dataContext, ClassLoader loader) {
        if (this.parent == null || this.isConstructing()) {
            return;
        }
        this.parent.setVisible(false);
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                XWT.setLoadingContext((ILoadingContext)new DefaultLoadingContext(loader));
                HashMap<String, Object> newOptions = new HashMap<String, Object>();
                newOptions.put("XWT.Container", this.parent);
                newOptions.put("XWT.DataContext", dataContext);
                newOptions.put("XWT.Class", this);
                if (this.isXWTCaching()) {
                    newOptions.put(XWTLoader.XML_CACHE_PROPERTY, this);
                }
                XWT.loadWithOptions((URL)url, newOptions);
                GridLayoutFactory.fillDefaults().generateLayout(this.parent);
                this.parent.layout(true, true);
            }
            catch (Exception e) {
                LoggerManager.log((Throwable)e);
                Thread.currentThread().setContextClassLoader(classLoader);
                this.parent.setVisible(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.parent.setVisible(true);
        }
    }

    public Shell getShell() {
        return this.parent.getShell();
    }
}

