/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;

public final class PropertyEventDispatcher {
    private final Map fHandlerMap = new HashMap();
    private final Map fReverseMap = new HashMap();
    private final DBPPreferenceStore fStore;
    private final DBPPreferenceListener fListener = new DBPPreferenceListener(){

        public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
            PropertyEventDispatcher.this.firePropertyChange(event);
        }
    };

    public PropertyEventDispatcher(DBPPreferenceStore store) {
        Assert.isLegal((store != null ? 1 : 0) != 0);
        this.fStore = store;
    }

    public void dispose() {
        if (!this.fReverseMap.isEmpty()) {
            this.fStore.removePropertyChangeListener(this.fListener);
        }
        this.fReverseMap.clear();
        this.fHandlerMap.clear();
    }

    private void firePropertyChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        Object value = this.fHandlerMap.get(event.getProperty());
        if (value instanceof DBPPreferenceListener) {
            ((DBPPreferenceListener)value).preferenceChange(event);
        } else if (value instanceof Set) {
            Iterator it = ((Set)value).iterator();
            while (it.hasNext()) {
                ((DBPPreferenceListener)it.next()).preferenceChange(event);
            }
        }
    }

    public void addPropertyChangeListener(String property, DBPPreferenceListener listener) {
        Assert.isLegal((property != null ? 1 : 0) != 0);
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        if (this.fReverseMap.isEmpty()) {
            this.fStore.addPropertyChangeListener(this.fListener);
        }
        this.multiMapPut(this.fHandlerMap, property, listener);
        this.multiMapPut(this.fReverseMap, listener, property);
    }

    private void multiMapPut(Map map, Object key, Object value) {
        Object mapping = map.get(key);
        if (mapping == null) {
            map.put(key, value);
        } else if (mapping instanceof Set) {
            ((Set)mapping).add(value);
        } else {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            set.add(mapping);
            set.add(value);
            map.put(key, set);
        }
    }

    private void multiMapRemove(Map map, Object key, Object value) {
        Object mapping = map.get(key);
        if (mapping instanceof Set) {
            ((Set)mapping).remove(value);
        } else if (mapping != null) {
            map.remove(key);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        Object value = this.fReverseMap.get(listener);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.fReverseMap.remove(listener);
            this.multiMapRemove(this.fHandlerMap, value, listener);
        } else if (value instanceof Set) {
            this.fReverseMap.remove(listener);
            Iterator it = ((Set)value).iterator();
            while (it.hasNext()) {
                this.multiMapRemove(this.fHandlerMap, it.next(), listener);
            }
        }
        if (this.fReverseMap.isEmpty()) {
            this.fStore.removePropertyChangeListener(this.fListener);
        }
    }
}

