/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.EventPump;
import foxtrot.JREVersion;
import foxtrot.Job;
import foxtrot.Task;
import foxtrot.WorkerThread;
import foxtrot.pumps.JDK13QueueEventPump;
import foxtrot.pumps.SunJDK140ConditionalEventPump;
import foxtrot.pumps.SunJDK141ConditionalEventPump;
import foxtrot.workers.DefaultWorkerThread;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;

public class Worker {
    private static EventPump eventPump;
    private static WorkerThread workerThread;
    static final boolean debug = false;
    static /* synthetic */ Class class$foxtrot$Worker;

    private Worker() {
    }

    public static Object post(Task task) throws Exception {
        Worker.initializeWorkerThread();
        Worker.initializeEventPump();
        boolean isEventThread = SwingUtilities.isEventDispatchThread();
        if (!isEventThread && !workerThread.isWorkerThread()) {
            throw new IllegalStateException("Worker.post() can be called only from the AWT Event Dispatch Thread or from another Task");
        }
        if (!workerThread.isAlive()) {
            workerThread.start();
        }
        if (isEventThread) {
            workerThread.postTask(task);
            eventPump.pumpEvents(task);
        } else {
            workerThread.runTask(task);
        }
        try {
            Object object = task.getResultOrThrow();
            Object var4_3 = null;
            task.reset();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            task.reset();
            throw throwable;
        }
    }

    public static Object post(Job job) {
        try {
            return Worker.post((Task)job);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x.toString());
        }
        catch (Error x) {
            throw x;
        }
    }

    public static EventPump getEventPump() {
        Worker.initializeEventPump();
        return eventPump;
    }

    public static void setEventPump(EventPump eventPump) {
        if (eventPump == null) {
            throw new IllegalArgumentException("EventPump cannot be null");
        }
        Worker.eventPump = eventPump;
    }

    public static WorkerThread getWorkerThread() {
        Worker.initializeWorkerThread();
        return workerThread;
    }

    public static void setWorkerThread(WorkerThread workerThread) {
        if (workerThread == null) {
            throw new IllegalArgumentException("WorkerThread cannot be null");
        }
        Worker.workerThread = workerThread;
    }

    private static void initializeWorkerThread() {
        if (workerThread != null) {
            return;
        }
        String workerThreadClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("foxtrot.worker.thread");
            }
        });
        if (workerThreadClassName == null) {
            workerThread = new DefaultWorkerThread();
        } else {
            ClassLoader loader = (class$foxtrot$Worker == null ? (class$foxtrot$Worker = Worker.class$("foxtrot.Worker")) : class$foxtrot$Worker).getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            try {
                workerThread = (WorkerThread)loader.loadClass(workerThreadClassName).newInstance();
            }
            catch (Throwable x) {
                workerThread = new DefaultWorkerThread();
            }
        }
    }

    private static void initializeEventPump() {
        if (eventPump != null) {
            return;
        }
        String eventPumpClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("foxtrot.event.pump");
            }
        });
        if (eventPumpClassName != null) {
            ClassLoader loader = (class$foxtrot$Worker == null ? (class$foxtrot$Worker = Worker.class$("foxtrot.Worker")) : class$foxtrot$Worker).getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            try {
                eventPump = (EventPump)loader.loadClass(eventPumpClassName).newInstance();
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (JREVersion.isJRE141()) {
            eventPump = new SunJDK141ConditionalEventPump();
        } else if (JREVersion.isJRE140()) {
            eventPump = new SunJDK140ConditionalEventPump();
        } else if (JREVersion.isJRE13() || JREVersion.isJRE12()) {
            eventPump = new JDK13QueueEventPump();
        } else {
            throw new Error("JDK 1.1 is not supported");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

